/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Floor
extends Function {
    private Expression expr;

    public F_Floor(Expression e) {
        this.expr = e;
        this.returnType = this.expr.getReturnType();
    }

    public Object evaluate(Tuple t) {
        Object val = this.expr.evaluate(t);
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return new Double(Math.floor((Double)val));
        }
        if (val instanceof Float) {
            return new Float(Math.floor(((Float)val).floatValue()));
        }
        if (val instanceof Integer) {
            return val;
        }
        if (val instanceof Number) {
            return new Double(Math.floor(((Number)val).doubleValue()));
        }
        return null;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_NUMBER};
    }

    public static String getFunctionName() {
        return "FLOOR";
    }

    public String toString(Relation relation) {
        return "FLOOR(" + this.expr.toString(relation) + ")";
    }
}

