@echo off

rem Ŀ
rem                       BACKUP.BAT                                     
rem                                                                      
rem   Sample batch file to make automated backups with a different tape  
rem   each week. On mondays a backup using the setup FULL is being made, 
rem   other days use the setup DAILY.                                    
rem   This batch file requires the programs XSET (shareware, by Marc     
rem   Stern) or any other that can put the time and date in an           
rem   environment variabele, and the program TAPESCH, to calculate the   
rem   tape number to use.                                                
rem                                                                      
rem   Instructions:                                                      
rem                                                                      
rem   put the name of your backup program in the 'PUT PERSONAL...'       
rem   section. It is assumed that this backup program accepts a          
rem   command line option that selects a setup file.                     
rem   FILENAME is the name of a text file were backups are logged.       
rem 

rem put date and time in environment variables
rem (only needed for proper log file)
Xset DATE date
Xset TIME time

rem --------------------- PUT PERSONAL SETTINGS HERE -----------------------
set backup_prog=c:\backtool\mybackup
set filename=backup.log
rem ------------------------------------------------------------------------

tapesch /n=3

IF ERRORLEVEL 31 GOTO Mon_3
IF ERRORLEVEL 30 GOTO Week_3
IF ERRORLEVEL 21 GOTO Mon_2
IF ERRORLEVEL 20 GOTO Week_2
IF ERRORLEVEL 11 GOTO Mon_1
IF ERRORLEVEL 10 GOTO Week_1
If ERRORLEVEL 0  GOTO Error

:Mon_3
set backup_type=FULL
set tapenr=3
goto make_backup

:Week_3
set backup_type=DAILY
set tapenr=3
goto make_backup

:Mon_2
set backup_type=FULL
set tapenr=2
goto make_backup

:Week_2
set backup_type=DAILY
set tapenr=2
goto make_backup

:Mon_1
set backup_type=FULL
set tapenr=1
goto make_backup

:Week_1
set backup_type=DAILY
set tapenr=1
goto make_backup

:Error
Echo Error occured in Tapesch
echo ------------------------------------------------------ >> %filename%
Echo %DATE% %TIME% error occured in tapesch; no backup made >> %filename%
goto end


:make_backup
echo ----------------------------------------------------  >> %filename%
Echo %DATE% %TIME% Starting %type% backup on Tape %tapenr% >> %filename%
rem call backup program:
%backup_prog% %backup_type%
Xset TIME time
echo backup succesfull ended on  %TIME%.                   >> %filename%

:end
rem clear environment variables
set time=
set date=
set backup_prog=
set backup_type=
set filename=
set tapenr=
