/* sig1.c (emx+gcc) */

/* Expected output: +s-+s--+s+s+s-x */

#include <stdio.h>

#ifdef __EMX__
#include <signal.h>
#else
#include <sys\_signal.h>
#endif

volatile int ack;

void handler (int sig)
{
  putchar ('s');
  fflush(stdout);
  if (ack)
    signal (sig, SIG_ACK);
}

void make_stack (void)
{
}

int main (void)
{
  make_stack ();
  setbuf(stdout,NULL);
  if (signal (SIGINT, handler) == SIG_ERR)
    {
      puts ("signal failed");
      return (1);
    }
  ack = 0;
  putchar ('+');
  raise (SIGINT);   /* +s */
  putchar ('-');
  raise (SIGINT);   /* - , maske aus */
  putchar ('+');
  signal (SIGINT, SIG_ACK);  /* maske an , ->raise */
  putchar ('-');
  raise (SIGINT);   /* - , maske aus */
  putchar ('-');
  raise (SIGINT);   /* - , maske aus */
  ack = 1;
  putchar ('+');
  signal (SIGINT, SIG_ACK);
  putchar ('+');
  raise (SIGINT);
  putchar ('+');
  raise (SIGINT);
  signal (SIGINT, SIG_IGN);
  putchar ('-');
  raise (SIGINT);
  signal (SIGINT, SIG_DFL);
  putchar ('x');
  /* signal (SIGINT, SIG_ACK); */
  raise (SIGINT);
  return (0);
}
