/* ------------------------------ comlib.c ---------------------------------- */
/*									      */
/* -------------------------------------------------------------------------- */

#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>

#include "com.h"

static void far
outc (int d)
{
   putch (d);
}

extern void far
out_hex (int h)
{
	outc (h + (h < 10 ? '0' : ('A' - 10)));
}

extern void far
out_byte (int b)
{
	out_hex (b / 16);
	out_hex (b % 16);
}

extern void far
put_hex (int port, int h)
{
	comout (port, h + (h < 10 ? '0' : ('A' - 10)));
}

extern void far
put_byte (int port, int b)
{
	put_hex (port, b / 16);
	put_hex (port, b % 16);
}

extern int far
comoutin (int port, int c)
{
   register int d;

   while ((d = comin (port)) != -1) {
	if (isprint (d) || d == '\n' || d == '\r' || d == '\t')
		outc (d);
	else {
		outc ('[');
		out_byte (d);
		outc (']');
	}
   }

   if (c)
      return (comout (port, c));
   else
      return (0);
}

extern int far
comouts (int port, char *line)
{
   register char *p, d;
   int c;

   for (p = line; d = *p; ++p) {
      while (comoutin (port, d) == -1) {
	 for (;;) {
	    puts ("\n+\tTimeout error. Retry (y/n) ? ");
	    if ((c = getche ()) == 'n' || c == 'N')
	       return (-1);
	    if (c  == 'y' || c == 'Y')
	       break;
	 }
      }
   }
   return (0);
}

static char	far cbuf[1024];

extern void far
comprintf (int port, char *format, int p0, int p1, int p2, int p3, int p4,
	int p5, int p6, int p7, int p8, int p9, int p10, int p11, int p12,
	int p13, int p14, int p15)
{
	sprintf (cbuf, format, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10,
		p11, p12, p13, p14, p15);
	comouts (port, cbuf);
}

extern int far
time_diff (struct dostime_t f, struct dostime_t t)
{
   long d;

   d = ( ( (t.hour - f.hour) * 60L +
	   t.minute - f.minute) * 60L +
	 t.second - f.second	 ) * 100L +
       t.hsecond - f.hsecond ;

   if (d < 0)
      d += 24L * 60L * 60L * 100L;

   return ((int)d);
}

extern void far
sleep (int t)			/* t 1/100s second */
{
   struct dostime_t this_time, last_time;

   _dos_gettime (&last_time);
   do {
      _dos_gettime (&this_time);
   } while (time_diff (last_time, this_time) < t);
}

extern void far
pause (int n)			/* n milliseconds */
{
	long	l;

	for (l = n * 150L; l > 0; --l)
		n *= 12345;
}

extern int far
port_start (int port, long speed, int parity, int bits, int stop, int xmode)
{
	if (port >= 0) {
		setcomm (port, speed, parity, bits, stop, xmode);
		return (cominit (port));
	}
	return (0);
}

extern int far
com_start (int port, long speed, int parity, int bits, int stop, int xmode)
{
	intinit ();
	save_vec ();
	brk_off ();
	return (port_start (port, speed, parity, bits, stop, xmode));
}

extern void far
port_stop (int port)
{
	if (port >= 0) {
		commoff (port);
	}
}

extern void far
com_stop (int port)
{
	port_stop (port);
	rstr_vec ();
	brk_on ();
}
