/* Turbo C Driver for FTP Software's packet driver interface.
 * Graciously donated to the public domain by Phil Karn.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "pktdrvr.h"

extern int	Derr = 0;

/* Test for the presence of a packet driver at an interrupt number.
 * Return 0 if no packet driver.
 */

#define	DRVR_SIG	"PKT DRVR"

#define	intdrvr(i,rr,sr)	int86x (i, &rr, &rr, &sr)

extern int far
test_for_pd (unsigned int intno)
{
	union {
		void	(INTERRUPT far *addr)();
		char	far *name;
	}	drvvec;

	drvvec.addr = _dos_getvect (intno);
	return (!memcmp (DRVR_SIG, drvvec.name+3, sizeof (DRVR_SIG)));
}

extern int far
driver_info (int intno, int handle, int *version, int *class, int *type,
	int *number, char **name, int *basic)
{
	union REGS regs;
	struct SREGS sregs;

	segread (&sregs);
	regs.x.bx = handle;
	regs.h.ah = DRIVER_INFO;
	regs.h.al = 0xff;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	}
	if (version != NULL)
		*version = regs.x.bx;
	if (class != NULL)
		*class = regs.h.ch;
	if (type != NULL)
		*type = regs.x.dx;
	if (number != NULL)
		*number = regs.h.cl;
	if (name != NULL) {
		FP_SEG (*name) = sregs.ds;
		FP_OFF (*name) = regs.x.si;
	}
	if (basic != NULL)
		*basic = regs.h.al;
	return 0;
}

extern int far
access_type (int intno, int if_class, int if_type, int if_number,
	char far *type, unsigned typelen,
	void (INTERRUPT *receiver) __ARGS((void)))
{
	union REGS regs;
	struct SREGS sregs;

	segread (&sregs);
	regs.h.dl = (char)if_number;	/* Number */
	sregs.ds = FP_SEG(type);	/* Packet type template */
	regs.x.si = FP_OFF(type);
	regs.x.cx = typelen;		/* Length of type */
	sregs.es = FP_SEG(receiver);	/* Address of receive handler */
	regs.x.di = FP_OFF(receiver);
	regs.x.bx = if_type;		/* Type */
	regs.h.ah = ACCESS_TYPE;	/* Access_type() function */
	regs.h.al = (char)if_class;	/* Class */
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	} else
		return regs.x.ax;
}

extern int far
release_type (int intno, int handle)
{
	union REGS regs;
	struct SREGS sregs;

	segread (&sregs);
	regs.x.bx = handle;
	regs.h.ah = RELEASE_TYPE;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	} else
		return 0;
}

extern int far
send_pkt (int intno, char far *buffer, unsigned length)
{
	union REGS regs;
	struct SREGS sregs;

	segread (&sregs);
	sregs.ds  = FP_SEG(buffer);
	sregs.es  = FP_SEG(buffer); /* for buggy univation pkt driver - CDY */
	regs.x.si = FP_OFF(buffer);
	regs.x.cx = length;
	regs.h.ah = SEND_PKT;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	} else
		return 0;
}

extern int far
drvr_terminate (int intno, int handle)
{
	union REGS	regs;
	struct SREGS	sregs;

	segread (&sregs);
	regs.x.bx = handle;
	regs.h.ah = TERMINATE;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	}
	return 0;
}

extern int far
get_address (int intno, int handle, char *buf, int len)
{
	union REGS	regs;
	struct SREGS	sregs;

	segread (&sregs);
	sregs.es  = FP_SEG (buf);
	regs.x.di = FP_OFF (buf);
	regs.x.cx = len;
	regs.x.bx = handle;
	regs.h.ah = GET_ADDRESS;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	}
	return 0;
}

extern int far
reset_interface (int intno, int handle)
{
	union REGS	regs;
	struct SREGS	sregs;

	segread (&sregs);
	regs.x.bx = handle;
	regs.h.ah = RESET_INTERFACE;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	}
	return 0;
}

extern int far
get_parameters(int intno, struct param **params)
{
	union REGS	regs;
	struct SREGS	sregs;

	if (!params)
		return (-2);

	segread (&sregs);
	regs.h.ah = GET_PARAMETERS;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	}
	FP_SEG (*params) = sregs.es;
	FP_OFF (*params) = regs.x.di;
	return 0;
}

extern int far
set_address (int intno, char *addr, int len)
{
	union REGS	regs;
	struct SREGS	sregs;

	segread (&sregs);
	sregs.es  = FP_SEG (addr);
	regs.x.di = FP_OFF (addr);
	regs.x.cx = len;
	regs.h.ah = SET_ADDRESS;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	}
	return 0;
}

extern int far
get_statistics (int intno, int handle, struct statistics **addr)
{
	union REGS	regs;
	struct SREGS	sregs;

	if (!addr)
		return -2;

	segread (&sregs);
	regs.x.bx = handle;
	regs.h.ah = GET_STATISTICS;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	}
	FP_SEG(*addr) = sregs.es;
	FP_OFF(*addr) = regs.x.di;
	return 0;
}

extern int far
as_send_pkt (int intno, char far *buffer, unsigned length,
	void (INTERRUPT *upcall) __ARGS((void)))
{
	union REGS regs;
	struct SREGS sregs;

	segread (&sregs);
	sregs.ds  = FP_SEG(buffer);
	regs.x.si = FP_OFF(buffer);
	regs.x.cx = length;
	sregs.es  = FP_SEG(upcall);
	regs.x.di = FP_OFF(upcall);
	regs.h.ah = AS_SEND_PKT;
	intdrvr (intno, regs, sregs);
	if (regs.x.cflag) {
		Derr = regs.h.dh;
		return -1;
	} else
		return 0;
}
