#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "pktdrvr.h"

extern void INTERRUPT far pkint0 __ARGS((void));
extern void pkset (void (far *receiver)(), int far *stk);

typedef unsigned short ushort;

static int far
find_driver (void)
{
	int	i;

	for (i = 0x0060; i < 0x0080; ++i)
		if (test_for_pd (i))
			return (i);
	return (-1);
}

static unsigned char far pktbuff[1024];
static int	col = 0;

static void far
receiver (int dev, ushort di, ushort si, ushort bp, ushort dx, ushort cx,
	ushort bx, ushort ax, ushort ds, ushort es)
{
	unsigned char far *buffer = pktbuff;
	int	t, tt;

	switch (ax) {
	case 0:				/* Space allocate call */
		if (cx <= sizeof (pktbuff)) {
			es = FP_SEG (buffer);
			di = FP_OFF (buffer);
		} else
			es = di = 0;
		break;
	case 1:				/* Packet complete call */
#if 0
		if (col++ == 8) {
			putch ('\n');
			col = 0;
		}
		t = pktbuff[14];
		tt = t/16;	putch (tt > 9 ? tt+'a'-10 : tt+'0');
		tt = t&15;	putch (tt > 9 ? tt+'a'-10 : tt+'0');
		t = pktbuff[15];
		tt = t/16;	putch (tt > 9 ? tt+'a'-10 : tt+'0');
		tt = t&15;	putch (tt > 9 ? tt+'a'-10 : tt+'0');
		t = pktbuff[16];
		tt = t/16;	putch (tt > 9 ? tt+'a'-10 : tt+'0');
		tt = t&15;	putch (tt > 9 ? tt+'a'-10 : tt+'0');
		putch (' ');
#else
		putchar ('*');
#endif
		break;
	default:
		break;
	}
}

#define	STKSIZE	2048
static int	*stack = 0, handle = -1, pktint;

static void far
die (int n)
{
	int	rc;

	if (-1 != pktint  -1 != handle) {
		rc = release_type (pktint, handle);
		if (-1 == rc)
			printf ("release_type failed %d\n", Derr);
		else
			printf ("Handle released\n");
		handle = -1;
	}

	if (stack) {
		free (stack);
		stack = 0;
	}

	exit (n);
}

main ()
{
	int	ch, rc;

	pktint = find_driver ();
	if (-1 == pktint) {
		printf ("no driver\n");
		die (1);
	}
	printf ("Driver found at 0x%0x\n", pktint);

	if (!(stack = (int *)malloc (STKSIZE * sizeof (int)))) {
		printf ("malloc filed\n");
		die (1);
	}

	pkset (receiver, stack+STKSIZE);

	handle = access_type (pktint, CL_ETHERNET, ANYTYPE, 0,
		(char far *)0, 0, pkint0);
	if (-1 == handle) {
		printf ("access_type failed %d\n", Derr);
		die (1);
	}
	for (;;) {
		if (kbhit()) {
			ch = getch ();
			if (0x1b == ch || 't'-'a'+1 == ch)
				break;
		}
	}

	if ('t'-'a'+1 == ch) {
		rc = terminate (pktint, handle);
		if (-1 == rc)
			printf ("terminate failed %d\n", Derr);
		else {
			printf ("Driver terminated\n");
			handle = -1;
		}
	}

	die (0);
}
