/* This is file gr.h
*/

#define VGA_PAGE	((unsigned char far *)0xa0000000L)
#define VGA_PAGE_END	((unsigned char far *)0xb0000000L)
#define VGA_PAGE_SIZE	0x10000L

#define GRT_MASK	0x00ff
#define GRT_NONE	0x0000
#define GRT_VESA	0x0001
#define GRT_ATI		0x0002
#define GRT_AHEADA	0x0003
#define GRT_AHEADB	0x0004
#define GRT_CHIPS	0x0005
#define GRT_EVEREX	0x0006
#define GRT_GENOA	0x0007
#define GRT_OAK		0x0008
#define GRT_PARADISE	0x0009
#define GRT_TRIDENT88	0x000a
#define GRT_TRIDENT89	0x000b
#define GRT_VIDEO7	0x000c
#define GRT_ET3000	0x000d
#define GRT_ET4000	0x000e
#define GRT_NCR		0x000f
#define GRT_S3		0x0010
#define GRT_ACUMOS	0x0011
#define GRT_AL2101	0x0012
#define GRT_MXIC	0x0013
#define GRT_P2000	0x0014
#define GRT_RT3106	0x0015
#define GRT_CIRRUS	0x0016

/* or a color with Gr* to set the write mode
*/
#define GrXOR		0x100
#define GrOR		0x200
#define GrNOCOLOR	0x400

typedef enum GR_graphics_modes {
  GR_80_25_text,
  GR_default_text,
  GR_width_height_text,
  GR_biggest_text,
  GR_320_200_graphics,
  GR_default_graphics,
  GR_width_height_graphics,
  GR_biggest_noninterlaced_graphics,
  GR_biggest_graphics
} GR_graphics_modes;

extern void far movw (); /*int length, int fbase, int from, int tbase, int to*/
extern void far GrSetWriteMode (int mode);
extern void far	GrSetActive (long base);
extern void far	GrSetVisual (long base);
extern int far	GrVsync (void);
extern void far	GrSetType (unsigned int type, unsigned int nbanks, 
				unsigned int width);
extern int far	GrSetMode (enum GR_graphics_modes mode, int w, int h);
extern int far	GrSetBiosMode (int mode);
extern void far	GrSetColor (int color, int r, int g, int b);
extern int far	GrAllocColor (int r, int g, int b); /* shared, read-only */
extern int far	GrAllocCell (void); /* unshared, read-write */
extern void far	GrQueryColor (int n, int *r, int *g, int *b);
extern void far	GrFreeColor (int c);
extern int far	GrWhite (void);
extern int far	GrBlack (void);

extern void far	GrPlot (int x, int y, int c);
extern int far	GrPixel (int x, int y);

extern void far	GrSetXY (int x, int y);
extern int far	GrMaxX (void);
extern int far	GrMaxY (void);
extern int far	GrSizeX (void);
extern int far	GrSizeY (void);

extern void far GrFontSet (char *text);

extern void far GrText (char *text);
extern void far GrTextPut (int c);
extern void far	GrTextChar (int c);
extern void far GrTextF (char *text);
extern void far	GrTextXY (int x, int y, char *text, int fg, int bg);
extern void far	GrTextSet (int x, int y, int fg, int bg, int max, int my);
extern void far	GrTextColor (int fg, int bg);
extern void far	GrTextWin (int xl, int xh, int yl, int yh, int border, int bg);
extern void far	GrTextGet (int *x, int *y, int *fg, int *bg, int *max, int *my);
extern int far	GrTextPush (void);
extern int far	GrTextPop (void);
extern int far	GrTextRow (int row);
extern int far	GrTextCol (int col);
extern void far	GrTextGoto (int row, int col);
extern void far	GrTextClear (void);
extern void far	GrCursorSet (unsigned char far *c, int s, int e);
extern void far	GrCursorGet (unsigned char *far *c, int *mode);
extern int far	GrCursorMode (int mode);
extern void far	GrCursorInsMode (int mode);
extern void far	GrScrollOn (void);
extern void far	GrScrollOff (void);
extern void far	GrScroll (int n);
extern int far	gprintf (const char *fmt, ...);

extern void far	GrCopy (int xf, int yf, int xt, int yt, int w, int h);
extern void far	GrClear (int x, int y, int w, int h, unsigned int c);
extern void far	GrMove (int xf, int yf, int xt, int yt, int w, int h, unsigned int c);

extern void far	GrMemGet (unsigned char *p, int xf, int yf, int w, int h);
extern void far	GrMemPut (int xt, int yt, int w, int h, unsigned char *p);

extern void far	GrLine (int x1, int y1, int x2, int y2, unsigned int c);
extern void far	GrMoveTo (int x1, int y1);
extern void far	GrDrawTo (int x2, int y2, unsigned int c);
extern void far	GrEllipse (int x, int y, int irx, int iry, unsigned int c);

extern long ActiveBase;
