.\" p2c  Copyright 1989 Dave Gillespie
.TH P2C 1 "local"
.SH NAME
p2c \- Pascal to C translator, version 1.14
.SH SYNOPSIS
.B p2c
[ options ] [ file [ module ] ]
.SH DESCRIPTION
.I P2c
is a tool for translating Pascal programs into C.  The input consists
of a set of source files in any of the following Pascal dialects:
HP Pascal, Turbo/UCSD Pascal, DEC VAX Pascal, Oregon Software Pascal/2,
Macintosh Programmer's Workshop Pascal, Sun/Berkeley Pascal.
Modula-2 syntax is also supported.  Output is a set of
.B .c
and
.B .h
files that comprise an equivalent program in any of several dialects
of C.  Output code may be kept machine- and dialect-independent, or
it may be targeted to a specific machine and compiler.  Most reasonable
Pascal programs are converted into fully functional C which will compile
and run with no further modifications, although
.I p2c
sometimes chooses to generate readable code at the expense of absolute
generality.  
.I P2c
endeavors to insert notes and warning messages into the output code
to point out areas which may require human intervention.  Output code
is arranged to be readable and efficient, and to make use of C idioms
wherever possible.  The main goal of the translation is to produce C
files which are pleasant and "natural" enough to be acceptable as the new
source files for a program.  In a pinch,
.I p2c
will also serve as an ad hoc Pascal compiler.
.PP
Code generated by
.I p2c
normally does not assume characters are signed or unsigned.
Also, it assumes
.B int
is the same as either
.B short
or
.B long
but does not depend on which.  However, if
.B int
is not the same as
.BR long
it is best to use a modern C compiler which supports prototypes.
Generated code does not require an ANSI-compatible compiler
(unless ANSI-style code is requested), but it does use various
ANSI-standard library routines.
.PP
All generated code includes the file
.I <p2c/p2c.h>
which in turn includes
.I <stdio.h>
and various other common resources.  Also, many translated programs
will need to be linked with the run-time library, typically
.I -lp2c.
.PP
Given a file name,
.I p2c
reads from the specified file and outputs to a file with a
.B .c
suffix added or substituted.  For example,
.IP "" 5
p2c myfile.pas
.PP
reads from
.I myfile.pas
to produce the file
.I myfile.c.
The input file may contain a Pascal main program or a
single Pascal module (or "unit" in Turbo and UCSD Pascal nomenclature),
or it may just contain a number of procedures and declarations.
.I P2c
is designed to work for correct input programs.  That is, it will accept
partial programs but may occasionally core dump if the input refers to
undefined symbols.
.PP
If the input is a module, the translator will also produce a file
.IB module .h
containing a translation of the module's interface section.
The implementation section may be omitted in which case only the
.B .h
file will be interesting.  If the program or module has include files,
these may cause additional
.B .c
files to be generated depending on the value of the
.B ExpandIncludes
option (see below).
.PP
If no file name is given,
.I p2c
reads Pascal from the standard input and writes the resulting C to
standard output (though a
.B .h
file may still be produced).  If a file name and module name are given,
the file may include several modules (or units).  The specified module
is translated; any others are skipped.  The output files will be named
.IB module .c
and
.IB module .h .
.I P2c
never translates more than one module per run.
.PP
Before starting,
.I p2c
reads the file
.I --HOMEDIR--/p2crc
for a number of configuration parameters.  (The actual path used on your
system may vary.  The
.B \-i
option is a handy way to examine this file.)
If the P2CRC environment variable is set, it gives the name of a file
to read instead of the system file; this file can start with
.B Include %H/p2crc
to include the system file.  Next,
.I p2c
attempts to read the file
.I p2crc
in your directory for further configuration.  If this file does not
exist,
.I p2c
looks for
.I .p2crc
instead.
.SH OPTIONS
.TP
.BI \-o "\ cfile"
Use
.I cfile
in place of
.IB file .c
or
.IB module .c
as the primary output file.  A single dash (`\-o \-') says to write the
C code to the standard output.
.TP
.BI \-h "\ hfile"
Use
.I hfile
in place of
.IB module .h
as the output file for interface text.  This only has effect if the
input is an HP Pascal module or a Turbo Pascal unit.
.TP
.BI \-s "\ sfile"
Read interface text from
.I sfile
before beginning the translation.  This file typically contains one or
more modules, often with interface sections omitted for speed, which the
program or module being translated will use.  (Typically the
.B ImportFrom
and
.B ImportDir
parameters in
.I p2crc
are set up to allow
.I p2c
to locate interface text without needing any
.B \-s
options.)  If there are several
.B \-s
options in the command, the
.I sfiles
are read from left to right.
.TP
.BI \-p n
Display progress of translation in the form of a line number/file name
display.  This is refreshed every
.I n
lines, 25 by default.
.TP
.BI \-c "\ rcfile"
Read local configuration commands from
.I rcfile
instead of
.I p2crc
or
.I .p2crc.
A dash (`\-c \-') in place of
.I rcfile
causes no local configuration file to be used.
.TP
.B \-v
("Vanilla.")  Do not read from the system configuration file
.I --HOMEDIR--/p2crc.
Since some of the parameters in this file are required, your local
configuration file must include those parameters instead.  This
also suppresses the file named by the P2CRC environment variable.
.TP
.BI \-H "\ homedir"
Use
.I homedir
instead of
.I --HOMEDIR--
as the
.I p2c
home directory.  The system
.I p2crc
file will be searched for in this directory. 
.TP
.BI \-I pattern
Add
.I pattern
to the
.B ImportDir
search list of places to find modules which are imported.  The pattern
should include a
.I %s
to represent the module name, and should evaluate to a potential file name
for that module's source code.  For example,
.B ../%s.pas
looks for
.IB modulename .pas
in the parent of the current directory.
.TP
.B \-i
This special option (which must be the only argument on the
command line if used) simply copies the system configuration
file
.I --HOMEDIR--/p2crc
to the standard output in its entirety.  (It may be used with
.BR \-H ,
but
.B \-i
is most useful precisely when you don't know the
location of the home directory.)
.TP
.B \-q
Quiet mode.  Suppresses output of status messages during translation.
.TP
.BI \-E n
Abort translation after
.I n
errors.  If
.I n
is omitted it defaults to zero, which means unlimited errors are allowed.
Use
.B -E1
to make
.I p2c
halt after the first error.
.TP
.B \-e
Echo the Pascal source into the output file, surrounded by #ifdefs.
This is the same as the
.B CopySource
parameter in the
.I p2crc
file.
.TP
.B \-a
Produce modern ANSI C.  This is a convenient override for the
.B AnsiC
parameter in the
.I p2crc
file.
.TP
.BI \-L "\ language"
Select input language name, such as VAX or TURBO.  This is a convenient
override for the
.B Language
parameter.
.TP
.B \-V
Verbose mode.  This causes
.I p2c
to generate an additional ".log" file with further details of the
translation, such as a list of warnings and notes including those
which are suppressed in the regular output.
.TP
.B \-M0
Disable memory conservation.  This prevents
.I p2c
from freeing various data structures after translating each function,
in case this new conservation feature causes unforseen problems.
.TP
.B \-R
Regression testing mode.  Formats notes and warning messages in a way
that makes it easier to run
.IR diff (1)
on the output of
.I p2c.
.PP
.I P2c
also understands a few debugging options which may occasionally be
useful when tracking down translation problems.  The
.BI \-d n
option sets the "debug level" to
.I n,
a small integer which is normally zero.  Debugging output is
written into the regular output file along with the C code; the
higher your
.I n,
the more "wallpaper" you get.  Also,
.B \-t
prints debugging information at every Pascal token,
.BI \-B n
enables line-breaker debugging, and
.BI \-C n
enables comment placement debugging.
.SH CHOICE OF SOURCE LANGUAGE
The
.B Language
configuration parameter or
.B \-L
command-line option tells
.I p2c
which Pascal dialect to expect in the input file.  Any language features
which do not overlap between dialects are supported all of the time.  The
.B Language
parameter is consulted when a syntax or usage is detected that has different
meanings in two different dialects, and also to determine default values
for various other translation parameters as described below.
.PP
The following language words are supported by
.I p2c.
Names are case-insensitive.
.TP 8
.B HP
HP Pascal.  This is the default language.  All features of HP Standard
Pascal, the Pascal Workstation version, are supported except as noted
in BUGS below.  Some features of MODCAL, HP's extended Pascal, are also
supported.  This is a superset of ISO standard Pascal, including
conformant arrays and procedural parameters.
.TP
.B HP-UX
HP Pascal, HP-UX version.  Almost identical to the "HP" dialect.
.TP
.B Turbo
Turbo Pascal 5.0 for the IBM PC.  Few conflicts with HP Pascal, so the
.B Language
parameter is not often needed for Turbo.  (Most important is that the Turbo
and HP dialects use 16 and 32 bit integers, respectively.)
.TP
.B UCSD
UCSD Pascal.  Similar to Turbo in many ways.
.TP
.B MPW
Macintosh Programmer's Workshop Pascal 2.0.  Should also do a pretty
good job for Lightspeed Pascal.  Object Pascal features are not supported,
nor is the fact that
.B char
variables are sometimes stored in 16 bits.
.TP
.B VAX
VAX/VMS Pascal version 3.5.  Most but not all language features supported.
This has not yet been tested on large programs.
.TP
.B Oregon
Oregon Software Pascal/2.  All features implemented.
.TP
.B Berk
Berkeley Pascal with Sun extensions.
.TP
.B Modula
Modula-2.  Based on Wirth's
.I Programming in Modula-2,
3rd edition.  Proper setting of the
.B Language
parameter is
.I not
optional.  Translation will be incomplete in most cases, but should be
good enough to work with.  Structure of local sub-modules is essentially
ignored; like-named identifiers may be confused.  Type WORD is translated
as an integer, but type ADDRESS is translated as char * or void *; this
may cause inconsistencies in the output code.
.IP
Modula-2 modules have two parts in separate files.  Suppose these are
called
.I foo.def
(definition part) and
.I foo.mod
(implementation part) for module
.I foo.
Then a pattern like
.B %s.def
must be included in the
.B ImportDir
list, and
.B LibraryFile
must be changed to refer to
.I system.m2
instead of
.I system.imp.
To translate the definition part, give the command
.IP
\ \ \ \ \ p2c foo.def
.IP
to translate the definition part into files
.I foo.h
and
.IR foo.c ;
the latter will usually be empty.  The command
.IP
\ \ \ \ \ p2c -s foo.def foo.mod
.IP
will translate the implementation part into file
.I foo.c.
.PP
Even if all language features are supported for a dialect, some
predefined functions may be omitted.  In these cases, the function call
will be translated literally into C with a warning.  Some hand modification
may be required.
.SH CONFIGURATION PARAMETERS
.I P2c
is highly configurable.  The defaults are suitable for most applications,
but customizing these parameters will help you get the best possible
translation.  Since the output of
.I p2c
is intended to be used as human-maintainable source code, there are many
parameters for describing the coding style and conventions you prefer.
Others give hints about your program that help
.I p2c
to generate more correct, efficient, or readable code.
.PP
The
.I p2crc
files contain a list of parameters, one per line.  The system
configuration file, which may be viewed using the
.B \-i
option to
.I p2c,
serves as an example of the proper format.  Parameter names are
case-insensitive.  If a parameter name occurs exactly once in the system
.I p2crc,
this indicates that it must have a unique value and the last value given to
it by the
configuration files is used.  Other parameters are written several times
in a row; these are lists to which each configuration line adds an entry.
.PP
Many
.I p2crc
options take a numeric value of 0 or 1, roughly corresponding to
"no" or "yes."  Sometimes a blank value or the value "\fBdef\fR"
corresponds to an intermediate "maybe" state.  For example, the stylistic
option
.B ExtraParens
switches between copious or minimal parentheses in expressions, with
the default being a nice compromise intended to be best for readers
with an average knowledge of C operator precedences.
.PP
Configuration options may also be embedded in the source file in the
form of Pascal comments:
.PP
\ \ \ \ \ {ShortOpt=0} {AvoidName=fred}
.br
\ \ \ \ \ {FuncMacro slope(x,y)=atan2(y,x)*RadDeg}
.PP
disables automatic short-circuiting of
.B and
and
.B or
expressions, adds "\fIfred\fR" to the list of names to avoid using in
generated C code, and defines a special translation for the Pascal
program's
.I slope
function 
using the standard C
.I atan2
function and a constant
.I RadDeg
presumably defined in the program.  Whitespace is generally not allowed
in embedded parameters.
The `=' sign is required for embedded parameters, though it is optional in
.I p2crc
files.  Comments within embedded parameters are delimited by `##'.
Numeric parameters may replace `=' with `+' or `-' to increase
or decrease the parameter; list-based parameters may use `-' to remove
a name from a list rather than adding it.  Also, the parameter name
by itself in comment braces means to restore the parameter's value
that was current before the last change:
.PP
\ \ \ \ \ {VarFiles=0  ## Pass FILE *'s params by value even if VAR}
.br
.I \ \ \ \ \ some declarations
.br
\ \ \ \ \ {VarFiles    ## Back to original FILE * passing}
.PP
causes the parameter
.B VarFiles
to have the value 0 for those few declarations, without affecting the
parameter's value elsewhere in the file.
.PP
If an embedded parameter appears in an include file or in interface text
for a module,
the effect of the assignment normally carries over to any programs that
included that file.  If the parameter name is preceded by a `*', then
the assignment is automatically undone after the source file that contains
it ends:
.PP
\ \ \ \ \ {IncludeFrom strings=<p2c/strings.h>}
.br
\ \ \ \ \ {*ExportSymbol=pascal_%s}
.br
\ \ \ \ \ module strings;
.PP
will record the location of the
.I strings
module's include file for the rest of the translation, but the assignment
of
.B ExportSymbol
pertains only to the module itself.
.PP
For the complete list of
.I p2crc
parameters, run
.I p2c
with the
.B \-i
option.  Here are some additional comments on selected parameters:
.TP 15
.B ImportAll
Because Turbo Pascal only allows one unit per source file,
.I p2c
normally stops reading past the word
.I implementation
in a file being scanned for interface text.  But HP Pascal allows several
modules per file and so this would not be safe to do.  The
.B ImportAll
option lets you override the default behavior for your Pascal dialect.
.TP
.B AnsiC
This parameter selects which dialect of C to use.  If 1, all conventions
of ANSI C such as prototypes,
.B void *
pointers, etc. are used.  If 0, only strict K&R (first edition) C is used.
The default is to use "traditional UNIX C," which includes
.B enum
and
.B void
but not
.B void *
or prototypes.  Once again there are a number of other parameters which
may be used to control the individual features if just setting
.B AnsiC
is not enough.
.TP
.B C++
At present
.I p2c
does not use much of C++ at all.  The default action is to generate code
that will compile in either language.
.TP
.B UseVExtern
Many non-UNIX linkers prohibit variables from being defined (not declared)
by more than one source file.  One module must declare, e.g., "int foo;",
and all others must declare "extern int foo;".
.I P2c
accomplishes this by declaring public variables "\fBvextern\fR"
in header files, and arranging for the macro
.B vextern
to expand to
.B extern
or to nothing when appropriate.  If you set
.BR UseVExtern =0
.I p2c
will instead declare variables in a simpler way that works only on
UNIX-style linkers.
.TP
.B UseAnyptrMacros
Certain C reserved words have meanings which may vary from one C
implementation to another.
.I P2c
uses special capitalized names for these words; these names are
defined as macros in the file
.I p2c.h
which all translated programs include.  You can set
.BR UseAnyptrMacros =0
to disable the use of these macros.  Note that the functions of many of
these macros can also be had directly using other parameters; for example,
.B UseConsts
allows you to specify whether your target language recognizes the word
.B const
in constant declarations.  The default is to use the
.B Const
macro instead, so that your code will be portable to either kind of
implementation.
.IP
.B Signed
expands to the reserved word
.B signed
if that word is available, otherwise it is given a null definition.
Similarly,
.B Const
expands to
.B const
if that feature is available.  The words
.B Volatile
and
.B Register
are also defined in
.I p2c.h,
although
.I p2c
does not use them at present.  The word
.B Char
expands to
.B char
by default, but might need to be redefined to
.B signed char
or
.B unsigned char
in a particular implementation.  This is used for the Pascal character
type; lowercase
.B char
is used when the desired meaning is "byte," not "character."
.IP
The word
.B Static
always expands to
.B static
by default.  This is used in situations where a function or variable is
declared static to make it local to the source file; lowercase
.B static
is used for static local variables.  Thus you can redefine
.B Static
to be null if you want to force private names to be public for purposes
of debugging.
.IP
The word
.B Void
expands to
.B void
in all cases; it is used when declaring a function with no return value.
The word
.B Anyptr
is a typedef for
.B void *
or
.B char *
as necessary; it represents a generic pointer.
.TP
.B UsePPMacros
The
.I p2c.h
header also declares two macros for function prototyping,
.BR PP (x)
and
.BR PV ().
These macros are used as follows:
.IP
\ \ \ \ \ Void foo  PP( (int x, int y, Char *z) );
.br
\ \ \ \ \ Char *bar PV( );
.IP
If prototypes are available, these macros will expand to
.IP
\ \ \ \ \ Void foo  (int x, int y, Char *z);
.br
\ \ \ \ \ Char *bar (void);
.IP
but if only old-style declarations are supported, you instead get
.IP
\ \ \ \ \ Void foo  ();
.br
\ \ \ \ \ Char *bar ();
.IP
By default,
.I p2c
uses these macros for all function declarations, but function
.I definitions
are written in old-style C.  The
.B UsePPMacros
parameter can be set to 0 to disable all use of
.B PP
and
.BR PV ,
or it can be set to 1 to use the macros even when defining a function.
(This is accomplished by preceding each old-style definition with a
.BR PP -style
declaration.)  If you know your code will always be
compiled on systems that support prototyping, it is prettier to set
.BR Prototypes =1
or simply
.BR AnsiC =1
to get true function prototypes.
.TP
.B EatNotes
Notes and warning messages containing any of these strings as sub-strings
are not omitted.  Each type of message includes an identifier like
.BR [145] ;
you can add this identifier to the
.B EatNotes
list to suppress that message.  Another useful form is to use a variable
name or other identifier to suppress warnings about that variable.  The
strings are a space-separated list, and thus may not contain embedded spaces.
To suppress notes around a section of code, use, e.g.,
.I {EatNotes+[145]}
and
.I {EatNotes-[145]}.
Most notes are generated during parsing, but to suppress those generated
during output the string may need to remain in the list far beyond the point
where it appears to be generated.  Use the string "1" or "0" to disable or
enable all notes, respectively.
.TP
.B ExpandIncludes
The default action is to expand Pascal include files in-line.  This
may not be desirable if include files are being used to simulate modules.
With
.BR ExpandIncludes =0,
.I p2c
attempts to convert include files containing only whole procedures and
global declarations into analogous C include files.  This may not always
work, though; if you get error messages, don't use this option.  By
combining this option with
.BR StaticFunctions =0,
then doing some fairly minor editing on the result, you can convert
a pseudo-modular Pascal program into a truly modular collection of C
source files.
.TP
.B ElimDeadCode
Some transformations that
.I p2c
does on the program may result in unreachable or "dead" code.  By
default
.I p2c
removes such code, but sometimes it removes more than it should.
If you have "if false" segments which you wish to retain in C, you
may have to set
.BR ElimDeadCode =0.
.TP
.B SkipIndices
Normally Pascal arrays not based at zero are "shifted" down for C,
preserving the total size of the array.  A Pascal array a[2..10] is
translated to a C array a[9] with references like "a[i]" changed to
"a[i-2]" everywhere.  If
.B SkipIndices
is set to a value of 2 or higher, this array would instead be translated
to a[11] with the first two elements never used.  This arrangement may
generate incorrect code, though, for tricky source programs.
.TP
.B FoldConstants
Pascal non-structured constants generally translate to
.BR #define 's
in C.  Set this to 1 to have constants instantiated directly into the
code.  This may be turned on or off around specific constant declarations.
Set this to 0 to force
.I p2c
to make absolutely no assumptions about the constant's value in generated
code, so that you can change the constant later in the C code without
invalidating the translation.  The default is to allow
.I p2c
to take advantage of its knowledge of a constant's value, such as by
generating code that assumes the constant is positive.
.TP
.B VarStrings
In HP Pascal, a parameter of the form "var s : string" will match a
string variable of any size; a hidden size parameter is passed which
may be accessed by the Pascal
.I strmax
function.  You can prevent
.I p2c
from creating a hidden size parameter by setting
.BR VarString =0.
(Note that each function uses the value of
.B VarStrings
as of the
.I first
declaration of the function that is parsed, which is often in the interface
section of a module.)
.TP
.B Prototypes
Control whether ANSI C function prototypes are used.  Default is according to
.BR AnsiC .
This also controls whether to include parameter names or just their types
in situations where names are optional.  The
.B FullPrototyping
parameter allows prototypes to be generated for declarations but not
for definitions (older versions of Lightspeed C required this).  If you
use a mixture of prototypes and old-style definitions, types like short
and float will be promoted to int and double as required by the ANSI
standard, unless
.B PromoteArgs
is used to override this.  The
.B CastArgs
parameter controls whether type-casts are used in function arguments;
by default they are used only if prototypes are not available.
.TP
.B StaticLinks
HP Pascal and Turbo Pascal each include the concept of procedure or
function pointers, though with somewhat different syntaxes.
.I P2c
recognizes both notational styles.  Another difference is that HP's
procedure pointers can point to nested procedures, while Turbo's can
point only to global procedures.  In HP Pascal a procedure pointer must
be stored as a
.B struct
containing both a pure C function pointer and a "static link," a pointer
to the parent procedure's locals.  (The static link is NULL for global
procedures.)  This notation can be forced by setting
.BR StaticLinks =1.
In Turbo, the default
.RB ( StaticLinks =0)
is to use plain C function pointers with no static links.  A third option
.RB ( StaticLinks =2)
uses structures with static links, but assumes the links are always NULL
when calling through a pointer (if you need compatibility with the HP
format but know your procedures are global).
.TP
.B SmallSetConst
Pascal sets are translated into one of two formats, depending on the size
of the set.  If all elements have ordinal values in the range 0..31, the
set is translated as a single integer variable using bit operations.
(The
.B SetBits
parameter may be used to change the upper limit of 31.)
The
.B SmallSetConst
parameter controls whether these small-sets are used, and, if so, how
constant sets should be represented in C.
.IR
For larger sets, an array of
.B long
is used.  The
.IR s [0]
element contains the number of succeeding array elements
which are in use.  Set elements in the range 0..31 are stored in the
.IR s [1]
array element, and so on.  Sets are normalized so that
.IR s [ s [0]]
is nonzero for any nonempty set.  The standard run-time library
includes all the necessary procedures for operating on sets.
.TP
.B ReturnValueName
This is one of many "naming conventions" parameters.  Most of these
take the form of a
.IR printf -like
string containing a
.I %s
where the relevant information should go.  In the case of
.BR ReturnValueName ,
the
.I %s
refers to a function name and the resulting string gives the name of
the variable to use to hold the function's return value.  Such a variable
will be made if a function contains assignments to its return value
buried within the body, so that
.I return
statements cannot conveniently be used.  Some parameters
.RB ( ReturnValueName
included) do not require the
.I %s
to be present in the format string; for example, the standard
.I p2crc
file stores every function's return value in a variable called
.I Result.
.TP
.B AlternateName
.I P2c
normally translates Pascal names into C names verbatim, but occasionally
this is not possible.  A Pascal name may be a C reserved word or
traditional C name like
.I putc,
or there may be several like-named things that are hidden from each other by
Pascal's scoping rules but must be global in C.  In these situations
.I p2c
uses the parameter
.B AlternateName1
to generate an alternative name for the symbol.  The default is to add
an underscore to the name.  There is also an
.B AlternateName2
parameter for a second alternate name, and an
.B AlternateName
parameter for the
.IR n th
alternate name.  (The value for this parameter should include both a
.I %s
and a
.I %d,
in either order.)  If these latter parameters are not defined,
.I p2c
applies
.B AlternateName1
many times over.
.TP
.B ExportSymbol
Symbols in the interface section for a Pascal module are formatted
according to the value of
.BR ExportSymbol ,
if any.  It is not uncommon to use
.I modulename_%s
for this symbol; the default is
.I %s,
i.e., no special treatment for exported symbols.  If you also define the
.B Export_Symbol
parameter, that format is used instead for exported symbols which
contain an underscore character.  If
.I %S
(with a capital "S") appears in the format string it stands for the
current module name.
.TP
.B Alias
If the value of this parameter contains a
.I %s,
it is a format string applied to the names of external functions or
variables.  If the value does not contain a
.I %s,
it becomes the name of the next external symbol which is declared (after
which the parameter is cleared).
.TP
.B Synonym
This creates a synonym for another Pascal symbol or keyword.  The format is
.IP
.B "\ \ \ \ \ Synonym"
.I old-name = new-name
.IP
All occurrences of 
.I old-name
in the input text are treated as if they were
.I new-name
by the parser.  If
.I new-name
is a keyword,
.I old-name
will be an equivalent keyword.  If
.I new-name
is the name of a predefined function,
.I old-name
will behave in the same way as that function, and so on.  If
.I new-name
is omitted, then occurrences of
.I old-name
are entirely ignored in the input file.  Synonyms allow you to skip over
a keyword in your dialect of Pascal that is not understood by
.I p2c,
or to simulate a keyword or predefined identifier of your dialect with a
similar one that
.I p2c
recognizes.  Note that all predefined functions are available at all times;
if you have a library routine that behaves like, e.g., Turbo Pascal's
.I getmem
procedure, you can make your routine a synonym for
.I getmem
even if you are not translating in Turbo mode.
.TP
.B NameOf
This defines the name to use in C for a specific symbol.  It must appear
before the symbol is declared in the Pascal code; it is usually placed
in the local
.I p2crc
file for the project.  The format is
.IP
.B "\ \ \ \ \ NameOf"
.I pascal-name = C-name
.IP
By default, Pascal names map directly onto C names with no change
(except for the various kinds of formatting outlined above).  If the
.I pascal-name
is of the form
.I module.name
or
.I procedure.name
then the command applies only to the instance of the Pascal name that is
global to that module, or local to that procedure.  Otherwise, it applies
to all usages of the name.
.TP
.B VarMacro
This is analogous to
.BR NameOf ,
but specifically for use with Pascal variables.  The righthand side can
be most any C expression; all references to the variable are expanded
into that C expression.  Names used in the C expression are taken
verbatim.  There is also a
.B ConstMacro
parameter for translating constants as arbitrary expressions.
Note that the variable on the lefthand side must actually be declared
in the program or in a module that it uses.
The declaration for the variable will be omitted from the generated code
unless the Pascal-name appears in the expression:  If you ask to
replace
.I i
with
.I i+1,
the variable
.I i
will still be declared but its value will be shifted accordingly.
Note that if
.I i
appears on the lefthand side of an assignment,
.I p2c
will use algebra to "solve" for
.I i.
.IP
In all cases where
.I p2c
parses C expressions, all C operators are recognized except compound
assignments like `+='.  (Increment and decrement operators are allowed.)
All variable and function names are assumed to have integer type, even
if they are names that occur in the actual program.  A type-specification
operator `::' has been introduced; it has the same precedence as `.' or `->'
but the righthand side must be a Pascal type identifier (built-in or defined
by your program previously to when the macro definition was parsed),
or an arbitrary Pascal type expression in parentheses.
The lefthand argument is then
considered to have the specified type.  This may be necessary if your
macro is used in situations where the exact type of the expression
must be known (say, as the argument to a
.IR writeln ).
.TP
.B FieldMacro
Here the lefthand side must have the form
.I record.field,
where
.I record
is the Pascal type or variable name for a record, and
.I field
is a field in that record.  The righthand side must be a C expression
generally including the name
.I record.
All instances of that name are replaced by the actual record being "dotted."
For example,
.IP
\ \ \ \ \ FieldMacro Rect.topLeft = topLeft(Rect)
.IP
translates
.I a[i].topLeft
into
.I topLeft(a[i]),
where
.I a
is an array of
.I Rect.
.TP
.B FuncMacro
The lefthand side must be any Pascal function or procedure name plus a
parameter list.  The number of parameters must match the number in the
function's uses and declaration.  Calls to the function are replaced by the
C expression on the righthand side.  For example,
.IP
\ \ \ \ \ FuncMacro PtInRect(p,r) = PtInRect(p,&r)
.IP
causes the second argument of
.I PtInRect
to be passed by reference, even though the declaration says it's not.
If the function in question is actually defined in the program or module
being translated, the
.B FuncMacro
will not affect the definition but it will affect all calls to the function
elsewhere in the module.
.B FuncMacros
can also be applied to predefined or never-defined functions.
.TP
.B IncludeFrom
This specifies that a given module's header should be included from a
given place.  The second argument may be surrounded by "\ " or <\ > as
necessary; if the second argument is omitted, no include directive will
be generated for the module.
.TP
.B ImportFrom
This specifies that a given module's Pascal interface text can be found
in the given file.  The named file should be either the source file for
the module, or a specially prepared file with the implementation section
removed for speed.  If no
.B ImportFrom
entry is found for a module, the path defined by the
.B ImportDir
list is searched.  Each entry in the path may contain a
.I %s,
which expands to the name of the module.  The default path looks for
.I %s.pas
and
.I %s.text
in the current directory, then for
.I --HOMEDIR--/%s.imp.
(where --HOMEDIR-- is the
.I p2c
home directory.)
.TP
.B StructFunction
This parameter is a list of functions which follow the
.I p2c
semantics for structure-valued functions (functions returning arrays,
sets, and strings, and structs in primitive C dialects).  For these
functions, a pointer to a return-value area is passed to the function
as a special first parameter.  The function stores the result in this
area, then returns a copy of the pointer.  (The standard C function
.I strcpy
is an example of this concept.
.I Sprintf
also behaves this way in some dialects; it always appears on the
.B StructFunction
list regardless of the type of implementation.)  The system configuration
file includes a list of common structured functions so that
.IR p2c 's
optimizer will know how to manipulate them.
.TP
.B StrlapFunction
Functions on this list are structured functions as above, but with the
ability to work in-place; that is, the same pointer may be passed as both the
return value area and a regular parameter.
.TP
.B Deterministic
Functions on this list have no side effects or side dependencies.
An example is the
.I sin
function in the standard math library; two calls with the same parameter
values produce the same result, and have no effects other than returning
a value.
.I P2c
can make use of this knowledge when optimizing code for efficiency or
readability.  Functions on this list are also assumed to be relatively
fast, so that it is acceptable to duplicate a call to the function.
.TP
.B LeaveAlone
Functions on this list are not subjected to the normal built-in translation
rules that
.I p2c
would otherwise use.  For example, adding
.I writeln
to this list would translate
.I writeln
statements blindly into calls to a C
.I writeln()
function, rather than being translated into equivalent
.I printf
calls.  The built-in translation is also suppressed if the function has a
.BR FuncMacro .
.TP
.B BufferedFile
.I P2c
normally assumes binary files will use
.I read/write,
not
.I get/put/^
notation.
A file buffer variable will only be created for a file if buffer notation
is used for it.  For global file variables this may be detected too late
(a declaration without buffers may already have been written).  Such files
can be listed in
.B BufferedFile
to force
.I p2c
to allocate buffers for them; do this if you get a warning
message that says it is necessary.  Set
.BR BufferedFile =1
to buffer all files, in which case
.B UnBufferedFile
allows you to force certain files
.I not
to have buffers.
.TP
.B CheckFileEOF
Normally only file-open operations are checked for errors.  Additional
error checking, such as read-past-end-of-file, can be enabled with
parameters like
.BR CheckFileEOF .
These checks can make the code very ugly!  If I/O checking is enabled
by the program
.RB ( "$iocheck on$"
in HP Pascal;
.B {$I+}
in Turbo; this is always the default state),
these checks will generate fatal errors unless enclosed in an HP Pascal
.BR try - recover
construct.  If I/O checking is disabled, these will cause the global
variable
.I P_ioresult
to be set zero or nonzero according to the outcome.  The default for most
of these options is to check only when I/O checking is disabled.
.SH ISSUES
.B Integer size.
.I P2c
normally generates code to work with either 16 or 32 bit ints.
If you know your C integers will be 16 or 32 bits, set
.B IntSize
appropriately.  In particular setting
.BR IntSize =32
will generate much cleaner code:
.I p2c
no longer must carefully cast function arguments between int and long.
These casts also will be unnecessary if ANSI prototypes are available.
To disable int/long casting because you know at least one of these
cases will hold, set
.BR CastLongArgs =0.
(The
.B CastArgs
parameter similarly controls other types of casts, such as between ints
and doubles.)
The
.B Integer16
parameter controls whether Pascal integers are interpreted as 16 or 32
bits, or translated as native C integers.  The default value depends on the
.B Language
selected.
.PP
.B Signed/unsigned chars.
Pascal characters are normally "weakly" interpreted as unsigned; this
is controlled by
.BR UnsignedChar .
The default is "either," so that C's native
.B char
type may be used even if its signed-ness is unknown.  Code that uses
characters outside of the range 0-127 may need a different setting.
Alternatively, you can use the types
.B {SIGNED} char
and
.B {UNSIGNED} char
in the few cases where it really matters.  These comments are controlled
by the
.B SignedComment
and
.B UnsignedComment
parameters.  (The type
.B {UNSIGNED} integer
is also recognized.)  The
.B SignedChar
parameter tells whether C characters are signed or unsigned (default is
"unknown").  The
.B HasSignedChar
parameter tells whether the phrase "signed char" is legal in the output.
If it is not,
.I p2c
may have to translate Pascal signed bytes into C shorts.
.PP
.B Special types.
.I P2c
understands the following predefined Pascal type names:
.BR integer ,
signed integers depending on
.BR Integer16 ;
.BR longint ,
signed 32-bit integers;
.BR unsigned ,
unsigned 32-bit integers;
.BR sword ,
signed 16-bit integers;
.BR word ,
unsigned 16-bit integers;
.BR c_int ,
signed native C integers;
.BR c_uint ,
unsigned native C integers;
.BR sbyte ,
signed 8-bit integers;
.BR byte ,
unsigned 8-bit integers;
.BR real ,
floating-point numbers depending on
.BR DoubleReals ;
.BR single ,
single-precision floats;
.BR longreal ,
.BR double ,
and
.BR extended ,
double-precision floats;
.B pointer
and
.BR anyptr ,
generic pointers (assignment-compatible with any pointer type);
.BR string ,
generic string of length
.B StringDefault
(normally 255);
also, the usual Pascal types
.BR char ,
.BR boolean ,
and
.BR text .
(If your Pascal uses different names for these concepts, the
.B Synonym
option will come in handy.)
.PP
.B Embedded code.
It is possible to write a Pascal comment containing C code to
be embedded into the output.  See the descriptions of
.B EmbedComment
and its relatives in the system
.I p2crc
file.  These techniques are helpful if you plan to do repeated translations
of code that is still being maintained in Pascal.
.PP
.B Comments and blank lines.
.I P2c
collects the comments in a procedure into a list.  All comments and statements
are stamped with serial numbers which are used to reattach comments to
statements even after code has been added, removed, or rearranged during
translation.  "Orphan" comments attached to statements that have been lost
are attached to nearby statements or emitted at the end of the procedure.
Blank lines are treated as a kind of comment, so
.I p2c
will also reproduce your usage of blank lines.  If the comment mechanism
goes awry, you can disable comments with
.B EatComments
or disable their being attached to code with
.BR SpitComments .
.PP
.B Indentation.
.I P2c
has a number of parameters to govern indentation of code.  The default
values produce the GNU Emacs standard indentation style, although
.I p2c
can do a better job since it knows more about the code it is indenting.
Indentation works by applying "indentation deltas," which are either
absolute numbers (which override the previous indentation), or signed
relative numbers (which augment the previous indentation).  A delta of
"+0" specifies no change in indentation.  All of the indentation
options are described in the standard
.I p2crc
file.
.PP
.B Line breaking.
.I P2c
uses an algorithm similar to the TeX typesetter's paragraph formatter
for breaking long statements into multiple lines.  A "penalty" is assigned
to various undesirable aspects of all possible line breaks; the "badness"
of a set of line breaks is approximately the sum of all the penalties.
Chief among these are serious penalties for overrunning the desired maximum
line length (default 78 columns),
an infinite penalty for overrunning the absolute
maximum line length (default 90), and progressively greater penalties for
breaking at operators deeply nested in expressions.  Parameters such as
.B OpBreakPenalty
control the relative weights of various choices.
.B BreakArith
and its neighbors control whether the operator at a line break should be
placed at the end of the previous line or at the beginning of the next.
If you don't want any oversize lines, define
.BR MaxLineWidth =78.
.PP
Unlike TeX,
.IR p2c 's
line breaker must actually try all possible sets of break points.  To
avoid excessive computation, the total penalty contributed at each decision
point must sum to a nonnegative value; negative values are clipped up to zero.
This allows
.I p2c
to prune away obviously undesirable alternatives in advance.  The
.B MaxLineBreakTries
parameter (default 5000) controls how many alternatives to try before
giving up and using the best so far.
.PP
.B PASCAL_MAIN.
.I P2c
generates a call to this function at the front of the main program.
In the (unmodified) run-time library all this does is save argc and argv
away because in both HP and Turbo these are accessed as global variables.
If you do not wish to use this feature, define
.B ArgCName
to be
.I argc,
.B ArgVName
to be
.I argv,
and
.B MainName
(normally "PASCAL_MAIN") to be blank.  This will work if argc and argv
are never accessed outside of your main program.
.SH BUGS
.I P2c
was designed with the idea that clean, readable output in most cases is
worth more than guaranteed correct output in extreme cases.
.I P2c
is
.I not
a compiler!  However, ideally the "extreme" cases would include only those
which never arise in real life.  Thus if
.I p2c
actually generates incorrect code I will consider it a bug, but I will not
apologize for it. :-)  Below are the major remaining cases where this is
known to occur.
.PP
Certain kinds of conformant array parameters (including multi-dimensional
conformant arrays) produce code that declares variable-length arrays in C.
Only a few C compilers, such as the GNU C compiler, support this language
extension.  Otherwise some hand re-coding will be required.
.PP
HP Pascal
.BR try - recover
structures are translated into calls to
.I TRY
and
.I RECOVER
macros, which are defined to simulate the construct using
.I setjmp
and
.I longjmp.
If this emulation does not work, define the symbol
.B FAKE_TRY
to cause these macros to become "inert."  (In cases where the
error is detected by code physically within the body of the
.B try
statement, a C
.B goto
to the
.B recover
section is always generated.)  Also, local file variables in scopes which
are destroyed by an
.B escape
are not closed.
.PP
Non-local GOTO's and
.BR try - recover
statements are each implemented, but may
conflict if both are used at once.  Non-local GOTO's are fairly careful
about closing files that go out of scope but may fail to do so in the presence
of recursion.
.PP
Arrays containing files are not initialized to NULL as other files are.
In some cases, such as file variables allocated by NEW, the file is
initialized but not automatically closed by DISPOSE.
.PP
LINK variables allowing sub-procedures access to their parents' variables
are occasionally omitted by mistake, if the access is too indirect for
.I p2c
to notice.  If this happens, you can add an explicit reference to a parent
variable in the sub-procedure.  A statement of the form "a:=a" will count
as a reference but then be optimized away by
.I p2c.
.PP
Many aspects of Modula-2 are translated only superficially.  For example,
the type-compatibility properties of the
.I WORD
and
.I ARRAY OF WORD
types are only roughly modelled, as are the scope rules concerning modules.
.PP
Parts of VAX Pascal are still untreated.  In particular, the
.I [UNSAFE]
attribute and a few others are not fully supported,
nor are the semantics of the
.I OPEN
procedure.
.PP
Turbo and VAX Pascal's
.I double, quadruple,
and
.I extended
real types all translate to the C
.B double
type.  Turbo's
.I computational
type is not supported at all.
.PP
Because Pascal strings (with length bytes) are translated into C strings
(with null terminators), certain Pascal string tricks will not work in
the translated code.  For example the assignment
.I s[0]:=chr(x)
is translated to
.I s[x]=0
on the assumption that the string is being shortened.  If
.I x
is actually greater than the current length, but not of a recognizable
form like
.I ord(s[0])+n,
then the generated code will not work.  In VAX Pascal this corresponds
to performing arithmetic on the
.I LENGTH
field of a varying-length string.
.PP
Turbo Pascal's automatic clipping of strings is not supported.  In
Turbo, if a ten character string is assigned to a
.I string[8]
variable, the last two characters are silently removed.  The code
produced by
.I p2c
generally will overrun the target string instead!  The
.B StringTruncLimit
parameter (80 by default if
.BR Language = Turbo )
specifies a string size which should be considered "short"; assignments
of potentially-long strings to short string variables will cause a warning
but will not automatically truncate.  The cure is to use
.I copy
in the Pascal source to truncate the strings explicitly.
.SH FILES
.ta \w'--INCDIR--/p2c.h 'u
file.\fIxxx\fR	Pascal source files
.br
file.c	resulting C source file
.br
module.h	resulting C header file
.br
p2crc	local configuration file
.br
\&.p2crc	alternate local configuration file
.br
--HOMEDIR--/p2crc	system-wide configuration file
.br
--HOMEDIR--/system.imp	declarations for predefined functions
.br
--HOMEDIR--/system.m2	analogous declarations for Modula-2
.br
--HOMEDIR--/*.imp	interface text for standard modules
.br
--INCDIR--/p2c.h	header file for translated programs
.br
--LIBDIR--/libp2c.a	run-time library
.SH AUTHOR
Dave Gillespie, daveg@csvax.caltech.edu.
.PP
Many thanks to William Bader, Rick Koshi, Eric Raymond, Magne Haveraaen,
Dirk Grunwald, David Barto, Paul Fisher, and others whose suggestions and
bug reports have helped improve
.I p2c
in countless ways.
