//
//  XTFontUtils.h
//  XTads
//
//  Created by Rune Berg on 24/04/15.
//  Copyright (c) 2015 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface XTFontUtils : NSObject

+ (double)getTotalTimeInRequiredRectForText;

+ (NSFont *)boldVersionOfFont:(NSFont *)font;

+ (CGFloat)defaultTextLineHeight:(NSFont *)font;

+ (CGFloat)defaultWidthOfString:(NSString *) string inFont:(NSFont *)font;

+ (CGFloat)widthOfLongestIndivisibleWordInTextStorage:(NSTextStorage *)textStorage
									numCharsInLongest:(NSUInteger *)numCharsInLongest;

+ (CGFloat)widthOfLongestIndivisibleWordInTextStorage:(NSTextStorage *)textStorage
												range:(NSRange)range
									numCharsInLongest:(NSUInteger *)numCharsInLongest;

+ (NSSize)sizeOfTextInTextStorage:(NSTextStorage *)textStorage
							range:(NSRange)range
						 viewSize:(NSSize)viewSize;

+ (NSSize)sizeOfAttrString:(NSAttributedString *)attrString;

+ (CGFloat)widthOfLongestLineInTextStorage:(NSTextStorage *)textStorage;

+ (CGFloat)heightOfText:(NSTextView *)textView;

+ (NSSize)requiredRectForText:(NSAttributedString *)attrAtring
				forViewOfSize:(NSSize)viewSize
   suppressCenterAndRightTabs:(BOOL)suppressCenterAndRightTabs;

+ (CGFloat)fontWidth:(NSFont *)font;

+ (CGFloat)fontHeight:(NSFont *)font;

@end
