//
//  XTBaseTextHandler_private.h
//  XTads
//
//  Created by Rune Berg on 11/08/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTBaseTextHandler.h"
#import "XTFormattedElementQueue.h"


#define NO_CHILD_INDEX  (-1)


@interface XTBaseTextHandler ()

@property NSString *debugName;

@property (weak) XTBaseTextHandler *parentHandler;
@property NSMutableArray *childHandlers; // of XTBannerHandler

@property (weak) XTBannerTextHandler *siblingForWhere; // "other"

@property NSMutableArray *layoutViews;

@property XTPrefs *prefs;

@property XTFormattedElementQueue *formattedElementQueue;
@property XTHtmlTag *currentTag;
@property BOOL abortProcessingTags;
@property BOOL needMorePrompt;
	//TODO !!! really needed?

@property BOOL processFormattedElementQueueClearedTextStorage;

// pagination state
@property CGFloat maxTextViewHeightBeforePagination;
@property CGFloat visibleHeightBeforeLayoutOfViews;
@property CGFloat totalHeightBeforeLayoutOfViews;

@property NSRect visibleRectAtStartOfWindowResize;

@property BOOL nonstopModeState;


- (void)clearTextStorage;

- (void)setBannerIndex:(NSUInteger) bannerIndex;

- (NSAttributedString *)appendAttributedStringToTextStorage:(NSAttributedString *)attrString;

- (void)addChildHandler:(XTBannerTextHandler *)childHandler;

- (NSInteger)indexOfChild:(XTBannerTextHandler*)childHandler;

- (void)tearDownLayoutViews;

- (void)teardownReceptionOfAppLevelNotifications;

- (NSView *)internalRebuildViewHierarchy;

- (void)clearPaginationState;

- (BOOL)shouldAutoScrollToBottom;

- (void)autoScrollToBottom;

- (void)recalcDynamicTabStops:(BOOL)changedMainOutputAreaSize;

- (void)ensureWeHaveCurrentTag;

- (BOOL)processTagTree;

- (BOOL)processTags;

- (BOOL)processFormattedElementQueue;

- (BOOL)processBatched;

- (BOOL)processBatchedOutputUntilReachedPaginationLimit;

- (void)clearWhitespaceBeforeOrAfterBlockLevelTagOutputElement;

- (void)flushFormattingQueue;

- (void)flushPendingNewline;

@end
