#pragma C+


/*
 *  TADSMap
 *
 *  An HTML-based mapping libary 
 *  Copyright (c) 2001-2002 Andrew Pontious
 *  All rights reserved. 
 *  Anyone may use and modify this code for their own TADS games.
 *
 *  http://www.umbar.com/TADS/tadsmap/
 *
 *  Version 1.0
 *
 *  July 2002
 *
 */
 
 
 /*
  *  tadsmap_room.t
  */


/*
 *  All rooms in your game should derive from tadsmap_room
 *  so that they will all be mapped correctly.
 */
class tadsmap_room: room

	// Modified room properties

    /*
     *  This is how map is actually drawn under normal circumstances.
     *  Note, however, that there *are* other explicit calls to
     *  tadsmap.map, so overriding this will not prevent TADSMap 
     *  from functioning.
     */
    lookAround(verbosity) =
    {
        inherited.lookAround(verbosity);
        
        // If we're not using GOTO functionality
        if(!tadsmap.going)
            tadsmap.map;
    }
    

    noexit = 
    { 
    	// Only show message if we're not refiguring map.
    	if(tadsmap.ismapping == nil)
	    	"%You% can't go that way. "; 
    	return nil;
    }


	maptype = tadsmap.default_room_maptype

	mapcolor = tadsmap.default_room_mapcolor

	kind = tadsmap.default_room_maptype

    // Distance (in room units) from this room
	default_dir_distance = tadsmap.default_dir_distance

    north_distance  = self.default_dir_distance
    north_taken		= nil
    south_distance  = self.default_dir_distance
    south_taken		= nil
    east_distance   = self.default_dir_distance
    east_taken		= nil
    west_distance   = self.default_dir_distance
    west_taken		= nil
    ne_distance     = self.default_dir_distance
    ne_taken		= nil
    nw_distance     = self.default_dir_distance
    nw_taken		= nil
    se_distance     = self.default_dir_distance
    se_taken		= nil
    sw_distance     = self.default_dir_distance
    sw_taken		= nil

	// If you want the mark indicating something special in this room
	// to show up on its map entry, set this to true.
	map_has_special_symbol = nil


	// Mapping algorithm settings.
	// See instructions for use.
	// Don't generally need to be touched for small maps.
	map_initialexitproperty = tadsmap.NORTH
	map_searchdirection = tadsmap.CLOCKWISE

	// Counter. Used by tadsmap. Don't touch.
	map_counter = 0

	// Courtesy of inky.
	sdesc_as_string =
	{
		local tok = outcapture(true); 
		self.sdesc; 
		return outcapture(tok);
	}
	
	suffix = '.png'
	
	// Whether special xxx_center.* picture files exist for the center 
	// map entry.
	supports_center = true

	exitproperty_output(exitproperty) =
	{
		local tok = outcapture(true), output; 
		
		output = self.exitproperty; 

		outcapture(tok);
		
		return output;
	}
	
	has_exit(exitproperty) =
	{
		local output = self.exitproperty_output(exitproperty);
		
		if(datatype(output) == 2 || datatype(output) == 8)
			return true;
		else
			return nil;
	}
;


/*
 *  A default room type. 
 *  Can change what this inherits from to change all basic
 *  room behaviors without having to change a lot of
 *  specific game rooms.
 */
class tadsmap_room_basic: tadsmap_room_square
;


class tadsmap_room_hallway: tadsmap_room

	maptype = 'hallway'
;
class tadsmap_room_square: tadsmap_room

	maptype = 'square'
;
class tadsmap_room_small: tadsmap_room

	maptype = 'small'
;
class tadsmap_room_round: tadsmap_room

	maptype = 'round'
;


#pragma C-
