/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * The Akmi System
 *
 * This system iswhere Akmi HQ is lcated.
 *
 * PLANETS:
 *
 * Spam:		?
 * Cheez:		Homeworld
 * Plast:		Cheez Deth Star (tm)
 *
 * COLORSPACES:
 *
 * Akmi Orange:		Plast high-security core only.
 * Salmon:		Everything else.
 */

#ifndef	DEMO

/*
 * Akmi Galactic Network HQ
 */
akmimover: mattermover
	accepting = nil
	location = akmihq1

	address = {
		"The mover has no address placard.";
	}

	/*
	 * This mover's coordinates
	 */
	ar = -1
	ag = -1
	ab = -1

	/*
	 * This mover's dials
 	 */
	r = akmired
	g = akmigreen
	b = akmiblue

	colorspace = 'Akmi Orange'
	system = 'Akmi'
	planet = 'Plast'
;

akmigreen: greendial 	setting = 0 location = akmihq1;
akmiblue:  bluedial  	setting = 0 location = akmihq1;
akmired:   reddial 	setting = 0 location = akmihq1;

yellowstripes: floatingdecoration
	isplural = true
	sdesc = "yellow stripes"
	ldesc = {
		"Yellow stripes are said to line the walls everywhere
		inside Plast.  You can't imagine what they might
		be for.";
	}
	noun = 'stripes'
	adjecitve = 'yellow'

	loclist = [
		akmihq1	akmihq2	akmihq3	akmihq4	akmihq5 akmihq6
		akmihq7	akmihq8	akmihq9	akmihq10 akmihq11
		akmihq12 akmihq13
	]	
;

akmihq1: Room
	firsttime = true

	noun = 'plast'
	adjective = 'inside'

	sdesc = "Inside Plast"
	ldesc = {
		I(); "You can tell from the looks of this place
		that you must be inside the synthetic Cheez
		planet of Plast.  Until today you'd only seen 
		pictures of it, but the yellow stripes on the
		walls give it away."; P();

		I(); "This is a central area, with corridors
		leading out in the cardinal directions.  There
		is a matter mover here.";
	}

	enter(actor) = {
		inherited.enter(actor);
		
		if (self.firsttime) {
			local m;

			P(); "The crypto watch cromes  on:"; P();

			self.firsttime := nil;

			//
			// Make sure the player gets the last
			// two watch messages if he hasn't
			// already.
			//
			m := length(watch.oncemsg) - 1;
			if (watch.nextmsg <= m) {
				say(watch.oncemsg[m]); P();
				say(watch.oncemsg[m + 1]); P();
			}
			else if (watch.nextmsg = m + 1) {
				say(watch.oncemsg[m + 1]); P();
			}

			watch.nextmsg := 999; // no more messages from watch

			"JC instructs you to head west, to the
			end of the corridor.  \"I've managed to get
			the door at the end of hall open.  The virus
			is preventing me from tampering with the
			security system, so be careful!  Sorry I can't
			do more to help, but this may be 
			our only shot.\" He continues: \"There's a
			ventilation shaft beyond the door.  The shaft
			twists and turns in all directions, but if you 
			head straight, turn right, head straight again,
			turn left, then	straight once more, you'll end up
			at the shunt -- it's a little part that looks
			like a fuse, exposed inside the shaft. Just
			break it, and I'll have	control.\"";
		}
	}

	north = akmihq2
	south = akmihq3
	east = akmihq4
	west = akmihq5
;

class akmiroom: Room
	sdesc = "In a Hallway in Plast"
	ldesc = {
		I(); "You are in a hallway deep within Plast, Akmi's
		synthetic Cheez planet.  There are the usual yellow
		stripes on the metal walls here, but the location is
		otherwise bare.  You surmise that many thousands of
		similar	corridors wend their way through Plast's
		mechanical bowels."; P();

		I(); self.exits;
	}
;

akmihq2: akmiroom
	north = akmihq6
	south = akmihq1
	exits = "The hall leads north and south."
;
akmihq3: akmiroom
	north = akmihq1
	south = akmihq8
	exits = "The hall leads north and south."
;
akmihq4: akmiroom
	east = akmihq7
	west = akmihq1
	exits = "The hall leads east and west."
;
akmihq5: akmiroom
	east = akmihq1
	west = akmihq9
	exits = "The hall leads east and west."
;
akmihq6: akmiroom
	north = akmihq10
	south = akmihq2
	exits = "The hall leads north and south."
;
akmihq7: akmiroom
	east = akmihq11
	west = akmihq4
	exits = "The hall leads east and west."
;
akmihq8: akmiroom
	north = akmihq3
	south = akmihq12
	exits = "The hall leads north and south."
;
akmihq9: akmiroom
	east = akmihq5
	west = akmihq13
	exits = "The hall leads east and west."
;
akmisealeddoor: floatingdecoration
	sdesc = "sealed metal door"
	ldesc = {
		"It's a giant metal door, with no obvious opening
		mechanism.";
	}
	noun = 'door'
	adjective = 'sealed' 'metal' 'akmi'

	loclist = [akmihq10 akmihq11 akmihq12]

	verDoOpen(actor) = {
		"It is far from obvious how to do that from here.";
	}
	verDoClose(actor) = {
		"It's already closed.";
	}
;
class akmiend: Room
	tripped = nil

	sdesc = "At the End of a Corridor in Plast"
	ldesc = {
		I(); "The hallway ends at a sealed door here.
		There is no obvious way out except back the
		way you came.";
	}
	enter(actor) = {
		if (self.tripped) {
			inherited.enter(actor);
			return;
		}

		I(); "The moment you enter the room, a klaxon sounds and
		the yellow stripes on the walls glow as brightly as a
		star. They're energy weapons -- you've tripped
		the security system! ";

		if (mirror.isin(self)) {
			P(); I(); "A voice inside your head intones,
			\"Worry	not, my child.\" "; P(); I();

			if (mirror.isin(Me))
				"The mirror flies away from you
				and onto the floor!  The mirror ";
			else
				"You see that the mirror ";

			"seems to be absorbing the energy blast from
			the walls!  After a few long minutes, the
			waves of heat and light subside.";

			mirror.movein(self);
		}
		else {
			"The white light is the last thing you see...";

			notify(deathobject, &death, 0);
			return;
		}

		self.tripped := true;
		P(); inherited.enter(actor);
	}
;

akmihq10: akmiend
	south = akmihq6
;
akmihq11: akmiend
	west = akmihq7
;
akmihq12: akmiend
	north = akmihq8
;
akmihq13: akmiend
	sdesc = "At the End of a Corridor in Plast"
	ldesc = {
		I(); "The hallway ends here at an open door leading
		west into a small room. ";
	}
	east = akmihq9
	west = ventilationduct
;
ventilationduct: Room
	firsttime = true

	noun = 'duct' 'shaft' 'room' 'area'
	adjective = 'ventilation' 'cramped' 'service'
	
	sdesc = "Cramped Service Area"
	ldesc = {
		I(); "This tiny cubicle must only be here for workers
		to service equipment.  There are many panels here
		firmly held in place with triangular screws.  There
		is a ventilation shaft at floor level in the west wall.
		But it's not quite big enough for you to fit through, 
		I'm afraid.";
	}

	enter(actor) = {
		inherited.enter(actor);

		if (self.firsttime) {
			self.firsttime := nil;

			P(); I(); "JC comes in over the crypto watch.
			\"I've managed to get a visual on you by tapping
			into the security monitors.  I didn't
			realize the duct was so small!  Unless
			you've got a bright idea, this may be it.
			I've been over it and over it, and I just
			don't see any other way in.\"  You have
			never heard sorrow like the sorrow in 
			JC's voice right now."; P();

			"\"We haven't lost yet,\" you say aloud, 
			knowing JC probably can't hear.  The watch
			goes dark.";
		}
	}

	east = akmihq13
	west = {
		"No chance -- no human being could possibly fit
		into that little shaft.";

		return nil;
	}
;
panels: Decoration
	isplural = true
	sdesc = "panels"
	ldesc = {
		"You can only assume the panels hide machinery
		of some kind.";
	}
	noun = 'panels' 'panel'
	location = ventilationduct

	verDoUnscrew(actor) = { panelscrews.verDoUnscrew(actor); }
	verDoScrew(actor) = { panelscrews.verDoScrew(actor); }
	verDoUnscrewwith(actor, io) = {
		panelscrews.verDoUnscrewwith(actor, io);
	}
	verDoScrewwith(actor, io) = { panelscrews.verDoScrewwith(actor, io); }
;
panelscrews: Part
	partof = panels
	sdesc = "triangular screws"
	noun = 'screws' 'screw' 'triangular'

	oops = { "You don't have a triangular screwdriver."; }
	verDoUnscrew(actor) = {	self.oops; }
	verDoScrew(actor) = { self.oops; }
	verDoUnscrewwith(actor) = { self.oops; }
	verDoScrewwith(actor) = { self.oops; }
;
akmishaft: Qcontainer
	sdesc = "ventilation shaft"
	ldesc = {
		"The shaft is dark.  You assume that it carries
		cool air to the computers and other temperature-sensitive
		equipment.";
	}

	noun = 'shaft' 'duct' 'dark'
	adjective = 'ventilation'
	location = ventilationduct

	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		if (dobj = squirt) {
			"You push little squirt into the ventilation
			shaft.  He rotates around to face you, blinks
			his tiny LED eyes in disbelief, turns, and
			heads into the gloom.";

			squirt.inshaft := true;
			squirt.direction := 3; // facing west
			squirt.path := [];
			squirt.movein(nil);
		}
		else {
			"It's just a ventilation shaft.  Stuffing
			<<dobj.objthedesc(nil)>> into it won't
			help matters any.";
		}
	}	
;
#endif	/* DEMO */
