#include "monstros.t"

modify movableActor
	verDoElpulc(actor) = {"Nothing appears to happen.";}

	verDoCluple(actor) = {
		if (actor == self) {
			if (actor == actor.form) {
				"Nothing appears to happen.  (Duh.)";
			} else {
				"Your form isn't here for the spell to use.  You'll
				just have to wait for the spell to wear off.";
			}
		} else if (actor != actor.form) {
			"Nothing happens.  Apparently, the spell won't work if you're
			already in some other form.";
		}
	}
	doCluple(actor) = {
		local change, o;
		
		"You ";
		if (self.bulk < actor.bulk) {"shrink "; change = -1;}
		if (self.bulk == actor.bulk) {"transform "; change = 0;}
		if (self.bulk > actor.bulk) {"grow "; change = 1;}
		"into an exact replica of << self.thedesc >>.";

		if (bulk < actor.bulk) {
			o = car(actor.contents);
			if (nil != o) "  You drop all your possessions.";
			while (nil != o) {
				o.moveInto(actor.location);
				if (o.weight > self.weight && rand(2) == 1) {
					"  Unfortunately, << o.thedesc >> falls on you
					as you shrink and crushes you.  You probably
					should have dropped it first.";
					global.status = 'squashed insect';
					die(nil);
				}
				o = car(actor.contents);
			}
		}

		actor.bulk = self.bulk;
		actor.weight = self.weight;
		actor.maxbulk = self.maxbulk;
		actor.maxweight = self.maxweight;
		actor.form = self;

		// Set the fuse to reset actor to normal form.
		notify(actor, &unCluple, 6);

		if (guard.location == Me.location) {
			"\bThe guard looks at you, startled, blinks rapidly several times,
			then shrugs and returns to attention.";
		}
	}
	unCluple = {
		"\bAbruptly, you resume your normal form.";
		self.form = Me;  // Really ought to be self, not Me.
		self.weight = 10;
		self.bulk = 10;
		self.maxweight = 10;
		self.maxbulk = 10;

		if (guard.location == Me.location) {
			"\bThe guard glances at you, looks away, then suddenly looks
			at you again, mouth open as if about to speak.  Instead, he
			looks carefully around, then finally says to you, \"Did you
			just see....  Oh, never mind.\"  He shudders just a bit, then
			returns to attention.";
		}
	}

	verDoCutWith(actor, weapon) = {self.verDoAttackWith(actor, weapon);}
	doCutWith(actor, weapon) = {self.doAttackWith(actor, weapon);}

	verDoGreet(actor) = {
		"\^<< self.thedesc >> doesn't appear interested.";
	}
;

modify Actor
	weight = 10
	bulk = 10
;

replace Me: basicMe, almTopic, monTopic
	noun = 'apprentice'
	smelldesc = "You smell acceptable by most standards."
	touchdesc = "This isn't that kind of story!"
	listendesc = "Not unless you say something interesting."
	form = Me
	doInspect (actor) = {
		form != Me ? "You look just like << self.form.thedesc >>." :
			inherited.ldesc;
		if (uniform.isworn) {
			"  You're wearing a guard uniform.";
		}
	}
	doListenTo (actor) = {form != Me ? "You sound just like << self.form.thedesc >>." : inherited.listendesc;}
	doSmell (actor) = {
		if (pit.isseen) {
			"You probably shouldn't have taken that excursion in the
			garderobe.  No time to bathe now, though.  Besides you aren't due
			for months.";
		} else if (uniform.isworn) {
			"You smell of ammonia.  Maybe you should take off the uniform.";
		} else {
			form != Me ? "You smell just like << self.form.thedesc >>." :
				inherited.smelldesc;
		}
	}
	doTouch (actor) = {form != Me ? "You feel just like << self.form.thedesc >>." : inherited.touchdesc;}
	monKnows = disguise.monKnows
	title = "My Apprentice"
	entry = "This page is smeared with unidentifiable food stains, but you can make out
		a few things here and there, like \"good kid\" and \"clever\" and \"might
		replace me one day.\"  Lest you let these praises go to your head, however,
		you can also make out \"weak-willed\" and \"plays rather than doing
		work.\""

	actorAction( v, d, p, i ) = {
		if (v.speech) {
			if (fly == form) {
				"You're a fly.  Flies can't talk.  Ergo, you can't do that.";
				exit;
			} else if (dukesroom == location) {
				oswale.awakens;
				exit;
			}
		}

		// Let everything pass unless the player is a fly or raven.
		if (fly != Me.form && raven != Me.form) {
			return;
		}
		
		if (isclass(v, sysverb) || isclass(v, travelVerb) || v.sight ||
			smellVerb == v || listenVerb == v || listentoVerb == v ||
			touchVerb == v || eatVerb == v) {
			return;
		}

		if (wearVerb == v) {
			"You can't wear anything in this form.";
			exit;
		}

		if (nil != d) {
			if (maxweight < d.weight) {
				"\^<< d.thedesc >> is too heavy.";
				exit;
			}
			if (maxbulk < d.bulk) {
				"\^<< d.thedesc >> is too big.";
				exit;
			}
		}
		if (nil != i) {
			if (maxweight < i.weight) {
				"\^<< i.thedesc >> is too heavy.";
				exit;
			}
			if (maxbulk < i.bulk) {
				"\^<< i.thedesc >> is too big.";
				exit;
			}
		}
	}

	verDoElpulc(actor) = {
		if (Me == Me.form) {
			inherited.verDoElpulc(actor);
		}
	}
	doElpulc(actor) = {
		unnotify(Me, &unCluple);
		Me.unCluple;
	}

	verDoAskAbout(actor, iobj) = {
		"Okay.  What about << iobj.thedesc >>?";
	}
	verDoTellAbout(actor, iobj) = {
		"Why don't you look that up in the almanac?";
	}

	verDoGreet(actor) = {}
	doGreet(actor) = {helloVerb.action(actor);}

	moveInto(obj) = {
		if (workshop == obj && find(hintVerb.hintlist, startroom)) {
			hintVerb.hintlist -= startroom;
		}
		inherited.moveInto(obj);
	}
;

wings: bodypart
	noun = 'wings' 'wing'
	sdesc = "wings"
	ldesc = "They look like the wings of << Me.form.adesc >>."
	isplural = true
	location = {
		if (Me.form.canfly) {
			return (Me.location);
		} else {
			return (nil);
		}
	}
	doMove(actor) = {
		"You flap your wings about experimentally.";
	}
;

modify hands
	location = {
		if (Me.form.canfly) {
			return nil;
		} else {
			return inherited.location;
		}
	}
;

dragon: Actor, monTopic, almTopic
 	islaunching = {return (engine.ison && engine.isfixed);}
	rampaging = 4
	noun = 'dragon' 'ship' 'spaceship'
	plural = 'dragons'
	adjective = 'huge' 'metallic' 'space'
	title = "Dragons"
	entry = "\"Dragons range from teakettle size to tower size, with many variations
		in shape, color, and temperament in between.  Different types of dragons
		actually have little in common except for a generally
		reptilian configuration and a tendency to be remarkably dangerous
		when hostile.  A direct frontal assault
		nearly always results in disaster against all but the smallest of
		dragons.  Subterfuge and/or negotiation usually are the best ways of
		handling draconic threats.\""
	sdesc = "dragon"
	ldesc = {
		"It's big as a house and covered with gleaming silver scales.  Its
		eyes are like windows and its claws are like swords.";
		if (town == ropes.location) {
			"  The dragon ship is ";
			islaunching ? "straining upward against" : "covered with";
			" thousands of ropes.";
		}
		if (mouthin.isopen) {
			"  Its mouth is open wide, inviting anyone to
			walk right in.";
		}
	}
	listendesc = "It emits a constant low hum, almost like a purr."
	touchdesc = {
		if (0 < self.rampaging) {
			"%You% bravely run%s% up and touch%es% it.  ";
		}
		"Its scales are hard and cold like steel.";
	}
	disavow = "It does not reply."
	weight = 1000
	bulk = 1000
	maxweight = 500
	maxbulk = 500
	verDoCluple(actor) = {"Nothing happens.  Strange.";}
	actorDesc = {
		if (islaunching) {
			"The dragon ship is struggling to rise, but the ropes keep
			it tethered.";
		} else {
			switch (self.rampaging) {
			case 4: "  A dragon is destroying the town.";
				break;
			case 3:
			case 2:
			case 1: "  The dragon is staring at you intently.";
				break;
			default: "  A dragon lies quietly in the town square, seemingly
				asleep.";
				if (mouthin.isopen) {
					"  Its mouth is wide open, as if frozen in
					mid-yawn.";
				}
			}
			if (town == ropes.location) {
				"  It's tied down with thousands of ropes.";
			}
		}
	}
	location = town
	actorDaemon = {
		if (self.location == Me.location) {
			switch (rand(5)) {
			case 1:
				"\bYou hear a ring of metal as a thrown rock strikes
				the dragon. ";
				break;
			case 2:
				"\bRearing up on its hind legs, the dragon pulls down
				the wall of another house with its forelimbs. ";
				break;
			case 3:
				"\bThe dragon carelessly steps on a wagon and utterly
				crushes it. ";
				break;
			case 4:
				"\bA blast of fire from the dragon's nostrils incinerates
				a door and the beast
				forces its head inside.  A moment later
				it pulls its head out and continues its rampaging. ";
				break;
			case 5:
				"\bThe dragon's tail swats aside an attacking townsman. ";
				break;
			}
		}
	}

	gotAttention = {
		if (location != Me.location) {return (nil);}

		unnotify(self, &gotAttention);
		switch (self.rampaging--) {
		case 4: unnotify(self, &actorDaemon);
			"\bThe dragon stops its rampaging and turns to face you.  After a
			moment, it says \"Fergluzzle zwack curnofle post dtew?\", or
			something very close to that.";
			break;
		case 3: "\b\"Sefeloni lo to gatsu aro booni-booni?\" the dragon says.";
			break;
		case 2: "\b\"Parlez-vous Francais?\" the dragon says.";
			break;
		case 1: "\bThe dragon lumbers in your direction until it towers over
			you, and it lowers its head, jaws open wide.  You throw
			your arms up in terror and close your eyes, but the expected
			rending and chewing doesn't occur.  When you open your eyes again,
			you see that the dragon is lying on the ground before you, and
			a monstrosity is emerging from its mouth.  The dragon shuts its
			jaws once more as you and the monstrosity look each other over.\b";
			monstrosity.moveInto(town);
			monstrosity.ldesc;
			"\bThe monstrosity says \"For naga to la zuri?\"  When you don't
			seem to understand, it fiddles with the little box on its neck,
			shrugs, and says \"Lef gurkles, som dela tor nog fufu.\"";
			notify(monstrosity, &actorDaemon, 0);
			unnotify(self, &actorDaemon);

			if (find(hintVerb.hintlist, self)) {
				hintVerb.hintlist -= self;
			}

			return (nil);
		default:
		}
		notify(self, &gotAttention, 2);
	}
	
	doAskAbout(actor, iobj) = {
		if (0 < self.rampaging) {
			gotAttention;
		} else {
			inherited.doAskAbout(actor, iobj);
		}
	}
	verDoTellAbout(actor, iobj) = {}
	doTellAbout(actor, iobj) = {
		if (0 < self.rampaging) {
			gotAttention;
		} else {
			inherited.doTellAbout(actor, iobj);
		}
	}
	actorAction( v, d, p, i ) = {
		if (fly == Me.form) {
			"You can't speak!";
			exit;
		} else if (0 < self.rampaging) {
			gotAttention;
			exit;
		} else {
			inherited.actorAction(v,d,p,i);
		}
	}
	verDoGreet(actor) = {}
	doGreet(actor) = {gotAttention;}
	verIoShowTo(actor) = {}
	ioShowTo(actor, dobj) = {
		if (0 < self.rampaging) {
			gotAttention;
		} else {
			inherited.ioShowTo(actor, dobj);
		}
	}
	verIoGiveTo(actor) = {}
	ioGiveTo(actor, dobj) = {
		if (0 < self.rampaging) {
			gotAttention;
		} else {
			inherited.ioGiveTo(actor, dobj);
		}
	}
	verDoYellAt(actor) = {}
	doYellAt(actor) = {yellVerb.action(actor);}

	verDoAttackWith(actor, weapon) = {}
	doAttackWith(actor, weapon) = {
		if (hands == weapon) {
			"After several whaps from the dragon's tail and a few
			nasty gashes from those razor-sharp claws, you are
			convinced that fighting this particular dragon won't
			be that easy.";
		} else if (rampaging == 4) {
			"Violence is obviously not the solution here.  Have you
			looked at the size of this thing?";
		} else {
			"The dragon ignores %your% feeble attack.  ";
		}
	}

	verDoEnter(actor) = {mouthin.verDoEnter(actor);}
	doEnter(actor) = {
		"(Wasn't that a Bruce Lee movie?)\n";
		return mouthin.doEnter(actor);
	}
	monKnows = {
		"\"Yeah, it looks like some sort of big reptile, doesn't it?
		The transmogrifier selected for the largest terrestrial landform
		on the planet and reshaped the hull accordingly.  Good thing it
		wasn't damaged in the crash.\"";
		if (monstrosity == box.location) {
			"  He bangs on the box around his neck.";
		}
	}

	hintlevel = 1
	hint1 = "Violence won't get you anywhere."
	hint2 = "Perhaps the dragon is open to negotiation."
	hint3 = "Go to Town and say \(DRAGON, STOP\).  Keep trying to communicate with
		it until it stops talking."
;

fly: Actor
	noun = 'fly' 'housefly'
	adjective = 'black' 'small' 'house' 'disgusting'
	sdesc = "fly"
	ldesc = "It buzzes about quite noisily.  It's small, black, and
		as thoroughly disgusting as any other housefly you have	seen. "
	listendesc = "\"Buzz buzz buzz.\""
	canfly = true
	disavow = self.listendesc
	verDoSmell(actor) = {
		"It won't hold still long enough for you to do that.
		I wouldn't recommend it even if it would.";
	}
	weight = 0
	bulk = 0
	maxweight = 0
	maxbulk = 0
	actorDesc = "A fly buzzes around you. "
	location = nil
	flyspeak = 1
	actorDaemon = {
		local lunchroom = uberloc(lunch);
		if (self.location != lunchroom) {
			if (self.location == Me.location) {
				"\bThe fly buzzes noisily out of the area. ";
			}
			self.moveInto(lunchroom);
			if (self.location == Me.location) {
				"\bA fly buzzes noisily into the area. ";
			}
			return;
		}

		if (self.location == Me.location) {
			if (westwing == location && garderobedoorin.isopen) {
				if (westwing == Me.location) {
					"\bThe fly seems extremely agitated here.  It
					zips around even more noisily than usual.";
				}
				return;
			}
			if (garderobe == location) {
				if (garderobe == Me.location) {
					"\bThe fly zips around a bit, entranced by the
					aroma here, and then dives into the hole.";
				}
				self.moveInto(pit);
				unnotify(self, &actorDaemon);
				return;
			}

			if (box.isVisible(fly) && head.isseen) {
				"\bThe fly lands on the little box, and the box says ";
				if (1 == rand(5)) {
					"something quite unintelligible about
					unmatched socks.";
				} else {
					switch (flyspeak++) {
					case 2:
						"\"I'm Zefron!\"";
						addword(self, &noun, 'zefron');
						addword(self, &noun, 'wizard');
						addword(self, &noun, 'master');
						break;
					case 3:
						"\"I clupled a fly, but put far too much
						power into the spell.\"";
						break;
					case 4:
						"\"By my calculations, with the power
						I used on the spell, I'll be in this form
						for thirty years!\"";
						break;
					case 5:
						"\"But as a fly I'll only live thirty
						days!\"";
						break;
					case 6:
						"\"There's a spell in my almanac that will change
						me back, but I can't cast it because flies can't
						speak.\"";
						break;
					case 7:
						"\"Look up elpulc.\"";
						break;
					default:
						"\"Help me!\"";
					}
				}
				return;
			}

			switch (rand(5)) {
			case 1:
				"\bThe fly dives at you, then zips away. ";
				break;
			case 2:
				"\bThe fly lands on the lunch and laps at the congealed
				grease. ";
				break;
			case 3:
				"\bThe fly lands on the wall and cleans
				its filthy wings with its filthy legs. ";
				break;
			case 4:
				"\bThe fly buzzes noisily about overhead. ";
				break;
			case 5:
				"\bThe fly lands on you, but then zips away before
				you can do anything about it. ";
				break;
			}
		}
	}

	actorAction( v, d, p, i ) = {
		if (fly == Me.form) {
			"You can't speak!";
			exit;
		} else {
			inherited.actorAction(v, d, p, i);
		}
	}

	verDoAttackWith(actor, weapon) = {}
	doAttackWith(actor, weapon) = {
		switch (rand(4)) {
		case 1:
			"%You% smash%es% the fly into a little bloody smear.";
			self.moveInto(nil);
			unnotify(self, &actorDaemon);
			break;
		default:
			"%You% miss%es%!";
		}
	}

	hintlevel = 1
	hint1 = "Have you examined everything you can carry?"
	hint2 = "Make sure the fly doesn't get killed."
	hint3 = "The fly is required for three separate puzzles."
;

guard: Actor, obstacle
	isHim = true
	noun = 'guard' 'soldier' 'warrior' 'himself'
	sdesc = "guard"
	ldesc = "The vacuous grin on his face clearly reveals this fellow's IQ.  He's
		wearing the official palace arms of Fimpoz, which include a very
		large sword.  A dangerous combination."
	actorDesc = {
		"A guard stands rigidly at attention";
		if (courtyard == location) {
			" at his post by the portcullis. ";
		} else {
			" here.";
		}
	}
	location = courtyard
	warn = 0 // Remember how many times the guard warns us about the gate.
	flees = {
		self.moveInto(garderobe);
		garderobedoorin.isopen = nil;
		garderobedoorout.isopen = nil;
		garderobedoorin.islocked = true;
		garderobedoorout.islocked = true;
		unnotify(self, &actorDaemon);
		
		if (find(hintVerb.hintlist, self)) {
			hintVerb.hintlist -= self;
		}
	}
	clotheswarn = nil
	actorDaemon = {
		if (self.location == Me.location) {
			if (uniform.isworn) {
				"\b\"It's about time you showed up!\"\ the guard says.
				\"I've been waiting hours
				past my watch for another guard to relieve me.  I was beginning
				to think the dragon had scared everyone off.\"  He removes
				his sword and hands it to you.  \"Listen, you guard this
				gate with your very life, and don't let anyone by.  It's
				terribly perilous out there.  You be careful.  And now,
				I've really got to visit the garderobe.\"  He claps you
				on the shoulder and runs off.  ";
				if (hat.isworn) {
					"Just before he disappears he shouts back at you,
					\"And take off that ridiculous hat.  It's against
					regulations, and it makes you look more like a wizard
					than a guard.\"  Then he's gone.";
				}
				self.flees;
				sword.moveInto(Me);
				return;
			}
			
			if (oswale == Me.form) {
				"\bThe guard remains rigidly at attention.";
				return;
			}

			if (monstrosity == Me.form) {
				"\bThe guard screams \"A demon!\"\ and flees in terror.";
				self.flees;
				return;
			}

			if (guard.location == fly.location) {
				"\bLooking mildly irritated, the guard swipes at the fly
				with his sword and ";
				switch (rand(4)) {
				case 1:
					"smashes it into a little bloody smear.";
					fly.moveInto(nil);
					unnotify(fly, &actorDaemon);
					break;
				case 2: "narrowly misses you.";
					break;
				default:
					"misses.";
				}
				return;
			}

			if (fly == Me.form) {
				"\bLooking mildly irritated, the guard swipes at you with
				his sword and ";
				switch (rand(4)) {
				case 1:
					"smashes you into a little bloody smear.";
					global.status = 'little bloody smear';
					die(guard);
					break;
				case 2: "narrowly misses.";
					break;
				default:
					"misses.";
				}
				return;
			}

			if (raven != Me.form && !clothes.isworn && !clotheswarn) {
				"\b\"Hey!\" the guard says.  \"You can't walk around
				like that.  It's indecent!\"";
				clotheswarn = true;
				return;
			}
			
			if (guard == Me.form) {
				"\bThe guard looks you up and down, and looks just a bit
				puzzled.  ";
				if (1 == rand(5)) {
					"You hear him say under his breath \"Gosh, he sure
					reminds me of someone.\"";
				}
				return;
			}

			switch (rand(10)) {
			case 1:
				"\bThe guard shifts his weight from foot to foot.  He
				crosses his legs briefly, looking pained, then does
				his best to return to attention.  ";
				break;
			case 2:
				"\bThe guard dutifully cleans his olfactory passages.  If
				a normal person's finger was inserted so deeply he'd
				scratch his brain, but you don't fear for this fellow. ";
				break;
			case 3:
				"\bThe guard abruptly salutes for no apparent
				reason. ";
				break;
			case 4:
				"\bThe guard draws his sword and waves it about experimentally.
				Apparently satisfied, he puts it away again. ";
				break;
			case 5:
				"\bThe guard hiccups loudly. ";
				break;
			default:
			}
		}
	}

	verDoAttackWith(actor, weapon) = {
		if (guard == sword.location) {
			"That wouldn't be very smart.  He has a sword!";
		} else {
			inherited.verDoAttackWith(actor, weapon);
		}
	}

	disavow = "\"Sorry, can't talk, I'm guarding the castle.\""		
	actorAction( v, d, p, i ) = {
		if (fly == Me.form) {
			"You can't speak!";
			exit;
		} else if (oswale != Me.form) {
			if ((turnVerb == v && winch == d) ||
				(openVerb == v && portcullisout == d)) {
				"\"Are you insane?  And let that dragon in?\"";
			} else if (helloVerb == v) {
				self.doGreet(Me);
			} else {
				"\"I can't do that, I'm guarding the castle.\"";
			}
			exit;
		}
	}
	verDoTellAbout(actor, iobj) = {self.disavow;}
	verDoGreet(actor) = {}
	doGreet(actor) = {
		"\"Sorry, can't talk, I'm guarding the castle.
		There's a dragon outside.  That's what all the
		commotion's about.\"";				
	}

	destination = {	
		if (oswale == Me.form) {
			"The guard salutes and lets you pass, not daring to defy your
			royal authority.";
			return portcullisout;
		}
		switch (++guard.warn) {
		case 1:
			"The guard grabs you as you try to pass.  \"You can't go out
			there right now.  Don't you know there's a dragon out there?
			It's much too perilous.\"  Despite your protests, threats,
			and promises of orders from the duke, he drags you back away
			from the gateway, insisting \"No, no, it's too perilous.\"";
			break;
		case 2:
			"The guard draws his sword and stands in your path, doing his
			best to keep a scowl on his insipid face.  \"Now look, this is
			really for your own good.  The only way I'm opening this gate
			is under a direct order from the duke.\"";
			break;
		case 3:
			"The guard's sword hovers inches before your throat.  \"You
			just don't seem to understand.  It's not safe out there!  So,
			I'm afraid that if you try to get past me one more time, I
			shall have to kill you.  For your own protection, of course.\"";
			break;
		case 4:
			"\"All right then.  Sorry to have to do this....\"";
			global.status = 'safely dead' + global.status;
			die(guard);
		}
		return (nil);
	}

	hintlevel = 1
	hint1 = "Have you searched the whole castle yet?"
	hint2 = "The guard could use some relief."
	hint3 = "\(WEAR THE UNIFORM\) in front of the guard."
;

oswale: Actor, almTopic
	isHim = true
	noun = 'Oswale' 'duke'
	sdesc = "Duke Oswale"
	ldesc = "In polite company, you'd call the duke \"portly.\"  He's also short,
		balding, and pale.  Right now he looks his best, since he isn't
		stuffing his face or screaming."
	adesc = self.sdesc
	thedesc = self.sdesc
	listendesc = "\"Snaaaaugh.  Fffffffff.  Snaaaaaaugh.  Fffffffffff.\""
	disavow = listendesc
	actorDesc = "Duke Oswale is here, asleep in his bed."
	location = dukesbed
	verDoAttackWith(actor, weapon) = {
		"Strangely, he seems much less tyrannical asleep.  He looks almost
		innocent.  Maybe it's the stuffed bunny he's holding.  You manage
		to suppress the urge to assassinate him.  For now.";
	}
	actorDaemon = {
		if (dukesroom == Me.location) {
			switch (rand(8)) {
			case 1: "\bThe duke clutches a stuffed bunny protectively to
				his breast.";
				break;
			case 2: "\bThe duke's eyelids flutter, as if he's about to
				awaken!";
				break;
			case 3: "\bDuke Oswale rolls over and mumbles something about
				unmatched socks.";
				break;
			case 4: "\bA slow smile creeps across the sleeping duke's face.";
				break;
			case 5: "\bDuke Oswale flails his arms about for a second, then
				curls up into a fetal position.";
				break;
			default: "\bThe duke snores contentedly.";
			}
		}
	}
	title = "Duke Oswale the Pathetic"
	entry = "\"The worst of a line of poor dukes.  His only goal is self-glorification.
		A user of people and speaker of half-truths.  He compensates for feelings
		of inadequacy by abusing his sacred authority.  The best I can say about him
		is that he's quite easy to manipulate.  All you need do is lead him around
		by his ego.\""
		
	actorAction( v, d, p, i ) = {
		if (fly == Me.form) {
			"You can't speak!";
		} else {
			self.awakens;
		}
		exit;
	}

	awakens = {
		"At the sound of your voice, the duke starts awake.
		He scrambles for the head of his bed, holding his
		stuffed bunny protectively in front of him, and
		screaming for the guards.  They quickly shove their
		way into the room and carry you off to the dungeon.";
		global.status = 'prisoner';
		rescue();
	}
;

rabbit: Actor
	noun = 'rabbit'
	adjective = 'white'
	sdesc = "white rabbit"
;

raven: Actor, almTopic
	isHer = true
	noun = 'raven' 'bird' 'herself'
	plural = 'ravens'
	adjective = 'black' 'big'
	sdesc = "raven"
	ldesc = "She's a big black bird, about the size of a chicken."
	listendesc = "\"Cruuuuk.  Caw.\""
	disavow = "\"Nevermore.\""
	title = "Ravens"
	entry = "\"Ravens are among the most intelligent of birds.  They can use sticks as
		tools or toys, can learn to speak human language, and even seem to possess
		a sense of humor.  They can grow up to three pounds, with a wingspread
		of up to three feet, and live as long as 25 years.  Ravens are very
		territorial, especially with regard to others of their species during
		the mating season.\""
	canfly = true
	weight = 2
	bulk = 3
	maxweight = 3
	maxbulk = 3
	actorDesc = "A raven perches on the vines, munching on grapes. "
	location = garden
	verDoAttackWith(actor, weapon) = {}
	doAttackWith(actor, weapon) = {
		"Startled, the raven flies away.";
		self.moveInto(nil);
		unnotify(self, &actorDaemon);
	}
	actorDaemon = {
		if (raven.location == Me.location) {
			if (raven == Me.form) {
				"\bThe raven croaks and caws angrily at you, fluttering
				her wings and trying to scare you away.";
				return;
			}
			
			switch(rand(10)) {
			case 1:
				"\bThe raven greedily wolfs down another grape.";
				break;
			case 2:
				"\bThe raven clucks happily to herself, as if she were
				laughing.";
				break;
			case 3:
				"\bThe raven strokes her beak along a tree branch
				repeatedly, as if sharpening it.";
				break;
			case 4:
				"\bThe raven eyes you balefully, obviously resentful
				of your intrusion.";
				break;
			case 5:
				"\bThe raven hops to an adjacent vine and resumes her
				feast.";
				break;
			case 6:
				"\bThe raven stretches one wing, then the other.";
				break;
			default:
				if (self.location == fly.location) {
					"\bThe raven seems to have decided that after all
					the grapes she could use some protein.";
					switch (rand(3)) {
					case 1:
						"  She catches the fly in her bill and
						munches it up with great delight.";
						fly.moveInto(nil);
						unnotify(fly, &actorDaemon);
						break;
					default:
						"  She pecks at the fly and just misses.";
					}
					return;
				}

				if (fly == Me.form) {
					"\bThe raven seems to have decided that after all
					the grapes she could use some protein.";
					switch(rand(3)) {
					case 1:
						"  She catches you in her bill and munches
						you up with great delight.";
						global.status = 'light snack';
						die(raven);
						break;
					default:
						"  She pecks at you and just misses.";
					}
					return;
				}

			}
		}
		
	}
	
	actorAction( v, d, p, i ) = {
		if (fly == Me.form) {
			"You can't speak!";
		} else {
			if (helloVerb == v) {
				self.doGreet(Me);
			} else {
				self.disavow;
			}
		}
		exit;
	}
	verDoGreet(actor) = {}
	doGreet(actor) = {
		"She cocks her head and looks at you, but doesn't reply.";
	}
	verDoAskAbout(actor, iobj) = {
		if (self == iobj) {
			"\"Caw.  How is a raven like a writing desk?  Caw.\"";
		} else if (writingdesk == iobj) {
			"\"Caw.  We both produce very few notes, which are
			always flat, and we both have inky quills.  Cuk cuk cuk.\"";
		} else {
			self.disavow;
		}
	}

	hintlevel = 1
	hint1 = "The raven is no threat to someone your size."
	hint2 = "Someone smaller than yourself might put off meeting with the raven."
	hint3 = "Don't enter the garden as a fly until the cluple spell has almost
		worn off.  The raven then only has a very small chance of killing you."
;

writingdesk: fixedItem
	noun = 'desk' 'answer' 'riddle'
	adjective = 'writing'
	sdesc = "writing desk"
;

zefron: Actor, almTopic
	isHim = true
	noun = 'Zefron' 'wizard' 'master' 'himself'
	adjective = 'my'
	sdesc = "Zefron"
	adesc = self.sdesc
	thedesc = self.sdesc
	ldesc = "He looks rather worn by his experiences of the last few hours.
		Other than that he looks the same as he did yesterday."
	title = "Zefron"
	entry = "\"As of this writing, Zefron lives in the Royal Duchy of Fimpoz, as Royal
		Wizard to Duke Oswale of Fimpoz.  He is a master of several branches
		of magic and philosophy.  His most current project is a spell to allow
		the caster to take the form of another creature.\""
	actorDesc = {
		if (workshop == self.location) {
			"Zefron sits at his workbench, hunched over a notebook.";
		} else {
			"Zefron is here.";
		}
	}
	location = nil
	verDoElpulc(actor) = {
		if (!fly.isVisible(actor)) {
			inherited.verDoElpulc(actor);
		}
	}
	doElpulc(actor) = {
		"The fly grows and transforms into your master, Zefron!
		Caught in mid-flight, he falls with a thump.";
		zefron.moveInto(fly.location);
		fly.moveInto(nil);
		unnotify(fly, &actorDaemon);
		notify(zefron, &actorDaemon, 0);
	}
	doCluple(actor) = {
		inherited.doCluple(actor);
		"\bZefron raises a bushy gray eyebrow, but says nothing.";
	}

	clotheswarn = nil
	firstspeak = nil
	actorDaemon = {
		if (location != Me.location && !firstspeak) {
			"\bYou hear a soft \>\>Foof!\<\< of outrushing air behind you, and
			turn to see that Zefron has appeared there.";
			zefron.moveInto(Me.location);
		}
		if (location == Me.location) {
			if (!firstspeak) {
				if (find(hintVerb.hintlist, self)) {
					hintVerb.hintlist -= self;
				}
				if (find(hintVerb.hintlist, fly)) {
					hintVerb.hintlist -= fly;
				}
				
				"\b\"Thank you my child, thank you for releasing me from
				that form.  How foolish of me to
				experiment with a fly first.  I should have tried to take
				the form of a raven; at least they can talk, and I would
				have been able to change myself back.\"  He rubs his sore
				buttocks.  \"I wish I had known what you were about.  I
				could have landed first.  No matter now though.\"\b
				\"We seem to be in a time of crisis, but you are handling
				it well enough.  I believe I will make this your journeyman
				test.  If you succeed, your apprenticeship will be at an
				end.  If you fail, well...\ do not.\"\b
				\"I will be watching you from my workshop.
				If you have any questions, consult my almanac.  Nearly
				everything I know is in there, and I give it to you.
				Think of it as a graduation present in advance.  If you
				really truly need help, I will intervene, but
				you will fail your journeyman test.\"\b
				\"Oh, and one more thing I will do to help.\"  He mutters
				a couple of magic words, something like \"foof little
				box,\" and a little box appears
				in his hand.  As he incants over it, it pops and hisses
				and then falls silent.  \"That should work better now,\"
				he says, handing it to you.  \"No more of that nonsense
				about unmatched socks.\"\b
				Zefron slaps at his sides and looks about, as if looking
				for his keys.  \"Well, that should do it.  Good luck.  I
				look forward to seeing how things turn out.\"";
				if (workshop == zefron.location) {
					"  He turns to his workbench, takes out a
					notebook, and begins writing.";
				} else {
					"  He winks at
					you, says a single word, then vanishes.";
					zefron.moveInto(workshop);
				}
				box.moveInto(Me);
				box.isfixed = true;
				firstspeak = true;
				global.status = 'journeyman wizard testee';
			} else {
				if (!Me.form.canfly && !clotheswarn &&
					!clothes.isworn && !uniform.isworn) {
					"\b\"You really ought to keep better track of
					your clothes, child.  You could catch a cold
					running about like that,\" Zefron says.";
					clotheswarn = true;
					return;
				}
					
				switch(rand(10)) {
				case 1:
					"\bZefron glances at you momentarily, then
					continues writing.";
					break;
				case 2:
					"\bZefron stops scribbling for a moment to stretch
					his fingers.  \"Got to watch out for those
					repetitive strain injuries, you know,\" he says.";
					break;
				case 3:
					"\bZefron scowls.  \"Blasted scriptographical
					errors.\"  He wipes the offending ink from the
					page with the end of the quill, and the marks
					vanish.  \"Good thing I put that autocorrection
					spell on this quill.\"";
					break;
				case 4:
				case 5:
					"\bZefron dips his quill in the ink, then
					continues writing.";
					break;
				default:
					"\bZefron sits at his workbench, scribbling in a
					notebook with a hawk's quill.";
				}
			}
		}
	}
	
	disavow = "\"There's no time to discuss that right now.\""
	actorAction( v, d, p, i ) = {
		if (fly == Me.form) {
			"You can't speak!";
			exit;
		} else if (helpVerb == v) {
			return;
		} else if (helloVerb == v) {
			self.doGreet(Me);
			exit;
		} else {
			inherited.actorAction(v, d, p, i);
		}
	}
	verDoGreet(actor) = {}
	doGreet(actor) = {
		"\"Hello, child.  Is there something on your mind?\"";
	}
	verDoAskAbout(actor, iobj) = {
		if (self == iobj) {
			"\"I feel fine now, thank you.\"";
		} else if (isclass(iobj, almTopic)) {
			"\"Why don't you just look that up in the almanac?\"";
		} else {
			self.disavow;
		}
	}
	verDoTellAbout(actor, iobj) = {
		"\"That's fascinating, really, but you ought to get back to
		your test.\"";
	}

	hintlevel = 1
	hint1 = "Have you been inside the dragon yet?"
	hint2 = "Zefron is closer than you think."
	hint3 = "\(ELPULC ZEFRON\) while the fly is in the room (but not before
		you enter the dragon).  Alternatively, if you and the fly are
		both inside the dragon, \(PRESS THE BLUE BUTTON\)."
;

