// CYEXAMPLE.T

// A sample hybrid of CYOA with tradition interactive fiction

#include <adv.t>
#include <std.t>
#include "cyoa.t"

startroom: room
	sdesc = "Outside Cave"
	ldesc = "You're standing in the bright sunlight just outside of a
	large, dark, forbidding cave, which lies to the north."
	north = cave
	menu = OutsideCaveMenu
;

OutsideCaveMenu: Menu
// All of these responses could be implemented as much simpler
// possibilities (SOUTH for the first, and EXAMINE CAVE for the second,
// but you get the idea.
	choices = [
		['Head for town.',  &headForTown, goldSkull.location = Me]
		['Examine the cave.', &exCave]
	]
	headForTown = {
		"Having retrieved the ancient skull, you decide to head back to
		town.";
		scoreRank();
		input();
		quit();		
		abort;
	}
	exCave = {
		"The cave looks rather dark and forbidding, but you know there
		is a skull made of solid gold somewhere in that cave. You also
		know it is probably guarded by a trap!";
	}
;

cave: room
	sdesc = "Cave"
	ldesc = "You're inside a damp and musty cave. Sunlight pours in from
	a passage to the south."
	south = startroom
	menu = CaveMenu
;

// This menu is really more of a conversation menu, which isn't quite
// appropriate - conversations shouldn't be tied to place for a movable
// respondent. However, it does give you the basic idea, and the
// goldskull example doesn't really give a lot of scope for anything
// complicated anyway.
CaveMenu: Menu
	choices = [
		['Talk to the skull', &AskForHelp, (goldSkull.location = pedestal)]
	]
	AskForHelp = {
		"The skull speaks: \"Beware, for I am guarded by a most
		dangerous trap! Should all weight be removed from the pedestal,
		deadly poisonous arrows will kill the thief.\"";
		cave.menu := CaveMenu2;
	}
;

CaveMenu2: Menu
	choices = [
		['Ask the skull how much it\'s worth', &skullValue,
			self.askedValue = nil]
		['Ask the skull how to avoid the trap', &avoidTrap,
			self.askedTrap = nil]
	]
	skullValue = {
		"\"So how much are you worth, Mr. Skull?\" you ask.\b
		
		\"I weigh about 3 pounds, and the current price of gold is about
		300 dollars per ounce, so you can figure the minimum price from
		that. However, I am worth much more than the mere metal
		contained within me - after all, how many golden skulls actually
		speak?\"";
		self.askedValue := true;
	}
	avoidTrap = {
		"\"Do you know how I can avoid these oh-so-deadly arrows?\" you
		ask the skull.\b

		\"But of course - all you have to do is place another weight on
		the pedestal first - like, say, that small rock in the
		corner.\"";
		self.askedTrap := true;
	}
;

pedestal: surface, fixeditem
	sdesc = "pedestal"
	noun = 'pedestal'
	location = cave
;

goldSkull: item
	sdesc = "gold skull"
	noun = 'skull' 'head'
	adjective = 'gold'
	location = pedestal
	doTake(actor) = 
	{
		if (self.location <> pedestal or smallRock.location = pedestal)
		{
			incscore(100);
			pass doTake;
		}
		else
		{
			"As you lift the skull, a volley of poisonous arrows is shot
			from the walls! You try to dodge the arrows, but they take
			you by surprise!";
			die();
		}
	}
;

smallRock: item
	sdesc = "small rock"
	noun = 'rock'
	adjective = 'small'
	location = cave
;
