! ----------------------------------------------------------------------------
!  GRAMMAR:  Grammar table entries for the standard verbs library.
!
!  Supplied for use with Inform 6                         Serial number 990428
!                                                                  Release 6/9
!  (c) Graham Nelson 1993, 1994, 1995, 1996, 1997, 1998, 1999
!      but freely usable (see manuals)
! ----------------------------------------------------------------------------
!  The "meta-verbs", commands to the game rather than in the game, come first:
! ----------------------------------------------------------------------------

System_file;

!  ***ENGLISH*** Verb  meta 'score'
!  ***ENGLSH***                 *                                -> Score;
Verb  meta 'nilji^a'
                *                                -> Score;

!  ***ENGLISH*** Verb  meta 'fullscore' 'full'
!  ***ENGLSH***                 *                                -> FullScore
!  ***ENGLSH***                 * 'score'                        -> FullScore;
Verb  meta 'mulnilji^a' 'mulno'
                *                                -> FullScore
                * 'nilji^a'                        -> FullScore;

!  ***ENGLISH*** Verb  meta 'q//' 'quit' 'die'
!  ***ENGLSH***                 *                                -> Quit;
Verb  meta 's//' 'sisti' 'morsi'
                *                                -> Quit;

!  ***ENGLISH*** Verb  meta 'restore'
!  ***ENGLSH***                 *                                -> Restore;
Verb  meta 'veipli'
                *                                -> Restore;

!  ***ENGLISH*** Verb  meta 'restart'
!  ***ENGLSH***                 *                                -> Restart;
Verb  meta 'refcfa'
                *                                -> Restart;

!  ***ENGLISH*** Verb  meta 'verify'
!  ***ENGLSH***                 *                                -> Verify;
Verb  meta 'veicta'
                *                                -> Verify;

!  ***ENGLISH*** Verb  meta 'save'
!  ***ENGLSH***                 *                                -> Save;
Verb  meta 'vreji'
                *                                -> Save;

Verb  meta 'rejri^a'
                *                                -> Save;

Verb  meta 'rejgau'
                *                                -> Save;
		
!  ***ENGLISH*** Verb  meta 'script' 'transcript'
!  ***ENGLSH***                 *                                -> ScriptOn
!  ***ENGLSH***                 * 'off'                          -> ScriptOff
!  ***ENGLSH***                 * 'on'                           -> ScriptOn;
Verb  meta 'verci^a' 'ci^arvei'
                *                                -> ScriptOn
                * 'cfari'                        -> ScriptOff
                * 'sisti'                        -> ScriptOn;

!  ***ENGLISH*** Verb  meta 'superbrief' 'short'
!  ***ENGLSH***                 *                                -> LMode3;
Verb  meta 'raircmaski' 'traji' 'cmalu'
                * 'cmalu' 'skicu'                -> LMode3
                * 'skicu'                        -> LMode3
                *                                -> LMode3;
		
!  ***ENGLISH*** Verb  meta 'verbose' 'long'
!  ***ENGLSH***                 *                                -> LMode2;
Verb  meta 'braski' 'barda'
                * 'skicu'                        -> LMode2
                *                                -> LMode2;

!  ***ENGLISH*** Verb  meta 'brief' 'normal'
!  ***ENGLSH***                 *                                -> LMode1;
Verb  meta 'kauski' 'kampu'
                * 'skicu'                        -> LMode1
                *                                -> LMode1;

Verb  meta 'liste' 'l//'
                *                                -> Inv
                * 'to^unai'                      -> InvTall
                * 'tcila'                        -> InvTall
                * 'clani'                        -> InvTall
                * 'le' 'se' 'bevri'              -> Inv
                * 'le' 'selebei'/'bevri'/'dacti' -> Inv
                * 'le' 'basti'                   -> Pronouns
                * 'le' 'sumti'                   -> Pronouns
                * 'le' 'sumbasti'                -> Pronouns
		* 'le' 'nilji^a'                  -> Score;
		
Verb  meta 'sumbasti'
                * 				 -> Pronouns;

!  ***ENGLISH*** Verb  meta 'notify'
!  ***ENGLSH***                 * 'on'                           -> NotifyOn
!  ***ENGLSH***                 * 'off'                          -> NotifyOff;
Verb  meta 'junbe^i'
                * 'le' 'nilji^a' 'galfi'          -> NotifyOn
                * 'cfari'                        -> NotifyOn
                * 'sisti'                        -> NotifyOff;

!  ***ENGLISH*** Verb  meta 'version'
!  ***ENGLSH***                 *                                -> Version;
Verb  meta 'gafna^u'
                *                                -> Version;

#IFNDEF NO_PLACES;
!  ***ENGLISH*** Verb  meta 'places'
!  ***ENGLSH***                 *                                -> Places;
Verb  meta 'stuzi'
                *                                -> Places;
!  ***ENGLISH*** Verb  meta 'objects'
!  ***ENGLSH***                 *                                -> Objects;
Verb  meta 'dacti'
                *                                -> Objects;

#ENDIF;

! ----------------------------------------------------------------------------
!  Debugging grammar
! ----------------------------------------------------------------------------

! I don't care enough.  You're welcome to translate this if you wish.
! -Robin

#ifdef DEBUG;
Verb  meta 'trace'
                *                                -> TraceOn
                * number                         -> TraceLevel
                * 'on'                           -> TraceOn
                * 'off'                          -> TraceOff;
Verb  meta 'actions'
                *                                -> ActionsOn
                * 'on'                           -> ActionsOn
                * 'off'                          -> ActionsOff;
Verb  meta 'routines' 'messages'
                *                                -> RoutinesOn
                * 'on'                           -> RoutinesOn
                * 'off'                          -> RoutinesOff;
Verb  meta 'timers' 'daemons'
                *                                -> TimersOn
                * 'on'                           -> TimersOn
                * 'off'                          -> TimersOff;
Verb  meta 'changes'
                *                                -> ChangesOn
                * 'on'                           -> ChangesOn
                * 'off'                          -> ChangesOff;
Verb  meta 'recording'
                *                                -> CommandsOn
                * 'on'                           -> CommandsOn
                * 'off'                          -> CommandsOff;
Verb  meta 'replay'
                *                                -> CommandsRead;
Verb  meta 'random'
                *                                -> Predictable;
Verb  meta 'purloin'
                * multi                          -> XPurloin;
Verb  meta 'abstract'
                * noun 'to' noun                 -> XAbstract;
Verb  meta 'tree'
                *                                -> XTree
                * noun                           -> XTree;
Verb  meta 'goto'
                * number                         -> Goto;
Verb  meta 'gonear'
                * noun                           -> Gonear;
Verb  meta 'scope'
                *                                -> Scope
                * noun                           -> Scope;
Verb  meta 'showverb'
                * special                        -> Showverb;
Verb  meta 'showobj'
                *                                -> Showobj
                * multi                          -> Showobj;
#endif;

! ----------------------------------------------------------------------------
!  And now the game verbs.
! ----------------------------------------------------------------------------

!  ***ENGLISH*** Verb  'take' 'carry' 'hold'
!  ***ENGLSH***                 * multi                          -> Take
!  ***ENGLSH***                 * 'off' worn                     -> Disrobe
!  ***ENGLSH***                 * multiinside 'from' noun        -> Remove
!  ***ENGLSH***                 * multiinside 'off' noun         -> Remove
!  ***ENGLSH***                 * 'inventory'                    -> Inv;
Verb  'lebna' 'bevri' 'jgari'
                * multi                          -> Take;

!  ***ENGLISH*** Verb  'get'      * 'out'/'off'/'up'               -> Exit
!  ***ENGLSH***                 * multi                          -> Take
!  ***ENGLSH***                 * 'in'/'into'/'on'/'onto' noun   -> Enter
!  ***ENGLSH***                 * 'off' noun                     -> GetOff
!  ***ENGLSH***                 * multiinside 'from' noun        -> Remove;
Verb  'cpacu'     
                * multi                          -> Take;

!  ***ENGLISH*** Verb  'pick'
!  ***ENGLSH***                 * 'up' multi                     -> Take
!  ***ENGLSH***                 * multi 'up'                     -> Take;
    ! No equivalent.

!  ***ENGLISH*** Verb  'stand'
!  ***ENGLSH***                 *                                -> Exit
!  ***ENGLSH***                 * 'up'                           -> Exit
!  ***ENGLSH***                 * 'on' noun                      -> Enter;
Verb  'sanli'
                *                                -> Exit
                * noun                           -> Enter;

!  ***ENGLISH*** Verb  'remove'
!  ***ENGLSH***                 * held                           -> Disrobe
!  ***ENGLSH***                 * multi                          -> Take
!  ***ENGLSH***                 * multiinside 'from' noun        -> Remove;
Verb  'vimcu'
                * held                           -> Drop
                * held 'mi'                      -> Drop
                * worn                           -> Disrobe
                * multiinside noun               -> Remove;

!  ***ENGLISH*** Verb  'shed' 'doff' 'disrobe'
!  ***ENGLSH***                 * held                           -> Disrobe; 
Verb  'toldasni'
                * worn                           -> Disrobe; 

!  ***ENGLISH*** Verb  'wear' 'don'
!  ***ENGLSH***                 * held                           -> Wear;
Verb  'dasni'
                * held                           -> Wear;

!  ***ENGLISH*** Verb  'put'
!  ***ENGLSH***                 * multiexcept 'in'/'inside'/'into' noun
!  ***ENGLSH***                 * multiexcept 'on'/'onto' noun   -> PutOn
!  ***ENGLSH***                 * 'on' held                      -> Wear
!  ***ENGLSH***                 * 'down' multiheld               -> Drop
!  ***ENGLSH***                 * multiheld 'down'               -> Drop;
Verb  'punji'
                * multiexcept 'le' 'nenri' 'be' noun
						 -> Insert
                * multiexcept 'le' 'cpana' 'be' noun
						 -> PutOn
                * multiexcept noun               -> PutOn;

!  ***ENGLISH*** Verb  'insert'
!  ***ENGLSH***                 * multiexcept 'in'/'into' noun   -> Insert;
Verb  'setca'
                * multiexcept noun               -> Insert;

!  ***ENGLISH*** Verb  'empty'
!  ***ENGLSH***                 * noun                           -> Empty
!  ***ENGLSH***                 * 'out' noun                     -> Empty
!  ***ENGLSH***                 * noun 'out'                     -> Empty
!  ***ENGLSH***                 * noun 'to'/'into'/'on'/'onto' noun
Verb  'kutygau'
                * noun                           -> Empty;

Verb  'kutybe^i'
                * noun noun       		 -> EmptyT;

!  ***ENGLISH*** Verb  'transfer'
!  ***ENGLSH***                 * noun 'to' noun                 -> Transfer;
Verb  'benji' 'muvgau'
                * noun noun                      -> Transfer;

!  ***ENGLISH*** Verb  'drop' 'throw' 'discard'
!  ***ENGLSH***                 * multiheld                      -> Drop
!  ***ENGLSH***                 * multiexcept 'in'/'into'/'down' noun
!  ***ENGLSH***                 * multiexcept 'on'/'onto' noun   -> PutOn
!  ***ENGLSH***                 * held 'at'/'against'/'on'/'onto' noun
Verb  'falcru' 'renro' 'falri^a'
                * multiheld                      -> Drop
                * held noun			 -> ThrowAt;

!  ***ENGLISH*** Verb  'give' 'pay' 'offer' 'feed'
!  ***ENGLSH***                  * held 'to' creature             -> Give
!  ***ENGLSH***                  * creature held                  -> Give reverse
!  ***ENGLSH***                  * 'over' held 'to' creature      -> Give;
Verb  'dunda' 'pleji' 'friti' 'ctigau'
                 * held creature                 -> Give
                 * held creature      		 -> Give;

!  ***ENGLISH*** Verb  'show' 'present' 'display'
!  ***ENGLSH***                 * creature held                  -> Show reverse
!  ***ENGLSH***                 * held 'to' creature             -> Show;
Verb  'jarco'
                * 'tu^a' held creature           -> Show
                * held creature                  -> Show;

[ ADirection; if (noun in compass) rtrue; rfalse; ];

!  ***ENGLISH*** Verb  'go' 'walk' 'run'
!  ***ENGLSH***                 *                                -> VagueGo
!  ***ENGLSH***                 * noun=ADirection                -> Go
!  ***ENGLSH***                 * noun                           -> Enter
!  ***ENGLSH***                 * 'into'/'in'/'inside'/'through' noun
Verb  'klama' 'cadzu' 'bajra'
                *                                -> VagueGo
                * noun=ADirection                -> Go
                * noun                           -> Enter;

!  ***ENGLISH*** Verb  'leave'
!  ***ENGLSH***                 *                                -> VagueGo
!  ***ENGLSH***                 * noun=ADirection                -> Go
!  ***ENGLSH***                 * noun                           -> Exit
!  ***ENGLSH***                 * 'into'/'in'/'inside'/'through' noun
Verb  'cliva'
                *                                -> VagueGo
                * 'fi' noun=ADirection           -> Go
                * noun                           -> Exit;

!  ***ENGLISH*** Verb  'inventory' 'inv' 'i//'
!  ***ENGLSH***                 *                                -> Inv
!  ***ENGLSH***                 * 'tall'                         -> InvTall
!  ***ENGLSH***                 * 'wide'                         -> InvWide;
Verb  'selbeiste' 'beiste'
                *                                -> Inv
                * 'to^unai'                      -> InvTall
                * 'tcila'                        -> InvTall
                * 'clani'                        -> InvTall;

!  ***ENGLISH*** Verb  'look' 'l//'
!  ***ENGLSH***                 *                                -> Look
!  ***ENGLSH***                 * 'at' noun                      -> Examine
!  ***ENGLSH***                 * 'inside'/'in'/'into'/'through' noun
!  ***ENGLSH***                 * 'under' noun                   -> LookUnder
!  ***ENGLSH***                 * 'up' topic 'in' noun           -> Consult;
Verb  'zgana' 'z//' 'viska'
                *                                -> Look
                * noun                           -> Examine
                * 'le' 'nenri' 'be' noun         -> Search
                * 'le' 'cnita' 'be' noun         -> LookUnder;

!  ***ENGLISH*** Verb  'consult'  * noun 'about' topic             -> Consult
!  ***ENGLSH***                 * noun 'on' topic                -> Consult;
Verb  'sisku' 'tidysisku'
		* topic 'tu^a' noun              -> Consult
		* topic 'sepi^o' noun            -> Consult
		* topic 'fi' noun                -> Consult
		* 'fi' noun 'fe' topic		-> Consult reverse
		* 'tu^a' topic 'fi' noun         -> Consult
		* 'fi' noun 'fe' 'tu^a' topic	-> Consult reverse
		* 'lu' topic 'li^u' noun	-> Consult
		* 'lo^u' topic 'le^u' noun	-> Consult
                * noun                           -> Search;

!  ***ENGLISH*** Verb  'open' 'unwrap' 'uncover' 'undo'
!  ***ENGLSH***                 * noun                           -> Open
!  ***ENGLSH***                 * noun 'with' held               -> Unlock;
Verb  'kargau'
                * noun                           -> Open
                * noun 'sepi^o' held             -> Unlock;

!  ***ENGLISH*** Verb  'close' 'shut' 'cover'
!  ***ENGLSH***                 * noun                           -> Close
!  ***ENGLSH***                 * 'up' noun                      -> Close
!  ***ENGLSH***                 * 'off' noun                     -> SwitchOff;
Verb  'ga^orgau' 'gairgau'
                * noun                           -> Close;

!  ***ENGLISH*** Verb  'enter' 'cross'
!  ***ENGLSH***                 *                                -> GoIn
!  ***ENGLSH***                 * noun                           -> Enter;
Verb  'nerkla'
                *                                -> GoIn
                * noun                           -> Enter;

!  ***ENGLISH*** Verb  'sit' 'lie'
!  ***ENGLSH***                 * 'on' 'top' 'of' noun           -> Enter
!  ***ENGLSH***                 * 'on'/'in'/'inside' noun        -> Enter;
Verb  'zutse' 'vreta'
                * noun                           -> Enter;

!  ***ENGLISH*** Verb  'in' 'inside'
!  ***ENGLSH***                 *                                -> GoIn;
Verb  'nergau' 'nenri'
                *                                -> GoIn
                * 'fi' noun                      -> Enter
                * noun                           -> Enter;

!  ***ENGLISH*** Verb  'exit' 'out' 'outside'
!  ***ENGLSH***                 *                                -> Exit;
Verb  'bargau' 'bartu'
                *                                -> Exit;

!  ***ENGLISH*** Verb  'examine' 'x//' 'watch' 'describe' 'check'
!  ***ENGLSH***                 * noun                           -> Examine;
Verb  'catlu' 'c//'
                * noun                           -> Examine;

!  ***ENGLISH*** Verb  'read'
!  ***ENGLSH***                 * noun                           -> Examine
!  ***ENGLSH***                 * 'about' topic 'in' noun        -> Consult
!  ***ENGLSH***                 * topic 'in' noun                -> Consult;
Verb  'tcidu'
                * noun                           -> Examine
                * 'fi' noun                      -> Examine
		* 'lu' topic 'li^u' noun	-> Consult
		* 'lo^u' topic 'le^u' noun	-> Consult
                * 'tu^a' topic 'fi' noun         -> Consult
		* 'fi' noun 'fe' 'tu^a' topic	-> Consult reverse
                * topic 'fi' noun                -> Consult;

!  ***ENGLISH*** Verb  'yes' 'y//'
!  ***ENGLSH***                 *                                -> Yes;
Verb  '_ie'
                *                                -> Yes;

!  ***ENGLISH*** Verb  'no'
!  ***ENGLSH***                 *                                -> No;
Verb  '_ienai'
                *                                -> No;

!  ***ENGLISH*** Verb  'sorry'
!  ***ENGLSH***                 *                                -> Sorry;
Verb  '_u^u' 'xenru'
                *                                -> Sorry;

!  ***ENGLISH*** Verb  'shit' 'fuck' 'damn' 'sod'
!  ***ENGLSH***                 *                                -> Strong
!  ***ENGLSH***                 * topic                          -> Strong;
Verb  'mabla'
                *                                -> Strong
                * topic                          -> Strong;

!  ***ENGLISH*** Verb  'bother' 'curses' 'drat' 'darn'
!  ***ENGLSH***                 *                                -> Mild
!  ***ENGLSH***                 * topic                          -> Mild;
Verb  'mlimabla'
                *                                -> Mild
                * topic                          -> Mild;

!  ***ENGLISH*** Verb  'search'
!  ***ENGLSH***                 * noun                           -> Search;
!    See 'sisku' above. 

!  ***ENGLISH*** Verb  'wave'
!  ***ENGLSH***                 *                                -> WaveHands
!  ***ENGLSH***                 * noun                           -> Wave;
Verb  'sligau'
                *                                -> WaveHands
                * noun                           -> Wave
                * 'sepi^o' noun                  -> Swing;

!  ***ENGLISH*** Verb  'set' 'adjust'
!  ***ENGLSH***                 * noun                           -> Set
!  ***ENGLSH***                 * noun 'to' special              -> SetTo;
Verb  'tikygau'
                * noun                           -> Set
                * noun special                   -> SetTo;

!  ***ENGLISH*** Verb  'pull' 'drag'
!  ***ENGLSH***                 * noun                           -> Pull;
Verb  'lacpu'
                * noun                           -> Pull;

!  ***ENGLISH*** Verb  'push' 'move' 'shift' 'clear' 'press'
!  ***ENGLSH***                 * noun                           -> Push
!  ***ENGLSH***                 * noun noun                      -> PushDir
!  ***ENGLSH***                 * noun 'to' noun                 -> Transfer;
Verb  'catke' 'muvdu'
                * noun                           -> Push
                * noun 'fa^a' noun               -> PushDir
                * noun noun                      -> PushDir;

!  ***ENGLISH*** Verb  'turn' 'rotate' 'twist' 'unscrew' 'screw'
!  ***ENGLSH***                 * noun                           -> Turn
!  ***ENGLSH***                 * noun 'on'                      -> Switchon
!  ***ENGLSH***                 * noun 'off'                     -> Switchoff
!  ***ENGLSH***                 * 'on' noun                      -> Switchon
!  ***ENGLSH***                 * 'off' noun                     -> Switchoff;
Verb  'cargau'
                * noun                           -> Turn;

!  ***ENGLISH*** Verb  'switch'
!  ***ENGLSH***                 * noun                           -> Switchon
!  ***ENGLSH***                 * noun 'on'                      -> Switchon
!  ***ENGLSH***                 * noun 'off'                     -> Switchoff
!  ***ENGLSH***                 * 'on' noun                      -> Switchon
!  ***ENGLSH***                 * 'off' noun                     -> Switchoff;
Verb  'kragau' 'tolcadgau' 'tolcando'
                * noun                           -> Switchon;

Verb  'famgau' 'cadgau' 'cando'
                * noun                           -> Switchoff;

!  ***ENGLISH*** Verb  'lock'
!  ***ENGLSH***                 * noun 'with' held               -> Lock;
Verb  'kikla^a'
                * noun 'sepi^o' held             -> Lock
                * noun 'fo' held                 -> Lock;

!  ***ENGLISH*** Verb  'unlock'
!  ***ENGLSH***                 * noun 'with' held               -> Unlock;
Verb  'kikykalri'
                * noun 'sepi^o' held             -> UnLock
                * noun 'fo' held                 -> UnLock;

!  ***ENGLISH*** Verb  'attack' 'break' 'smash' 'hit' 'fight' 'wreck' 'crack'
!  ***ENGLISH***   'destroy' 'murder' 'kill' 'torture' 'punch' 'thump'
!  ***ENGLSH***                 * noun                           -> Attack;
Verb 'gunta' 'porpi' 'darxi' 'damba' 'fergau' 'daspo' 'catra'
                * noun                           -> Attack;

!  ***ENGLISH*** Verb  'wait' 'z//'
!  ***ENGLSH***                 *                                -> Wait;
Verb  'denpa'
                *                                -> Wait;


!  ***ENGLISH*** Verb  'answer' 'say' 'shout' 'speak'
!  ***ENGLSH***                 * topic 'to' creature            -> Answer;
Verb  'dafsku'
                * 'lu' topic 'li^u' creature   	-> Answer
		* 'lo^u' topic 'le^u' creature 	-> Answer;

Verb  'spuda'
                * 'tu^a' creature topic          -> Answer reverse
                * creature topic                 -> Answer reverse
                * 'tu^a' creature 'lu' topic 'li^u'	         -> Answer reverse
                * 'tu^a' creature 'lo^u' topic 'le^u'	         -> Answer reverse
                * creature 'lu' topic 'li^u'	                 -> Answer reverse
                * creature 'lo^u' topic 'le^u'	                 -> Answer reverse;

Verb 'cusku'
		* 'lu' topic 'li^u' creature 	-> Answer
		* 'lo^u' topic 'le^u' creature 	-> Answer;

!  ***ENGLISH*** Verb  'tell'
!  ***ENGLSH***                 * creature 'about' topic         -> Tell;
!***MDB*** annoyingly, can't just have 'tu^a' topic creature - need a
! predictable word marking the end of the topic. But vaguely natural, and
! allowed, is...
Verb  'skicu' 
		* 'le' 'nu'/'ka'/'du^u'/'su^u' topic 'kei' creature -> Tell reverse
		* 'tu^a' topic 'fi' creature -> Tell reverse 
		* 'fi' creature 'fe' 'tu^a' topic -> Tell; 

!  ***ENGLISH*** Verb  'ask'
!  ***ENGLSH***                 * creature 'about' topic         -> Ask
!  ***ENGLSH***                 * creature 'for' noun            -> AskFor;
Verb  'cpedu'
		* 'le' 'nu'/'ka'/'du^u'/'su^u' topic 'kei' creature -> Ask reverse
		* 'tu^a' topic 'fi' creature -> Ask reverse
		* 'fi' creature 'fe' 'tu^a' topic -> Ask 
                * noun creature                  -> AskFor reverse;

!***MDB*** Basically, any quoted text should go to Answer
Verb 'teryrei' 
                * topic 'fo' creature            -> Ask reverse
                * noun 'fo' creature             -> AskFor reverse
		* 'fe'/'zo^e' 'lu' topic 'li^u' creature -> Answer
		* 'fe'/'zo^e' 'lo^u' topic 'le^u' creature -> Answer;
	
!  ***ENGLISH*** Verb  'eat'
!  ***ENGLSH***                 * held                           -> Eat;
Verb  'citka'
                * held                           -> Eat;

!  ***ENGLISH*** Verb  'sleep' 'nap'
!  ***ENGLSH***                 *                                -> Sleep;
Verb  'sipna'
                *                                -> Sleep;

!  ***ENGLISH*** Verb  'peel'
!  ***ENGLSH***                 * noun                           -> Take
!  ***ENGLSH***                 * 'off' noun                     -> Take;
    ! Silly; in for completeness.
Verb  'pilvi^u'
                * noun                           -> Take;

!  ***ENGLISH*** Verb  'sing'
!  ***ENGLSH***                 *                                -> Sing;
Verb  'sanga'
                *                                -> Sing;

!  ***ENGLISH*** Verb  'climb' 'scale'
!  ***ENGLSH***                 * noun                           -> Climb
!  ***ENGLSH***                 * 'up'/'over' noun               -> Climb;
Verb  'cpare'
                * noun                           -> Climb
                * noun                           -> Climb;

!  ***ENGLISH*** Verb  'buy' 'purchase'
!  ***ENGLSH***                 * noun                           -> Buy;
Verb  'terve^u' 'terdi^a'
                * noun                           -> Buy;

!  ***ENGLISH*** Verb  'squeeze' 'squash'
!  ***ENGLSH***                 * noun                           -> Squeeze;
Verb  'jarjai'
                * noun                           -> Squeeze;

!  ***ENGLISH*** Verb  'swim' 'dive'
!  ***ENGLSH***                 *                                -> Swim;
Verb  'limna'
                *                                -> Swim;

!  ***ENGLISH*** Verb  'swing'
!  ***ENGLSH***                 * noun                           -> Swing
!  ***ENGLSH***                 * 'on' noun                      -> Swing;
     ! See sligau above.

!  ***ENGLISH*** Verb  'blow'
!  ***ENGLSH***                 * held                           -> Blow;
Verb  'gacyse^a'
                * held                           -> Blow;

!  ***ENGLISH*** Verb  'pray'
!  ***ENGLSH***                 *                                -> Pray;
Verb  'jdasku'
                *                                -> Pray;

!  ***ENGLISH*** Verb  'wake' 'awake' 'awaken'
!  ***ENGLSH***                 *                                -> Wake
!  ***ENGLSH***                 * 'up'                           -> Wake
!  ***ENGLSH***                 * creature                       -> WakeOther
!  ***ENGLSH***                 * creature 'up'                  -> WakeOther
!  ***ENGLSH***                 * 'up' creature                  -> WakeOther;
Verb  'cikna' 'cikygau'
                *                                -> Wake
                * creature                       -> WakeOther;

!  ***ENGLISH*** Verb  'kiss' 'embrace' 'hug'
!  ***ENGLSH***                 * creature                       -> Kiss;
Verb  'cinba' 'pamjai'
                * creature                       -> Kiss;

!  ***ENGLISH*** Verb  'think'
!  ***ENGLSH***                 *                                -> Think;
Verb  'pensi'
                *                                -> Think;

!  ***ENGLISH*** Verb  'smell' 'sniff'
!  ***ENGLSH***                 *                                -> Smell
!  ***ENGLSH***                 * noun                           -> Smell;
Verb  'sumne'
                *                                -> Smell
                * noun                           -> Smell;

!  ***ENGLISH*** Verb  'hear' 'listen'
!  ***ENGLSH***                 *                                -> Listen
!  ***ENGLSH***                 * noun                           -> Listen
!  ***ENGLSH***                 * 'to' noun                      -> Listen;
Verb  'tirna'
                *                                -> Listen
                * noun                           -> Listen;

!  ***ENGLISH*** Verb  'taste'
!  ***ENGLSH***                 * noun                           -> Taste;
Verb  'vusygau'
                * noun                           -> Taste;

!  ***ENGLISH*** Verb  'touch' 'fondle' 'feel' 'grope'
!  ***ENGLSH***                 * noun                           -> Touch;
Verb  'pencu'
                * noun                           -> Touch;

!  ***ENGLISH*** Verb  'rub' 'shine' 'polish' 'sweep' 'clean' 'dust' 'wipe' 'scrub'
!  ***ENGLSH***                 * noun                           -> Rub;
Verb  'jisysa^e'
                * noun                           -> Rub;

!  ***ENGLISH*** Verb  'tie' 'attach' 'fasten' 'fix'
!  ***ENGLSH***                 * noun                           -> Tie
!  ***ENGLSH***                 * noun 'to' noun                 -> Tie;
Verb  'lasna'
                * noun                           -> Tie
                * noun noun                      -> Tie;

!  ***ENGLISH*** Verb  'burn' 'light'
!  ***ENGLSH***                 * noun                           -> Burn
!  ***ENGLSH***                 * noun 'with' held               -> Burn;
Verb  'jelgau' 'gusygau'
                * noun                           -> Burn
                * noun 'sepi^o' held             -> Burn;

!  ***ENGLISH*** Verb  'drink' 'swallow' 'sip'
!  ***ENGLSH***                 * noun                           -> Drink;
Verb  'pinxe'
                * noun                           -> Drink;

!  ***ENGLISH*** Verb  'fill'
!  ***ENGLSH***                 * noun                           -> Fill;
Verb  'tisygau'
                * noun                           -> Fill;

!  ***ENGLISH*** Verb  'cut' 'slice' 'prune' 'chop'
!  ***ENGLSH***                 * noun                           -> Cut;
Verb  'katna'
                * noun                           -> Cut;

!  ***ENGLISH*** Verb  'jump' 'skip' 'hop'
!  ***ENGLSH***                 *                                -> Jump
!  ***ENGLSH***                 * 'over' noun                    -> JumpOver;
Verb  'plipe'
                *                                -> Jump
                * 'le gapru be ' noun            -> JumpOver;

!  ***ENGLISH*** Verb  'dig'    * noun                           -> Dig
!  ***ENGLSH***                 * noun 'with' held               -> Dig;
Verb  'kakpa'     
                * noun                           -> Dig
                * noun 'fo' held                 -> Dig;
! ----------------------------------------------------------------------------
!  This routine is no longer used here, but provided to help existing games
!  which use it as a general parsing routine:

[ ConTopic w; consult_from = wn;
  do w=NextWordStopped();
  until (w==-1 || (w=='to' && action_to_be==##Answer));
  wn--;
  consult_words = wn-consult_from;
  if (consult_words==0) return -1;
  if (action_to_be==##Ask or ##Answer or ##Tell)
  {   w=wn; wn=consult_from; parsed_number=NextWord();
      if (parsed_number=='the' && consult_words>1) parsed_number=NextWord();
      wn=w; return 1;
  }
  return 0;
];
! ----------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ----------------------------------------------------------------------------
#Stub TimePasses      0;
#Stub Amusing         0;
#Stub DeathMessage    0;
#Stub DarkToDark      0;
#Stub NewRoom         0;
#Stub LookRoutine     0;
#Stub AfterLife       0;
#Stub GamePreRoutine  0;
#Stub GamePostRoutine 0;
#Stub AfterPrompt     0;
#Stub BeforeParsing   0;
#Stub PrintTaskName   1;
#Stub InScope         1;
#Stub UnknownVerb     1;
#Stub PrintVerb       1;
#Stub ParserError     1;
#Stub ParseNumber     2;
#Stub ChooseObjects   2;
#IFNDEF PrintRank;
Constant Make__PR;
#ENDIF;
#IFDEF Make__PR;
[ PrintRank; "."; ];
#ENDIF;
#IFNDEF ParseNoun;
Constant Make__PN;
#ENDIF;
#IFDEF Make__PN;
[ ParseNoun obj; obj=obj; return -1; ];
#ENDIF;
#Default Story 0;
#Default Headline 0;
#IFDEF INFIX;
#Include "infix";
#ENDIF;
! ----------------------------------------------------------------------------
