
!	INSTALLATION:
!
!	Include "Helpfile" in your gamefile.
!
!
!	CONTENTS:
!
!	-- Three basic formatting routines for doing bold and italic text
!	and for awaiting a keypress.  (The only reason to define these
!		is to provide z-code/Glulx flexibility.)
!
!	-- CaveIntro.
!---------------------------------------------------------------------------

system_file;

#ifdef TARGET_GLULX;
[ ESB str;	! print something in bold
	if (str==0) rfalse;
	glk_set_style(style_Input);
	print (string) str;
	glk_set_style(style_Normal);
	rtrue;
];
#ifnot;
[ ESB str;	! print something in bold
	if (str==0) rfalse;
	style bold;
	print (string) str;
	style roman;
	rtrue;
];
#endif;

[ CaveIntro;
print (ESB) "Cave (a short demo using sounds and pictures in Glulx)";
print "
^^The Inform Glulx example here illustrates a way I've found to get
pictures and sounds into games -  hopefully, it might help anyone
wanting to experiment for themselves. Two good places to start are
Adam Cadre's Gull guide (http://adamcadre.ac/gull/index.html),
and the Glulx section at Roger Firth's site
(http://www.firthworks.com/roger/).
It's a good idea to read both of these first.

^^I've put comments in the accompanying source code to help
explain what's going on. Please feel free to borrow any ideas.
All the trickier stuff is taken straight from the examples in the
Gull documentation, where it's explained fully.";

print"^^The pictures and sounds used here have been borrowed from the
children's game Dragon Adventure (also in the IF Archive).
The game was originally written in BASIC for RISC OS computers, and I
wanted to use the same pictures and sound files in the Glulx version.
The various picture sizes were chosen to fit the 640 x 480 VGA screen 
of the original version. At higher screen resolutions the pictures 
appear smaller, and remain with a fixed offset from the left side of 
the main window. I haven't found a way round this with Glulx.

^^PD sound effects can be found on the internet - http://www.findsounds.com
is a search site specifically for sound effect samples.
This gives links to thousands of AU, AIFF and (mostly) WAV samples 
(I found 106 elephant sounds, for instance), though you need to check the 
copyright status before using anything. 

^^You'll probably also need an editor for trimming and changing the 
volume of sound samples. One good one is Audacity, a freeware 
open source editor for Windows, Linux and the Mac (from 
http://audacity.sourceforge.net). This can convert samples between a 
range of formats (including to AIFF) with different sample rate and 
quality settings. 
Other utilies (such as the PC shareware Easy CD-DA Extractor from 
http://www.poikosoft.com) may also be of help for file conversion to AIFF. 
8-bit mono at 11 or 16KHz seems to be about the best compromise 
between file length and quality for basic game sound effects. 

^^For pictures, the freeware open source GIMP graphics editor (from 
http://www.gimp.org) is capable and comprehensive, with facilities to 
rival Photoshop. It's available for Windows, Linux and the Mac, and, 
once you get the hang of it, is useful for both image creation and 
manipulation.
";
print"^^Like its parent game, this demo has a built-in picture map
on screen which shows the places visited (type 'map').
Sound effects can be turned off or on by 'sound off/on'.
It's also possible to see briefly inside the dark cave by striking a match,
and 'listen' will replay the sound heard by the lake.
The demo has no set game ending (in case anyone tries to find one!).";

print "^^William Stott, June 2004";

#ifdef TARGET_GLULX;
	glk_set_style(style_Normal);
#ifnot;
	font on;
#endif;
print "^^(Type LOOK or L to see where you are in the game)^";
];
