"The Children of Loblolly Lodge" by wingjive

Use serial comma. 
Use American dialect.

Include Rideable Vehicles by Graham Nelson. 

Include Basic Screen Effects by Emily Short.



Understand "who" or "what" or "when" or "where" or "why" or "how" or "who's" or "what's" or "when's" or "where's" or "why's" or "how's" as "[query]".

Understand "[query] [text]" as a mistake ("[story title] understands commands, such as '[command prompt]examine [a random thing that can be seen by the player]', but not questions. For more instructions, type HELP.").



Part 1 - General Rules

Novice mode is a truth state that varies. Novice mode is true.

When play begins:
	say "[banner text][paragraph break][italic type] True, I talk of dreams, which are the children of an idle brain, born from frivolous imaginations.  [roman type][line break]          - Mercutio (Romeo & Juliet by William Shakespeare)[paragraph break][paragraph break]Have you played interactive fiction before?  <Note: a 'No' response will initiate Novice Mode - This mode is not recommended, but available>[paragraph break]> ";
	if player consents, now Novice mode is false;
	otherwise now novice mode is true;
	clear the screen.
	
[The rationale for asking the question this way, and not another, is that novices asked whether they would like instructions very often say no, even if they need them.]

Stopping novice mode is an action out of world.
Starting novice mode is an action out of world.

Understand "novice mode off" or "novice off" as stopping novice mode.
Understand "novice mode on" or "novice on" as starting novice mode.

Carry out stopping novice mode: now novice mode is false.
Carry out starting novice mode: now novice mode is true.

Report stopping novice mode: say "Novice mode is now off."
Report starting novice mode: say "Novice mode is now on."

Before reading a command when novice mode is true:
	say "[line break]Some options to try:[line break]";
	follow the novice suggestion rules.

The novice suggestion rules is a rulebook.

A novice suggestion rule (this is the suggestion that he look rule):
	if not looking and not going, say "  [bold type]look[roman type]".

A novice suggestion rule (this is the suggestion that he check inventory rule):
	if the player carries something and we are not taking inventory, say "  [bold type]inventory[roman type] (I)".

A novice suggestion rule (this is the suggestion that he put things on rule):
	if the player carries something and a free-standing supporter is relevant, say "  [bold type]put[roman type] something [bold type]on[roman type] [the list of relevant supporters]".

A novice suggestion rule (this is the suggestion that he take things rule):
	if a gettable thing is relevant, say "  [bold type]take[roman type] [the list of gettable relevant things]".

A novice suggestion rule (this is the suggestion that he examine things rule):
	if an unexamined thing is relevant, say "  [bold type]examine[roman type] (X) [the list of unexamined relevant things]".

A novice suggestion rule (this is the suggestion that he enter things rule):
	if a relevant thing is worth entering, say "  [bold type]enter[roman type] [the list of worth entering relevant things], or [bold type]get out[roman type]".

A novice suggestion rule (this is the suggestion that he lock things rule):
	if a closed lockable thing is relevant, say "  [bold type]lock[roman type] or [bold type]unlock[roman type] [the list of closed lockable relevant things]".

A novice suggestion rule (this is the suggestion that he eat things rule):
	if the player carries an edible relevant thing, say "  [bold type]eat[roman type] [the list of edible relevant things carried by the player]".

A novice suggestion rule (this is the suggestion that he wear things rule):
	if the player carries a wearable relevant thing, say "  [bold type]wear[roman type] [the list of wearable relevant things carried by the player]".

A novice suggestion rule (this is the suggestion that he turn things on rule):
	if a device is relevant, say "  [bold type]turn on[roman type] or [bold type]turn off[roman type] [the list of relevant devices]".

A novice suggestion rule (this is the suggestion that he go places rule):
	if a room is adjacent, say "  [bold type]go[roman type][exit list][if in darkness] or try other directions in the dark[otherwise]".

A novice suggestion rule (this is the suggestion that he enter doors rule):
	if an open door is relevant, say "  [bold type]go through[roman type] [the list of relevant open doors]".

A novice suggestion rule (this is the suggestion that he interact with people rule):
	if another person is relevant, say "  [bold type]kiss[roman type] or [bold type]wake[roman type] [the list of relevant other people][if the player carries something], or [bold type]give[roman type] things [bold type]to[roman type] someone[end if]".

A novice suggestion rule (this is the suggestion that he ask for help rule):
	say "  [bold type]help[roman type] to see a more complete set of instructions".

A novice suggestion rule (this is the suggestion that he turn off help rule):
	say "  [bold type]novice mode off[roman type] to turn off this guidance".

Last novice suggestion rule:
	say "[line break]".

[The suggestion about asking for help is no good unless we provide some. This might take any of a number of forms, but for the sake of example we'll use an easy way out:]

Include Menus by Emily Short. Include Basic Help Menu by Emily Short.

After taking inventory when novice mode is true: say "To get rid of any of these objects, [bold type]drop[roman type] it."

A thing can be examined or unexamined. Carry out examining something: now the noun is examined.

A thing can be seen or unseen. A thing is usually unseen.

Definition: a thing is relevant if it is seen and it is visible. Before printing the name of something (called the target): now the target is seen; if novice mode is true, say "[bold type]". After printing the name of something: say "[roman type]".

Definition: a supporter is worth entering:
	if the player carries it, no;
	if it is enterable, yes.

Definition: a container is worth entering:
	if the player carries it, no;
	if it is enterable and it is open, yes.

Definition: a person is other if it is not the player. Definition: a person is another if it is other.

Definition: a thing is free-standing if it is in a room.

To say exit list:
	let place be location;
	let count be 0;
	repeat with way running through directions:
		let place be the room way from the location;
		if place is a room:
			increment count;
			say "[if count is greater than 1] or[end if] [bold type][way][roman type]".

Definition: a thing is gettable:
	if it is scenery, no;
	if it is fixed in place, no;
	if it is a person, no;
	if the player is carrying it, no;
	if the player is wearing it, no;
	yes.

Carry out examining a thing: 
	now the noun is seen. 


Lying down is an action applying to nothing. Report lying down: say "You lie down for a while, wondering about the point of existence, then get up again." 

Lying near is an action applying to one thing. Report lying near: say "You lie down next to [the noun] for a while, mumbling to yourself." 

Understand "beneath/under/by/near/beside/alongside/against" or "next to" or "in front of" as "[beside]". 

Understand "on/in/inside" or "on top of" as "[within]". 

Understand "lie down" as lying down. 

Understand "lie down [within] [something]" as entering. 

Understand "lie [beside] [something]" or "lie down [beside] [something]" as lying near. 

Understand "get down" as exiting.


A thing can be examined or unexamined. 

After taking something unexamined: 
	say "Taken. [run paragraph on]"; 
	try examining the noun. 

Carry out examining something: 
	now the noun is examined. 
	
The taking action has an object called previous locale (matched as "from").

[The previous locale could in theory be either a thing or a room, so we make it "an object" -- that is, the most generic possible kind, to which both things and rooms belong. Now we record what the previous locale is at the beginning of each taking action:]

Setting action variables for taking:
	now previous locale is the holder of the noun.


Examining something is acting fast. Looking is acting fast. 

The take visual actions out of world rule is listed before the every turn stage rule in the turn sequence rules. 

This is the take visual actions out of world rule: if acting fast, rule succeeds. 



Report taking something:
	say "You take [the noun] from [the previous locale]." instead.

Before dropping something: 
	if the player does not carry the noun and the player encloses the noun: 
		say "(first taking [the noun] from [the holder of the noun])[command clarification break]"; 
		silently try taking the noun; 
		if the player does not carry the noun, stop the action. 

Before inserting something which is not carried by the player into something: 
	if the noun is in the second noun, say "Already done." instead; 
	say "(first taking [the noun])[line break]"; 
	silently try taking the noun; 
	if the player is not holding the noun, stop the action. 

Before putting something which is not carried by the player on something: 
	if the noun is on the second noun, say "Already done." instead; 
	say "(first taking [the noun])[line break]"; 
	silently try taking the noun; 
	if the player is not holding the noun, stop the action. 
	
Understand "put [things] in [something]" as inserting it into. Understand "put [things] on [something]" as putting it on. 


[First we add an instruction to determine which ways lead to other rooms.]

Definition: a direction (called thataway) is viable if the room thataway from the location is a room.

[Now we build in the instruction for what Inform should say if the player tries to head in a direction that leads nowhere:]

Instead of going nowhere:
	let count of exits be the number of viable directions;
	if the count of exits is 0, say "You appear to be trapped in here." instead;
	if the count of exits is 1, say "From here, the only way out is [list of viable directions].";
	otherwise say "From here, the viable exits are [list of viable directions]."

[There is no theoretical reason why we have to define "count of exits" here: we could, if we wanted, just say "if the number of viable directions is 0", "if the number of viable directions is 1", and so on. However, each calculation of a "viable direction" takes a bit of computing power, so there is some slight savings in not requiring the game to count viable directions more than once in this routine.]


A volume is a kind of value. 15.9 fl oz specifies a volume with parts ounces and tenths (optional, preamble optional). 

A fluid container is a kind of container. A fluid container has a volume called a fluid capacity. A fluid container has a volume called current volume. 

The fluid capacity of a fluid container is usually 16.0 fl oz. The current volume of a fluid container is usually 0.0 fl oz. 

Liquid is a kind of value. The liquids are water, beer, ale, coffee, and tea. A fluid container has a liquid. 

Fluid containers can be empty or full. A fluid container has a volume called full if the current volume equals the fluid capacity.

Instead of examining a fluid container: 
	if the noun is empty, 
		say "You catch just a hint of [the liquid of the noun] at the bottom."; 
	if the noun is full,
		say "[The noun] contains a lot of [liquid of the noun] and there appears to float[if the number of things in the lake is 1][end if] [a list of things in the lake].";
	otherwise 
		say "[The noun] contains [current volume of the noun in rough terms] of [liquid of the noun]." 

To say (amount - a volume) in rough terms: 
	if the amount is less than 0.5 fl oz: 
		say "a swallow or two"; 
	otherwise if tenths part of amount is greater than 3 and tenths part of amount is less than 7: 
		let estimate be ounces part of amount; 
		say "[estimate in words] or [estimate plus 1 in words] fluid ounces"; 
	otherwise: 
		if tenths part of amount is greater than 6, increase amount by 1.0 fl oz; 
		say "about [ounces part of amount in words] fluid ounce[s]". 

Before printing the name of a fluid container (called the target) while not drinking or pouring: 
	if the target is empty: 
		say "empty "; 
	otherwise: 
		do nothing. 

After printing the name of a fluid container (called the target) while not examining or pouring: 
	unless the target is empty: 
		say " of [liquid of the target]"; 
		omit contents in listing. 

Definition: a fluid container is empty if the current volume of it is 0.0 fl oz. Definition: a fluid container is full if the current volume of it is the fluid capacity of it. 

Understand "drink from [fluid container]" as drinking. 

Instead of drinking a fluid container: 
	if the noun is empty: 
		say "There is no more [liquid of the noun] within." instead; 
	otherwise: 
		decrease the current volume of the noun by 0.2 fl oz; 
		if the current volume of the noun is less than 0.0 fl oz, now the current volume of the noun is 0.0 fl oz; 
		say "You take a sip of [the liquid of the noun][if the noun is empty], leaving [the noun] empty[end if]." 

Part 2 - Filling 

Understand the command "fill" as something new. 

Understand "fill [fluid container] with/from [full liquid source]" as filling it with. Understand "fill [fluid container] with/from [fluid container]" as filling it with. 

Understand "fill [something] with/from [something]" as filling it with.

Filling it with is an action applying to two things. Carry out filling it with: try pouring the second noun into the noun instead. 

Understand "pour [fluid container] in/into/on/onto [fluid container]" as pouring it into. Understand "empty [fluid container] into [fluid container]" as pouring it into. 

Understand "pour [something] in/into/on/onto [something]" as pouring it into. Understand "empty [something] into [something]" as pouring it into. 

Pouring it into is an action applying to two things. 

Check pouring it into: 
	if the noun is not a fluid container, say "You can't pour [the noun]." instead; 
	if the second noun is not a fluid container, say "You can't pour liquids into [the second noun]." instead; 
	if the noun is the second noun, say "You can hardly pour [the noun] into itself." instead; 
	if the liquid of the noun is not the liquid of the second noun: 
		if the second noun is empty, now the liquid of the second noun is the liquid of the noun; 
		otherwise say "Mixing [the liquid of the noun] with [the liquid of the second noun] would give unsavory results." instead; 
	if the noun is empty, say "No more [liquid of the noun] remains in [the noun]." instead; 
	if the second noun is full, say "[The second noun] cannot contain any more than it already holds." instead. 

Carry out pouring it into: 
	let available capacity be the fluid capacity of the second noun minus the current volume of the second noun; 
	if the available capacity is greater than the current volume of the noun, now the available capacity is the current volume of the noun; 
	increase the current volume of the second noun by available capacity; 
	decrease the current volume of the noun by available capacity. 

Report pouring it into: 
	say "[if the noun is empty][The noun] is now empty;[otherwise][The noun] now contains [current volume of the noun in rough terms] of [liquid of the noun]; [end if]"; 
	say "[the second noun] contains [current volume of the second noun in rough terms] of [liquid of the second noun][if the second noun is full], and is now full[end if]." 

Understand the liquid property as describing a fluid container. Understand "of" as a fluid container. 

A liquid source is a kind of fluid container. A liquid source has a liquid. A liquid source is usually scenery. The fluid capacity of a liquid source is usually 3276.7 fl oz. The current volume of a liquid source is usually 3276.7 fl oz. 

Carry out pouring a liquid source into something: now the current volume of the noun is 3276.7 fl oz. 

After pouring a liquid source into a fluid container: 
	say "You fill [the second noun] up with [liquid of the noun] from [the noun]." 

Instead of pouring a fluid container into a liquid source: 
	if the noun is empty, say "[The noun] is already empty." instead; 
	now the current volume of the noun is 0.0 fl oz; 
	say "You dump out [the noun] into [the second noun]." 


"The Art of Noise"

A thing has some text called sound. The sound of a thing is usually "silence".

The report listening rule is not listed in the report listening to rules.

Carry out listening to something:
	say "From [the noun] you hear [the sound of the noun]."

Instead of listening to a room:
	if an audible thing can be touched by the player, say "You hear [the list of audible things which can be touched by the player].";
	otherwise say "Nothing of note."

Definition: a thing is audible if the sound of it is not "silence".

Before printing the name of something audible while listening to a room:
	say "[sound] from the "



A thing can be edible or inedible. A thing is usually inedible.

Instead of eating something inedible, say "[The noun] [don't] seem likely to agree with [us] at all. [We][']d be wiser to leave [regarding the noun][them] alone."

Instead of smelling something: say "[Our] nose [regarding nothing][are] too weak to get much smell from [regarding the noun][those]."

Instead of tasting something:
	say "Whew, [regarding the noun][are] [those] ever nasty!"

		

Section 1 - Overlying and Underlying

[We start by borrowing some of the same ideas from the Bogart example, but we're also going to make a kind called "garment-element". This kind will include both garments (objects of clothing) and body parts (things that can be covered by clothing); using it allows us to restrict the way our underlying and overlying relations apply, which will make them a bit faster at run-time.]

A garment-element is a kind of thing.

Underlying relates various garment-elements to various garment-elements with fast route-finding. The verb to underlie means the underlying relation. The verb to be under implies the underlying relation.

Check taking off:
	if the noun underlies something (called the impediment) which is worn by the player, say "[The impediment] [are] in the way." instead.

Carry out taking off:
	now the noun is not underlaid by anything.

Report taking off something:
	say "[We] [are] now wearing [a list of uppermost things worn by the player]." instead.

Definition: a garment-element is uppermost if it is not under something opaque.

[Here we've expanded on the previous ideas of 'uppermost' because it is possible for an upper layer to reveal what lies beneath: a tie, a clear plastic trenchcoat, an open-knit sweater, etc. We'll make such items transparent.]

Before taking off something which underlies something which is worn by the player:
	while the noun underlies something (called the impediment) which is worn by the player:
		say "(first removing [the impediment])[command clarification break]";
		silently try taking off the impediment;
		if the noun underlies the impediment, stop the action.

Overlying relates various garment-elements to various garment-elements. The verb to overlie means the overlying relation.

Covering relates a garment-element (called A) to a garment-element (called B) when the number of steps via the overlying relation from A to B is greater than 0. The verb to cover means the covering relation.

Before wearing something when a garment which covers the noun is worn by the player:
	while the player wears a garment (called the impediment) which covers the noun:
		say "(first removing [the impediment])[command clarification break]";
		silently try taking off the impediment;
		if the player is wearing the impediment, stop the action.

Carry out wearing:
	repeat with hidden item running through things worn by the player:
		if the noun covers the hidden item, now the hidden item underlies the noun.

Instead of looking under something which is worn by the player:
	if something (called the underwear) underlies the noun, say "[We] [peek] at [the underwear]. Yup, still there.";
	otherwise say "Just [us] in there."

Instead of taking inventory:
	say "[if the player carries something][We]['re] carrying [a list of things carried by the player][else][We]['re] empty-handed[end if][if the player wears something]. [We] [are] wearing [a list of uppermost garments worn by the player][end if].[if the player wears the worn backpack]In your backpack you are carrying [a list of things in the worn backpack][end if]."

To peek is a verb.



The former location is a room that varies. 

First carry out going rule: 
	now the former location is the location. 

Understand "go back" as retreating. Understand "back" or "return" or "retreat" as retreating. 

Retreating is an action applying to nothing. 

Carry out retreating: 
	let way be the best route from the location to the former location, using doors; 
	if way is a direction, try going way; 
	otherwise say "You can't see an open way back." 

When play begins: now the former location is the Dark Chamber. 

Instead of retreating when the former location is the location: say "You haven't gone anywhere yet." 

Instead of retreating when the former location is the Abyss: say "You'll have to paddle yourself over the edge again if you want to go back to the Abyss. Haven't you been through enough?"


Instead of examining the player:
	say "You are currently being played by a generically attractive person of about 30. They are loving the game, even if they don't realize it."


Section 2 - Regional Coverage

[Here we draw in the idea that different clothes go over different areas of the body, and that they should be in competition with each other only if both sets of clothes belong at the same level over the same body area.]

Before wearing something:
	let N be the layering depth of the noun;
	repeat with item running through things worn by the player:
		if the layering depth of the item is N and the item covers a body-part which is covered by the noun:
			say "(first taking off [the item])[command clarification break]";
			silently try taking off the item;
			if the player wears the item, stop the action.

[This may seem like overkill, but it allows us to create garments that cover different subsets of the body -- pants and shirt vs. a dress, for instance.]

To decide what number is the layering depth of (chosen garment - a thing):
	let N be 0;
	if the chosen garment covers a body-part (called base):
		let N be the number of steps via the overlying relation from the chosen garment to the base;
	decide on N.

[To help with modeling, we'll give everyone body parts, broken down according to their relevance to clothing:]

A body-part is a kind of garment-element. A torso, a butt, a head, pair of legs, and pair of feet are kinds of body-part.

[If we wanted to allow gloves, we might put in hands as well; but this is enough for now.]

One head is part of every person. One torso is part of every person. One pair of legs is part of every person. One pair of feet is part of every person. One butt is part of every person.

[And now we make some categories of clothing:]

A garment is a kind of garment-element. A garment can be transparent. A pair of pants, a pair of underwear, a foundation garment, a pair of socks, a pair of shoes, a jacket, a hat, a dress, and a shirt are kinds of garment.

The plural of pair of pants is pairs of pants. The plural of pair of underwear is pairs of underwear. The plural of pair of socks is pairs of socks. The plural of pair of shoes is pairs of shoes.

A pair of pants, a pair of underwear, a foundation garment, a pair of socks, a pair of shoes, a jacket, a hat, a dress, and a shirt are usually wearable.

When play begins:
	now every pair of socks overlies every pair of feet;
	now every pair of shoes overlies every pair of socks;
	now every pair of underwear overlies every butt;
	now every pair of pants overlies every pair of underwear;
	now every foundation garment overlies every torso;
	now every jacket overlies every shirt;
	now every jacket overlies every dress;
	now every hat overlies every head;
	now every dress overlies every pair of underwear;
	now every dress overlies every foundation garment.



Section 1 - Procedure

[First we create the concept of facts, and the idea that facts can make some things more important than others.]

A fact is a kind of thing. A fact can be known or unknown. A fact can be ready to learn or hidden. A fact has some text called the narration.

Definition: a thing is narratively significant if it conveys an interesting fact.

Definition: a thing is narratively dull if it is not narratively significant.

Conveyance relates various things to various facts. The verb to convey means the conveyance relation.

Definition: a fact is interesting if it is unknown and it is ready to learn.

[Now, we also need a way to tell Inform to introduce certain new facts when the right previous ones have been introduced. We'll create a "following" relation, according to which a new fact can be told to the player when the player has already learned all the facts it follows. This way, we can simulate the effect of putting together several pieces of evidence to come to a conclusion:]

Following relates various facts to various facts. The verb to follow means the following relation.

To say (new fact - a fact):
	say "[narration of the new fact]";
	now the new fact is known;
	repeat with possible outcome running through facts which follow the new fact:
		if every fact which is followed by possible outcome is known:
			now the possible outcome is ready to learn.

[Next we need a way for the game to introduce these new facts. Let's say we want them to come up when the player examines something appropriate, or sees it in the room:]

After examining something which conveys an interesting fact (called discovery):
	say "[discovery][paragraph break]".

After choosing notable locale objects:
	repeat through the Table of Locale Priorities:
		if the notable-object entry is narratively significant:
			set the locale priority of the notable-object entry to 1.

For writing a paragraph about a narratively significant thing (called item):
	now the item is mentioned;
	let chosen fact be a random interesting fact which is conveyed by the item;
	say "[chosen fact][paragraph break]".





Height is a kind of value. 5 feet 11 inches specifies a height. 5'11 specifies a height. A person has a height.

Definition: a person is tall if its height is 6 feet 0 inches or more.

Definition: a person is short if its height is 5 feet 2 inches or less.

	When play begins: 
	now the height of the player is a random height between 4 feet 7 inches and 5 feet 4 inches.

The growth pill is a kind of thing. A growth pill is always edible. The description is usually "It is leaf-green and has a reassuring logo of a curling vine on the side. Nothing to worry about, nothing at all." 

After eating the growth pill:
	increase the height of the player by 1 feet 6 inches;
	say "Your spine does something frightening and painful, and you find yourself looking down on the room from a wholly new angle.";
	try looking.



When play begins: 
	now left hand status line is "Nearby: [if a room is adjacent][the list of adjacent rooms][end if][if a room is adjacent and a door is visible] and [end if][if a door is visible][the list of visible doors][end if]"; 
	now right hand status line is "". 

Rule for printing the name of an unvisited room (called the target) while constructing the status line: 
	let aim be the best route from the location to the target; 
	say "something [aim]". 

After printing the name of a visited room (called the target) while constructing the status line: 
	let aim be the best route from the location to the target; 
	say " ([aim])". 

Rule for printing the name of a direction (called the aim) while constructing the status line: 
	choose row with a heading of the aim in the Table of Abbreviation; 
	say "[shortcut entry]". 

Table of Abbreviation
heading	shortcut
north	"N"
northeast	"NE"
northwest	"NW"
east	"E"
southeast	"SE"
south	"S"
southwest	"SW"
west	"W"
up	"U"
down	"D"
inside	"in"
outside	"out"




Chapter 1 - The Cave

[Time of day as scene idea take from Passage of Time Chapter 4.1]

The creature is in the holding pen.

Getting Started is a scene. First Fight is a scene. Finding Jake is a scene. Hold Everything is a scene. Without An Oar is a scene.

Getting Started begins when the player carries the wooden oar.
When Getting Started begins:
	say "'Okay Jake. I'm coming for you buddy.' [paragraph break]You decide to assess your situation and take inventory before starting out.";
	try taking inventory;
	the creature roars in four turns from now.
	
At the time when the creature roars:
	say "[paragraph break]You stop for a moment and listen. You can feel a low rumble emanating from deep within the cave. You shiver at the thought of whatever made that sound.[paragraph break]"

Getting Started ends when the player carries the floating staff.

First Fight begins when Getting Started ends. 
When First Fight begins: 
	say "The moment you touch what you swore was a mystical looking staff it writhes in your hand and you drop it into the cold, dark water. Then suddenly, the creature leaps at you from below!";
	move the floating staff to the holding pen;
	move the eel to the cavern;
	Every turn during First Fight (this is the eel-attack rule):
	if the eel is not dead, try the eel attacking the player with a random weapon which is carried by the eel.

Before going west during the First Fight, say "You're too distracted by the eel that is attacking you to paddle away." instead.


First Fight ends when eel is dead. 

Finding Jake begins when First Fight ends.
When Finding Jake begins:
	say "[paragraph break]You barely have time to think about the eel you just killed and its lifeless body before you when you hear more splashing from ahead. You ready yourself for another fight.[paragraph break]<press any key>[paragraph break]";
	wait for any key;
	say "[paragraph break]The splashing stops and you hold your breath for a moment, straining to listen. Then from the darkness before you a voice yells. 'Well, Come and get me, already!'[paragraph break]You hear scrawny arms slapping the water as if trying to appear frightening instead of frightened. 'Did you hear me? Come on!' the familiar voice yells, clearly straining.[paragraph break]You can just make out the shape of someone swimming in the water ahead.[paragraph break]<press any key>[paragraph break]";
	wait for any key;
	say "[paragraph break]'Man, Jake, you look like shit. Here, let me help you,' you say as you help Jake onto the ancient raft. 'I'm so glad I found you. Lets get out of here.'";
	move Jake to the ancient raft;
	the creature bellows in 1 minute from now.
	
At the time when the creature bellows:
	say "[paragraph break]Suddenly, much closer and louder than before, you feel another rumble. This time it swells until it is all around you in the rock, and within you, vibrating your bones. You know what you hear is the strange bellow of an ancient beast from the dawn of time. 'What else could it be?' you think to yourself, accutely aware that at any moment your eardrums will burst.[paragraph break]You look at Jake and see he is screaming. At least it looks like he is screaming but you can't hear him or anything but the rumble. Just before your vision fades to black and your knees give out, you think about how your ears are broken and you'll never hear again.[paragraph break]<press any key>[paragraph break]";
	wait for any key;
	say "'...ello...'[paragraph break]... Hellooo. Earth to [player's forename]...[paragraph break]<press any key>[paragraph break]";
	wait for any key;
	say "[paragraph break]You realize your hearing has come back, but with a dull, high-pitched ring. You look up to see Jake offering a hand and he helps you back on your feet.[paragraph break]'Well that wasn't scary at all,' Jake says, with notably less gusto than usual. 'We really should find a way out of here.'"

Finding Jake ends when the player wears the worn backpack.

Hold Everything begins when Finding Jake ends.
When Hold Everything begins:
	say "Another rumble begins deep in the cave. Instead of dissipating after a few seconds or swelling to a roar, the sound trembles in the cavern moving sometimes nearer and louder and then backing away. The tremors last so long you start to see bits of stone shaking loose around you.[paragraph break]Jake says exactly what you are thinking. 'We gotta make like a tree and get outta here!'"

Instead of going East during Hold Everything:
	say "A huge piece of rock falls from the ceiling nearly missing the raft. It knocks you into Jake and the wooden oar goes flying.[paragraph break]'Oh shit!' you hear Jake yell as you struggle to gain your footing on the raft.";
	move wooden oar to the abyss;
	now the ignition is switched off.
	
Hold Everything ends when the wooden oar is in the abyss.

Without An Oar begins when Hold Everything ends.
When Without An Oar begins:
	say "[paragraph break]To your dismay, the raft starts to move with the rapids. You don't have long until you go over the edge."; 
	the creature waits in two turns from now;
	the creature soars in three turns from now.
	
At the time when the creature waits:
	say "[paragraph break]The raft has been swept to the edge of the waterfall. You have one last chance to think of something.[paragraph break]".

At the time when the creature soars:
	say "[paragraph break]The raft barrels over the edge. You and Jake hold each others hands, sure of the end to come.[paragraph break][paragraph break]Your hands are ripped apart as you are bounced from the raft and tossed through the air. For a moment you can see Jake falling away from you, and then he is just a shape in the darkness.[paragraph break]";
	move the creature to the abyss.
	
Without An Oar ends when the creature is in the abyss.

Who Are You is a room.

The player's forename is a text that varies. The player's full name is a text that varies.

When play begins:
	now the command prompt is "What is your full name? > ".

To decide whether collecting names:
	if the command prompt is "What is your full name? > ", yes;
	no.

After reading a command when collecting names:
	if the number of words in the player's command is greater than 5:
		say "[paragraph break]Who are you, a member of the British royal family? No one has that many names. Let's try this again.";
		reject the player's command;
	now the player's full name is the player's command;
	now the player's forename is word number 1 in the player's command;
	clear the screen;
	now the command prompt is ">";
	clear the screen;
	say "[paragraph break]Hello, [player's forename]. Welcome and thank you for playing [italic type]The Children of Loblolly Lodge[roman type]. Good luck on your adventure![paragraph break][paragraph break]This is a friendly reminder that commonly used commands include actions such as Look, Examine, Take, and Wear - just to name a few.[paragraph break]Movement is usually carried out by typing a compass direction (N, S, E, or W) unless implied or stated otherwise (as it is in the first room you encounter...) Here is an example of a standard movement: The player wants to travel North. This could be entered as 'go north,' 'north,' or simply 'n.' I'm sure you will get the hang of it in no time![paragraph break]Once play begins, the black status bar at the top of the screen displays two things: On the left - a map of sorts indicating nearby rooms. On the right - your current hit points (life level).[paragraph break]<Press Space Bar to continue>";
	wait for the SPACE key;
	clear the screen;
	say "Moments before...[paragraph break][paragraph break][italic type]Jake struggled to find his bearings.[paragraph break]The boy had never been able to open his eyes underwater. Squinting through tight lids, he twisted around looking for [player's forename].[paragraph break]";
	say "The pressure in his ears had not registered with Jake in his initial panic. Now he thought he must be much deeper underwater than he expected. He thought his heart might beat right out of his chest, he was so scared.[paragraph break]";
	say "Thoughts were racing through Jake’s mind - Where did [player's forename] go? Why weren't they right there when I jumped in? Did [player's forename] trip, or jump... or were they pushed? Jake hadn’t seen what happened, but he had seen that look on Tom’s face. Jake had turned around at the sound of the splash and there was Tom, standing with his arms straight out in front of him. Definitely pushed, he thought. And [player's forename] should have been right there for me to grab. It doesn't matter now, he thought. Jake took another stroke and still did not find air.[paragraph break]";
	say "Suddenly, Jake’s face broke through the surface of the water. He took a huge gulp of air and wiped his hair from his face. He turned his head frantically, scanning for any sign of his cousin’s head or hands bobbing on the surface. Seeing nothing, Jake took a huge gulp of air and quickly dove back under the water.[paragraph break]";
	say "Come on [player's forename], where are you?[paragraph break][paragraph break]<Press Space Bar to continue>";
	wait for the SPACE key;
	clear the screen;
	move the player to the ancient raft; 
	reject the player's command;

	
	
[We also want to postpone the proper beginning of the game until we've gotten the name:]

Instead of looking when collecting names: do nothing.

Rule for printing the banner text when collecting names: do nothing.

Rule for constructing the status line when collecting names: do nothing.

The player wears airwalks, ankle socks, briefs, jeans, a t-shirt, and windbreaker. The description of airwalks is "They aren't Tony Hawk's Signature Skate Shoes, but they're still Airwalks which is pretty damn cool. Slightly bulky with white soles and a blue, green, and black suede upper featuring a white block A with a circle around it. They do not make you better at skateboarding or anything else." The description of ankle socks is "Somewhat dingy white Champion socks that come up to the ankle and display white and red C logo." The description of briefs is "Fruit of the Loom. Seen better days." The description of jeans is "Your favorite jeans. They have several grass stains, but you feel they were well earned." The description of t-shirt is "A glow-in-the-dark Albert Einstein face made up of stars and galaxys on a black t-shirt. Well worn." The description of the windbreaker is "Black and Purple nylon make up this incredibly fashionable - and noisy - Nike windbreaker." The sound of the windbreaker is "Swisshh Swishh".

The ankle socks are a pair of socks. 
The airwalks are pairs of shoes. 
The briefs are pairs of underwear.
The jeans are pairs of pants. 
The t-shirt is a shirt. 
The windbreaker is a jacket. 

A jacket is a kind of thing. A jacket is always wearable. 

A pocket is a kind of container. A pocket is part of every jacket. The carrying capacity of a pocket is always 2. 

After examining a jacket: 
	let target be a random pocket which is part of the noun; 
	say "[The target] contains [a list of things in the target]." 

A pair of pants is a kind of thing. A pair of pants is always wearable.

A pocket is part of every pair of pants. 

After examining a pair of pants: 
	let target be a random pocket which is part of the noun; 
	say "[The target] contains [a list of things in the target]." 
	
The jeans's pocket contains a Swiss army knife. The description of the Swiss army knife is "A multi-bladed pocket knife that can do all sorts of things!"


The windbreaker's pocket contains a letter. The description of letter is "A folded piece of stationary with your name scrawled on the outside. You would recognize your mother's handwriting anywhere." The printing of letter is "[paragraph break]'Dear [player's forename], [paragraph break] Don't worry, you will have fun with your cousin this summer. I promise! Have fun, stay out of trouble, and be nice to your sister. [paragraph break] Love, [paragraph break] Mom & Dad'".

The carrying capacity of the player is 3.

The worn backpack is a player's holdall. The worn backpack can be open or closed. The worn backpack is closed.

The worn backpack is wearable.


The Cave is a region. the dark chamber, the cavern, narrowing tunnel, fork, abyss, waterfall and dock are in The Cave.

The Dark Chamber is a room. A lake is here. The ancient raft is a vehicle in the Dark Chamber.

The description of the Dark Chamber is "[if the ancient raft is in the Dark Chamber for the second time]Re-entering the Dark Chamber has not made you any more comfortable.[end if][if the ancient raft is in the Dark Chamber for the first time] You are light-headed and dazed. The back of your scalp feels tender to the touch. You can't quite remember what happened or how you ended up... wherever this is.[end if][if the ancient raft has visited the abyss] You have a strange senese of Deja vu... you're light-headed and dazed. The back of your scalp is really hurting, like you fell from some height.[end if] You immediately feel uneasy.

[if the ancient raft is in the Dark Chamber for the first time]You look down and see you are on some type of raft.[end if] You are[if the ancient raft is in the Dark Chamber for the second time] again[end if] floating in the middle of a dark chamber on placid water that has an otherwordly glow yet somehow doesn't actually light up the space.[if the wooden oar is in the lake] There is a place on the raft to hold an oar, but it is empty.[end if][if the ancient raft is in the Dark Chamber for more than the second time] -- the place seems creepier than ever[end if].[paragraph break]In the lake there appears to float [a list of things in the lake]."

[Now the door, which will change from saying "leads inside..." to "leads back inside..." when this becomes appropriate:]

The portal is a door. The portal is open. The portal is inside from Dark Chamber and outside from the Narrowing Tunnel. "An opening worn through craggy rock leads[if the ancient raft is in the Narrowing Tunnel and the Dark Chamber is visited and the Fork is not visited] back to the dark chamber at this end of the [end if][if the ancient raft is in the Narrowing Tunnel and the Fork is visited] back to the Fork at this end and the dark chamber at the other end of the [end if][if the ancient raft is in the Dark Chamber] inside a tunnel of some sort[otherwise] tunnel[end if]."

[Here we haven't used any conditions that we didn't know about in previous sections: the portal line only reflects whether the Zone has been visited never or visited once. But the Secure Zone itself makes use of the number of times visited:]

The narrowing tunnel is a room.

The Narrowing Tunnel has the description "[if the ancient raft is in the Narrowing Tunnel for the second time] You are starting to feel claustrophobic in here... [end if]You have a entered a tunnel that is wide near the chamber and so slim on the other end you aren't sure if the raft will fit.[if the ancient raft is in the Narrowing Tunnel for more than the second time] -- This tunnel creeps you out every time you enter it[end if]."

[And finally, to be sure that the player does see our fancy changing descriptions:]

Use full-length room descriptions.


The lake is a liquid source. The lake bottom is a container. The description of the lake is "Eerily placid with a faint, otherworldly glow." Understand "water" as lake when the ancient raft is in the Dark Chamber. 

The description of the ancient raft is "Made of worn planks of wood bound together by tattered, ancient ropes. Cold and slimy to the touch." The ignition is a device. the ignition is part of the ancient raft. Instead of going by the ancient raft when the ignition is switched off: say "There is no way to propel the boat. If only I had a paddle of some sort." Instead of switching on the ancient raft, try switching on the ignition. Instead of switching off the ancient raft, try switching off the ignition.  

Before taking the wooden oar: 
	if the player is inside the ancient raft: 
		now the ignition is switched on;

A vehicle has some text called the movement sound. The movement sound of the ancient raft is "a steady ker-splash as you paddle." Understand "boat" as the ancient raft.

After going somewhere by a vehicle (called cart): 
	if the movement sound of the cart is not "", say "[the movement sound of the cart][paragraph break]"; 
	continue the action. 

Instead of going somewhere when the player is not in a vehicle: 
	say "You'd rather not try to make this journey by swimming." 
	
The wooden oar is in the lake. "A wooden oar floats nearby, just within reach." The description of the wooden oar is "A plain wooden oar[if the wooden oar is in the lake] floats in the water, just within reach[end if]. I can use it to steer this raft in any direction I want.[if the wooden oar is carried][paragraph break]<The Ancient Raft can now be used to travel. One does not need to type paddle or row - simply type go inside or go north to move in that particular direction>". 

Understand "paddle" as wooden oar. 

Swimming is an action applying to nothing. Understand "swim" or "dive" as swimming. 

A thing can be inflated or uninflated. A thing is usually uninflated. 

The flotation rules are an object-based rulebook.

A flotation rule for an inflated thing: rule succeeds.
A flotation rule for the wooden oar: rule succeeds.

After inserting something into the lake:
	if the rule succeeded:
		say "[The noun] bobs on the surface.";
	otherwise:
		move the noun to the lake bottom;
		say "[The noun] sinks out of sight."

A thing can be sinking, rising, or static. A thing is usually static.

Definition: a thing is wet: 
	if it is in the lake, yes; 
	if it is in the rushing water, yes;
	if it is in the water bottom, yes;
	if it is in the lake bottom, yes; 
	no. 

Every turn: 
	now every thing is static; 
	repeat with item running through wet things: 
		follow the flotation rules for the item; 
		if the rule failed and the item is in the lake, now the item is sinking; 
		if the rule succeeded and the item is in the lake bottom, now the item is rising; 
	now every rising thing is in the lake; 
	now every sinking thing is in the lake bottom; 
	if something is rising, say "[The list of rising things] rise[if the number of rising things is 1]s[end if] to the surface of the lake."; 
	if something is sinking, say "[The list of sinking things] sink[if the number of sinking things is 1]s[end if] out of sight." 

[And finally a few description rules to make things look prettier:]

Rule for writing a paragraph about the lake when the lake contains something:
	say "In the lake there appears to float[if the number of things in the lake is 1]s[end if] [a list of things in the lake]."
	

The wooden oar is an inflated thing.

The sound of the ancient raft is "moaning and creaking of old wood and rope".

Instead of exiting when the player is in a vehicle and the location is not the Dock: 
	say "You're not dressed for a swim." 
	
The Dock is a room.

Understand "scalp" as head. 

After touching head in the Dark Chamber:
	say "You feel a bump. It stings when you touch it.. Must have knocked it pretty good."
	

"A View of Green Hills"

Understand "look [direction]" as facing.

Facing is an action applying to one visible thing.

Carry out facing:
	let the viewed item be the room noun from the location;
	if the viewed item is not a room, say "You can't see anything promising that way." instead;
	try looking toward the viewed item.

[In rules about action handling, "noun" refers to the first object that the player has mentioned in his command, so if the player typed >LOOK WEST, "let the viewed item be the room noun from the location" would be processed as "let the viewed item be the room west from the location", and so on.]

[We can at need override the default behavior, if it is not going to be appropriate for the player to see the next room over. There is only sky above at any time, so...]

Instead of facing up:
	if the player is in the Dark Chamber, say "Above you is darkness and a pinprick of light. Could it be sky?" instead;
	say "Above you is bright sky."

Understand "look toward [any adjacent room]" as looking toward. Understand "examine [any adjacent room]" as looking toward.

Understand "look toward [any thing]" as looking toward. 

Looking toward is an action applying to one visible thing.

Carry out looking toward:
	say "You make out [the noun] that way."

[This design allows us to create descriptions for rooms (as seen from the outside) which will work regardless of where we're looking from. For instance:]

Instead of looking toward Narrowing Tunnel:
	say "From here you can make out the silhouette of a tunnel leading into darkness.[if the ancient raft is in the Dark Chamber for the first time][paragraph break]'Maybe I could go inside?'[end if]"

Instead of looking toward Dark Chamber:
	say "You can just make out the chamber where you first awoke on the raft. You don't see much reason to go back and padding this raft is hard work."

The Fork is a room. The Fork is north of Narrowing Tunnel. The Fork has the description "[if the ancient raft is in the Fork for the first time]You struggled to paddle the creaky, old raft through the narrow gap. You finally manage it by grabbing at the slimy, damp walls and pulling yourself forward in the darkness.

A few times you swear you felt something scurry by your fingers.

After what seemed like ages you were able to leave the tunnel and paddle into the space.[end if][if the ancient raft is in the Fork for the second time] Back at the fork... Maybe you should try going another way this time... [end if] Here, like the chamber you awoke in, there is a strange light eminating from everywhere and nowhere. There is a fork in the raft's path, heading East and West[if the ancient raft is in the Narrowing Tunnel for more than the second time] -- you really seem to be lost[end if]."

Instead of looking toward the Fork while the ancient raft is in the narrowing tunnel:
	say "From here you look opposite the dark chamber at what you have decided to think is probably North, but really have no idea. If the raft will fit, you think there might be a way out."
	
The rock face is in the Fork. The rock face is a supporter. The rock face is fixed in place. The description of the rock face is "Protruding from the water is a jagged pillar of rock."

The Strange Carving is on the rock face. The strange carving is fixed in place. The description is "There are lines carefully carved in the rock here."

Instead of taking the strange carving:
	say "The strange carving is part of the rock face. It cannot be taken."

Instead of facing North while the ancient raft is in the Fork:
	say "There is nowhere to go in that direction. In the strange light the pillar of rock with its carving fills the space before you."
	
Instead of facing East when the ancient raft is in the Fork:
	say "Looking East you can see nothing. The strange glow that has existed in varying degrees in the cavern system until now seems to fade to darkness in that direction. You aren't sure what is making the sound, but you are sure you hear something splashing in the water up ahead.[paragraph break]'Jake, is that you?!' you yell into the darkness. The only response is the haunting echo of your own voice."
	
Instead of facing West when the ancient raft is in the Fork:
	say "You think you can hear the sound of rushing water from this direction. Does that make sense when the water below you is perfectly still? There is a draft and the air feels much colder that way. [if the ancient raft is in the Fork for the first time]You feel uneasy, but maybe this is the way out?[end if]"


Section 1 - Based on play throughs

Instead of examining briefs in The Cave:
	say "Its umm... cold down here in the cave..."

Instead of facing North while the ancient raft is in the Dark Chamber:
	say "You feel disoriented as you float on the ancient raft in the middle of the dark chamber and aren't sure which direction you are looking. There is enough of the strange light to just make out what could be a tunnel worn into the stone, dark and uninviting... going inside might be the only option. The tall walls of rock around you seem to climb up endlessly until you can't tell if you are truly in a cave or if you're possibly looking up at a star-less sky."
	
Instead of facing South when the ancient raft is in the Dark Chamber:
	say "You feel disoriented as you float on the ancient raft in the middle of the dark chamber and aren't sure which direction you are looking. There is enough of the strange light to just make out what could be a tunnel worn into the stone, dark and uninviting... going inside might be the only option. The tall walls of rock around you seem to climb up endlessly until you can't tell if you are truly in a cave or if you're possibly looking up at a star-less sky."
	
Instead of facing East when the ancient raft is in the Dark Chamber:
	say "You feel disoriented as you float on the ancient raft in the middle of the dark chamber and aren't sure which direction you are looking. There is enough of the strange light to just make out what could be a tunnel worn into the stone, dark and uninviting... going inside might be the only option. The tall walls of rock around you seem to climb up endlessly until you can't tell if you are truly in a cave or if you're possibly looking up at a star-less sky."
	
Instead of facing West when the ancient raft is in the Dark Chamber:
	say "You feel disoriented as you float on the ancient raft in the middle of the dark chamber and aren't sure which direction you are looking. There is enough of the strange light to just make out what could be a tunnel worn into the stone, dark and uninviting... going inside might be the only option. The tall walls of rock around you seem to climb up endlessly until you can't tell if you are truly in a cave or if you're possibly looking up at a star-less sky."
	
Instead of facing South when the ancient raft is in the Narrowing Tunnel:
	say "You can just make out the chamber where you first awoke on the raft. You don't see much reason to go back and padding this raft is hard work."
	
Instead of facing East when the ancient raft is in the Narrowing Tunnel:
	say "The tunnel is dark and you can barely make out the walls on either side. From what little is left of the strange glow from the chamber you can see that the tunnel curves around to what you decide to call North. The tunnel is slim in that direction but you think you can make it through."
	
Instead of facing West when the ancient raft is in the Narrowing Tunnel:
	say "The light is starting to fade as you paddle into the tunnel, but its clear there is only the rough rock wall in this direction. You can see that the tunnel curves around to what you decide to call North. The tunnel is slim in that direction but you think you can make it through."




Section 2 - Continuing on after Fork

Waterfall is a room. Waterfall is west of the Fork. The description is "The cavern opens up wide before you. To your dismay you see that the water has begun to flow very quickly, pulling the raft with it.[paragraph break]You realize where all the water is flowing as you see that the space opens up before you to the West.[if the ancient raft is in Waterfall for the first time][paragraph break]'You have got to be kidding me. A waterfall?!'[end if]"

The flat rock is in Waterfall. The flat rock is scenery. The description of flat rock is "a small flat rock that looks to have worn over time by the rushing water. An old chest sits upon the rock taking up the small space. Who put it there?[if the chest is closed] What could be inside?[end if]"

The ancient chest is a locked lockable container on the flat rock. The description is "An old chest sits alone on the flat rock in the middle of the rushing water. The chest looks as ancient as the raft you awoke on. Paddling near the flat rock, you can just make out a metal plate on the chest with an etching above the key hole."

The metal plate is part of the chest. The description is "Set into the front of the wooden chest is a polished metal plate, somehow untarnished, displaying an etching of a skull. The skull appears to be only vaguely human. The etching sits above a keyhole.[if the player carries the skeleton key] The etching is clearly of the creepy skull head on the key you found.[end if]"

The worn backpack is in the ancient chest.

The Skeleton Key unlocks the ancient chest.

Instead of taking the ancient chest, say "It's far too heavy to lift." 

Rushing Water is in Waterfall. Rushing water is a liquid source. The water bottom is a container. The description of the rushing water is "The water is moving fast toward the dropoff ahead. If you stop paddling you will surely go over the edge!" Understand "water" as rushing water when the ancient raft is in Waterfall. The sound of rushing water is "GURRRG-ROARRR--SPPLAASHHHH". 



Before opening the ancient chest while the player cannot see an other person:
	say "You can't stop paddling to unlock the chest or the current will take you over the edge";
	now the ancient chest is closed;
	now the ancient chest is locked.
	
Before opening the ancient chest while the player can see an other person:
	say "[if the chest is locked]You are already tired from moving around the cave system for the last hour. You hand the oar to Jake who takes over paddling while you try to unlock the strange chest that stands alone on a rock in rapid waters next to a waterfall in an underground cavern...[otherwise]'Hurry, [player's forename], these rapids are no joke!' Jake says, as he keeps the raft positioned next to the flat rock long enough for you to open the ancient chest. The hinges are rusty and the wood is heavy, but you force the lid upward...[end if]" 
	
The description of worn backpack is "A regular, plain looking Jansport backpack. Well worn. Deep green in color with a brown leather bottom and two black shoulder straps."

	
A thing has some text called printing. The printing of a thing is usually "blank".

Understand the command "read" as something new. Understand "read [something]" as reading. Reading is an action applying to one thing. Check reading: if the printing of the noun is "blank", say "Nothing is written on [the noun]." instead. Carry out reading: say "[printing of the noun][line break]". Report reading: do nothing.
	
A note is in the worn backpack. The description is "A hastily scribbled note." The printing of note is "[paragraph break]'You were able to find the skeleton key. And you wouldn't be reading this if you didn't work together. That says something at least. Hang on to the key and to this bag. I know it's not much, but its all I could do under the circumstances. You'll understand eventually.[paragraph break]Good luck to the three of you, you'll need it.'[paragraph break]It is signed with just the letter W. It goes on to say 'PS - You can trust old Mab. Usually.'"

Understand "lock [something]" as locking keylessly. Locking keylessly is an action applying to one thing.

Check locking keylessly:
	if the noun is not a door, say "[The noun] is not something you can lock." instead;
	if the noun is not a chest, say "[The noun] is not something you can lock." instead;
	if the noun is locked, say "[The noun] is already locked." instead;
	if the player carries the skeleton key, try locking the noun with the skeleton key instead.

Carry out locking keylessly:
	now the noun is locked.

Report locking keylessly:
	say "You flip over the deadbolt to lock [the noun]."

Understand "unlock [something]" as unlocking keylessly. Unlocking keylessly is an action applying to one thing.

Check unlocking keylessly:
	if the noun is unlocked, say "[The noun] is already unlocked." instead;
	if the player cannot see Jake, say "[The noun] is locked and you can't stop paddling long enough to use the key you found." instead;
	if the player can see Jake, try unlocking the noun with the skeleton key instead;
		say "You can't unlock the chest while also paddling the raft so you hand the wooden oar to Jake."

Carry out unlocking keylessly:
	now the noun is unlocked.



[Something to consider after adding jake if I want to use army knife as a key... I might be able to include a new skeleton key code

Because it is possible for more than one key to unlock a given door, the property "matching key" is now meaningless. Would this affect my other code??

Skeleton Keys is compatible with, but does not require, Locksmith by Emily Short.

Example: 

Include Skeleton Keys by Emily Short. 

Every door is unlocked by the swiss army knife.]




Every turn: 
	now every thing is static; 
	repeat with item running through wet things: 
		follow the flotation rules for the item; 
		if the rule failed and the item is in the rushing water, now the item is sinking; 
		if the rule succeeded and the item is in the water bottom, now the item is rising; 
	now every rising thing is in the rushing water; 
	now every sinking thing is in the water bottom; 
	if something is rising, say "[The list of rising things] rise[if the number of rising things is 1]s[end if] to the surface of the rushing water."; 
	if something is sinking, say "[The list of sinking things] sink[if the number of sinking things is 1]s[end if] out of sight." 

Rule for writing a paragraph about the rushing water when the rushing water contains something:
	say "In the rushing water there appears to float[if the number of things in the rushing water is 1]s[end if] [a list of things in the rushing water]."

Abyss is a room. Abyss is west of Waterfall. The description is "Somehow water that was placid and still is now roaring over the edge of an underground waterfall. From where you stand on the ancient raft you can see the water flow over the edge and out of sight into what appears to be an endless, expansive abyss in the earth."

Instead of facing West when the ancient raft is in Waterfall:
	say "Maybe a hundred feet away is the edge of a giant waterfall. It takes most of your strength to keep the raft in the same spot and not get swept away.[if the ancient raft is in Waterfall for the first time][paragraph break]You briefly think about letting yourself and the raft just go over the edge... It doesn't make sense but neither does the rest of today. And your arms are really tired.[end if]"

Before going West in Waterfall when the player cannot see Jake:
	end the story saying "The ancient raft plunges over the edge of the waterfall. You fall for what seems like ages into the darkness of the abyss."
	
Instead of going West in Waterfall when the player can see Jake:
	say "[if the wooden oar is in the abyss]Without an oar with which to paddle, the raft has started drifting toward the edge of the waterfall.[paragraph break]Jake is repeating the same two words, 'Oh, shit. Oh, shit. Oh, shit.'[otherwise]Jake says 'Yeah, no. I don't have a death wish.'[paragraph break]You don't know why you thought about going over the edge. You shake the thought from your mind and keep paddling.[end if]"
	
Instead of facing East in Waterfall:
	say "[if the ancient raft is in Waterfall for the first time]The fork in your path lies back that way. You recall how you went West at the strange carving.[otherwise]The strange carving on the rock face is in that direction.[end if]"

When play ends when the story has not ended finally: 
	say "[paragraph break]WOW! You went right over the edge. Really, that ought to be fatal! However... [paragraph break]You open your eyes and blink a few times. You feel hard ridges in your back and you have a dull ache in your head... And you hold something cold in your hand.


	Do you want to get up and continue your adventure? >"; 
	if the player consents: 
		now the ancient raft is in the Dark Chamber;
		now the player is in the ancient raft; 
		now the player carries the wooden oar; 
		now the player carries the Black Coin;
		say "You do not recall how you ended up back at [the location], though perhaps maybe going over the edge of a waterfall isn't the best idea...[paragraph break]You feel something cold in your hand that wasn't there before. You open your fist and see a black coin sitting in your palm."; 
		resume the story. 

Black Coin is a thing. The black coin is in the Abyss. The description is "A jet black coin made of a mysterious substance. On one face of the coin is a smiley face, but with a third eye centered above the other two. All three eyes are Xs. It is the same on the other side of the coin, except the face is frowning."


Instead of dropping the black coin:
	say "You flip the coin. [one of]Heads - a smiling face wtih three X eyes stares back at you.[or]Tails - a frowning face wtih three X eyes stares back at you.[purely at random]"

Section 3 - Facts about key for chest

Stalactites is in the Dark Chamber. Stalactites are fixed in place. The description is "You stare up at the rocks and think about how they look like slimy, cave icicles.[if stalactites-hiding-spot is known] Thinking about the map you found, you decide to paddle the raft directly under the stalactites and feel around with your hand."


The hidden crevice is an openable container in stalactites. It is fixed in place. Hidden crevice can be visible or invisible. It is invisible.

The Skeleton Key is a thing. The Skeleton Key can be found or lost. The Skeleton Key is lost. The description is "An ancient looking iron key with a few serrated teeth at one end and a rusted skull symbol on the other. However, the skull looks oddly real and three dimensional... and only vaguely human."

carving-map is a fact.
	It is ready to learn.
	The narration is "[if looking]There are lines carefully carved in the rock here... [end if] You wipe off untold years of dust to reveal a map of sorts. You think you make out where you are. The rock pillar is represented by a jagged rock drawing and there is a path going right or left. The map doesn't show what is in either direction, but does seem to show the tunnel you just travelled through and the chamber where you awoke on the raft.[paragraph break]You trace your finger on the map from where you think you are now - at the carving - down to the dark chamber. You see a roughly drawn raft and behind that - an X marking something."
	Strange Carving conveys carving-map.
	
stalactites-hanging is a fact.
	It is ready to learn.
	The narration is "[if looking]Huge pointing rocks hang down from the ceiling, like the teeth of a giant cave monster. [end if]You always thought seeing stalactites would be cool, but you've changed your mind."
	Stalactites conveys stalactites-hanging.

stalactites-hiding-spot is a fact.
	It follows carving-map and stalactites-hanging.
	The narration is "You [if examining Strange Carving]stare at [otherwise]think about [end if]the spot marked with an X. Is that where those stalactites were hanging?"
	Strange Carving conveys stalactites-hiding-spot.
	Stalactites conveys stalactites-hiding-spot.
	
Understand "x" as the strange carving.

stalactites-hiding-spot-reminder is a fact.
	It follows stalactites-hiding-spot.
	The narration is "You are pretty sure you need to go south - through the narrowing tunnel - and then outside - to the dark chamber."
	Strange Carving conveys stalactites-hiding-spot-reminder.

Instead of examining the hidden crevice when the skeleton key is lost and stalactites-hiding-spot is unknown:
	say "That noun did not make sense in this context.";
	
Instead of examining stalactites when the skeleton key is lost and stalactites-hiding-spot is unknown:
	say "You stare up at the rocks and think about how they look like slimy, cave icicles.";

Instead of examining the hidden crevice when the skeleton key is lost: 
	now the skeleton key is found; 
	say "You reach your hand up and slide it across the slimy rock until you feel the small ledge. You don't think you ever would have thought to search like this without the map. You feel something cold and hard and whip your hand back... but then realize it was metallic thing you were feeling.[paragraph break]'I think there is a key hidden up there,'[if the player can see Jake] you say to Jake. [otherwise] you say to youself.[end if] The sound of your voice takes on an eery echo in the chamber."; 
	move the skeleton key to the hidden crevice. 
	
The you-can-also-see rule is not listed in any rulebook.

For printing the locale description (this is the new you-can-also-see rule):
	let the domain be the parameter-object;
	let the mentionable count be 0;
	repeat with item running through things:
		now the item is not marked for listing;
	repeat through the Table of Locale Priorities:
		if the locale description priority entry is greater than 0,
			now the notable-object entry is marked for listing;
		increase the mentionable count by 1;
	if the mentionable count is greater than 0:
		repeat with item running through things:
			if the item is mentioned:
				now the item is not marked for listing;
		begin the listing nondescript items activity with the domain;
		if the number of marked for listing things is 0:
			abandon the listing nondescript items activity with the domain;
		otherwise:
			if handling the listing nondescript items activity with the domain:
				if the domain is the location:
					say "[We] " (A);
				otherwise if the domain is a supporter or the domain is an animal:
					say "On [the domain] [we] " (B);
				otherwise:
					say "In [the domain] [we] " (C);
				if the locale paragraph count is greater than 0:
					say "[regarding the player][can] also see " (D);
				otherwise:
					say "[regarding the player][can] see " (E);
				let the common holder be nothing;
				let contents form of list be true;
				repeat with list item running through marked for listing things:
					if the holder of the list item is not the common holder:
						if the common holder is nothing,
							now the common holder is the holder of the list item;
						otherwise now contents form of list is false;
					if the list item is mentioned, now the list item is not marked for listing;
				filter list recursion to unmentioned things;
				if contents form of list is true and the common holder is not nothing,
					list the contents of the common holder, as a sentence,
						giving brief inventory information, tersely, not listing
						concealed items, listing marked items only;
				otherwise say "[a list of marked for listing things]";
				if the domain is the location, say " here" (F);
				say ".[paragraph break]";
				unfilter list recursion;
			end the listing nondescript items activity with the domain;
	continue the activity.


The cavern is a room. The cavern is east of fork. The description is "[If player cannot see Jake]There is a small dark tunnel you pass through and then the space opens into an enormous Cavern. [end if]The eery glow makes it so you can see that there are other tunnels leading away from the cavern in many directions like the spokes of a wheel."

Jake is a person. The description is "Jake is a friend of yours -- a tenuous friendship formed betwen cousins forced to spend their summers and holidays together. He might not always be the kindest, but he has your back."

Jake wears an awesome shirt. The description of the awesome shirt is "Red cotton t-shirt with bold yellow lettering: it's that kind that might be ironed on -- and the shirt simply reads: STEPHEN KING RULES."

The floating staff is in the cavern. The description is "A magical looking staff - like something Gandalf would have carried - floats in the water. A power seems to eminate from it."

Instead of looking toward the Fork while the ancient raft is in the cavern:
	say "You look back at the direction from which you just paddled. You wonder to yourself about who made the strange carving on the rock face."

Instead of facing north while the ancient raft is in the cavern:
	say "There are dark tunnels leading away from the enormous main chamber in every direction.[if the player cannot see Jake] Jake could be down here somewhere but you wouldn't know where to begin searching.[otherwise][paragraph break]'I don't think we should go that way, [player's forename]' Jake says as he sees you looking toward the tunnels. 'Please.'[end if]"
	
Instead of facing south while the ancient raft is in the cavern:
	say "There are dark tunnels leading away from the enormous main chamber in every direction.[if the player cannot see Jake] Jake could be down here somewhere but you wouldn't know where to begin searching.[otherwise][paragraph break]'I don't think we should go that way, [player's forename]' Jake says as he sees you looking toward the tunnels. 'Please.'[end if]"
	
Instead of facing southeast while the ancient raft is in the cavern:
	say "There are dark tunnels leading away from the enormous main chamber in every direction.[if the player cannot see Jake] Jake could be down here somewhere but you wouldn't know where to begin searching.[otherwise][paragraph break]'I don't think we should go that way, [player's forename]' Jake says as he sees you looking toward the tunnels. 'Please.'[end if]"
	
Instead of facing southwest while the ancient raft is in the cavern:
	say "There are dark tunnels leading away from the enormous main chamber in every direction.[if the player cannot see Jake] Jake could be down here somewhere but you wouldn't know where to begin searching.[otherwise][paragraph break]'I don't think we should go that way, [player's forename]' Jake says as he sees you looking toward the tunnels. 'Please.'[end if]"
	
Instead of facing northeast while the ancient raft is in the cavern:
	say "There are dark tunnels leading away from the enormous main chamber in every direction.[if the player cannot see Jake] Jake could be down here somewhere but you wouldn't know where to begin searching.[otherwise][paragraph break]'I don't think we should go that way, [player's forename]' Jake says as he sees you looking toward the tunnels. 'Please.'[end if]"
	
Instead of facing northwest while the ancient raft is in the cavern:
	say "There are dark tunnels leading away from the enormous main chamber in every direction.[if the player cannot see Jake] Jake could be down here somewhere but you wouldn't know where to begin searching.[otherwise][paragraph break]'I don't think we should go that way, [player's forename]' Jake says as he sees you looking toward the tunnels. 'Please.'[end if]"
	
Instead of facing east while the ancient raft is in the cavern:
	say "There are dark tunnels leading away from the enormous main chamber in every direction.[if the player cannot see Jake] Jake could be down here somewhere but you wouldn't know where to begin searching.[otherwise][paragraph break]'I don't think we should go that way, [player's forename]' Jake says as he sees you looking toward the tunnels. 'Please.'[end if]"

Section 4 - Combat

Section 1 - Hit Points

A person has a number called maximum hit points. A person has a number called current hit points.

Animal has a number called maximum hit points. A animal has a number called current hit points.

The maximum hit points of the player is 100. The maximum hit points of Jake is 100.

Holding pen is a room.

The eel is a animal in the holding pen. "A dark, sleek eel jumps at you, wielding its [a list of weapons carried by eel]." The maximum hit points of the eel is 13.


When play begins:
	repeat with victim running through people:
		now the current hit points of the victim is the maximum hit points of the victim;
		now the current hit points of the player is 75.

Definition: a person is dead if his current hit points are less than 0.

Section 2 - Diagnosis

Diagnosing is an action applying to one visible thing. Understand "diagnose [something]" as diagnosing.

Check diagnosing:
	if the noun is not a person, say "Only people can have diagnoses." instead.

Carry out diagnosing:
	say "[if the noun is the player]You have[otherwise][The noun] has[end if] [current hit points of the noun] out of a possible [maximum hit points of the noun] hit points remaining."

Section 3 - Weapons

A weapon is a kind of thing. A weapon has a number called the maximum damage. The maximum damage of a weapon is usually 10.

The eel carries a weapon called teeth. The maximum damage of teeth is 8. The eel carries a weapon called electrical shock. The maximum damage of the electrical shock is 10.


Section 4 - Attacking it with

Understand the commands "attack" and "destroy" and "kill" and "murder" and "hit" and "stab" and "thump" and "break" and "smash" and "torture" and "wreck" as something new.

Attacking it with is an action applying to one visible thing and one carried thing. Understand "attack [someone] with [something preferably held]" as attacking it with.

Understand the commands "destroy" and "kill" and "murder" and "hit" and "thump" and "break" and "stab" and "smash" and "torture" and "wreck" as "attack".


Understand "acquire [something]" and "get [something]" and "gain [something]" and "obtain [something]" and "pick up [something]" and "procure [something]" and "grab [something]" and "snag [something]" and "snatch [something]" and "collect [something]" as taking.


The attacking it with action has a number called the damage inflicted.

Setting action variables for attacking something with something:
	if the second noun is a weapon:
		let the maximum attack be the maximum damage of the second noun;
		now the damage inflicted is a random number between 1 and the maximum attack.

Check an actor attacking something with something (this is the can't attack with something that isn't a weapon rule):
	if the second noun is not a weapon:
		if the actor is the player, say "[The second noun] does not qualify as a weapon.";
		stop the action.
		
[insert can't attack a non-person rule?]

Carry out an actor attacking something with something (this is the standard attacking it with a weapon rule):
	decrease the current hit points of the noun by the damage inflicted;
	if the noun is dead:
		let the corpse be a random body which is part of the noun;
		move the corpse to the location;
		move the noun to the spirit-world.
		
Report attacking a dead person with something (this is the death-report priority rule):
	say "You attack with [the second noun], killing [the noun]!" instead.

Report attacking someone with something (this is the normal attacking report rule):
	say "You attack [the noun] with [the second noun], causing [damage inflicted] point[s] of damage!" instead.

Report someone attacking the player with something when the player is dead (this is the player's-death priority rule):
	say "[The actor] attacks you with [the second noun], finishing you off!";
	end the story;
	stop the action

Report someone attacking the player with something (this is the standard report someone attacking the player with rule):
	say "[The actor] attacks you with [the second noun], causing [damage inflicted] point[s] of damage!" instead.

Report someone attacking something with something (this is the standard report attacking it with rule):
	say "[The actor] attacks [the noun] with [the second noun], causing [damage inflicted] point[s] of damage!" instead.

When play begins:
	now the right hand status line is "You: [current hit points of player]";
	
Wooden oar is a weapon. The maximum damage of wooden oar is 15.

Swiss Army knife is a weapon. The maximum damage of swiss army knife is 10.


Understand "flip [something]" as dropping. 


Section 5 - Leave Behind Corpses


A body is a kind of thing. A body is a part of every person. Instead of touching a body: say "[The noun] is grotesquely inert."

A body is a part of every animal.

The description of eel's body is "Long and slender. A gross creature with sharp jagged teeth." The initial appearance of eel's body is "The eel's corpse is limp and lifeless."

Spirit-possession relates one person to one body. The verb to be owner of means the spirit-possession relation.


When play begins:
	repeat with victim running through people:
		let the corpse be a random body which is part of the victim;
		now the victim is owner of the corpse.

Setting action variables when the noun is a body which is part of a person (called owner):
	now the noun is the owner.

Setting action variables when the second noun is a body which is part of a person (called owner):
	now the second noun is the owner.

Setting action variables when the noun is a dead person and the noun is owner of a visible body (called the mortal remains):
	now the noun is the mortal remains.

The worldview is a privately-named backdrop. It is everywhere. The spirit-world is a privately-named transparent closed unopenable container. It is part of the worldview.


Understand "corpse" as a body when the item described is not part of a person.

Understand "corpse" as a body when the item described is not part of a animal.


When play begins:
	repeat with victim running through animals:
		let the corpse be a random body which is part of the victim;
		now the victim is owner of the corpse.

Setting action variables when the noun is a body which is part of an animal (called owner):
	now the noun is the owner.

Setting action variables when the second noun is a body which is part of an animal (called owner):
	now the second noun is the owner.
	
Setting action variables when the noun is a dead animal and the noun is owner of a visible body (called the mortal remains):
	now the noun is the mortal remains.
	

Section 6 - Using blade to cut or carve 


A weapon is either sharp or dull.

Understand "cut [something] with [something]" as cutting it with. Understand "carve [something] with [something]" as cutting it with.

Instead of cutting something:
	if a weapon which is sharp (called the edge) is held by the player,
		try cutting the noun with the edge;
	otherwise say "Your fingernails are not sharp enough."

Cutting it with is an action applying to two things.

Check cutting it with:
	if the noun is a person, say "That would hurt." instead;
	if the second noun is not sharp, say "[The second noun] has not got enough of a blade." instead.

Carry out cutting it with:
	increment the count of rips of the noun.

Report cutting it with:
	say "You slash [the noun] with [the second noun]."

Instead of cutting the ancient chest with the Swiss army knife:
	say "Your knife barely makes a scratch."

Definition: a thing is ripped if the count of rips of it > 0. A thing has a number called the count of rips. After examining something ripped, say "You see [the count of rips of the noun in words] slash[s] in [the noun][if something is in the noun], revealing [a list of things in the noun][end if]."

[Moreover, because open containers normally list their contents when examined but we'd prefer Paddington's to be mentioned in the ripping paragraph:]

The examine containers rule does nothing when examining the teddy bear.

[So far, so good. But suppose that we'd like cutting also to make containers be permanently open and impossible to close again. We could write an "instead" rule, but that would mean that only our instead instructions would take effect, overriding the normal cutting it with rules entirely. Better would be to add a second carry out rule:]

Carry out cutting a container with something:
	now the noun is open;
	now the noun is unopenable.

[Now our rule will occur whenever a container is cut, but play will still go on to the reporting stage. And indeed we can add more of these, of varying degrees of specificity:]

Carry out cutting something which is part of something with something:
	move the noun to the player.

Carry out cutting the quilt with something:
	now the description of the quilt is "Horribly tattered."

[For that matter, we might want to add a report rule as well, to occur after the "You slash..." rule, so that every time the player cuts something open which has contents, the contents will be listed.]

Report cutting it with:
	if the noun is open and the noun contains something,
		say "Visible within [is-are a list of things in the noun]."

[This time we do not add the condition to the rule (i.e., Report cutting an open noun...) If we did, this report rule would be more specific than the general report rule, and would occur first.]

[below is a possible room in the cabin]

The Bunk is a room.

The teddy bear is a closed thing in the Bunk. The description is "Fluffy[if the head is part of the bear], with an outsized head[otherwise], but headless[end if]." The bear head is a closed part of the teddy bear. In the bear is a large wad of stuffing. In the bear head are a small wad of stuffing and a packet of smuggled diamonds.

The quilt is in the Bunk. The description is "An old but comforting quilt."


[Here is a final nicety to get rid of the "which is closed" statement on our closed unopenable teddy bear, using an "activity" rule:]

After reading note for the first time:
	say "'Well that's cryptic.' you say[paragraph break]'Good luck to the three of us?' Jake ponders aloud. 'What the f.'";
	now the note is examined.
	
After reading note for the second time:
	say "'Yup, still cryptic.'"

After printing the name of a closed unopenable container:
	omit contents in listing.
	
After printing the name of a closed openable container:
	omit contents in listing.
	
The Swiss Army knife is sharp. The wooden oar is dull.

Instead of taking the worn backpack from the ancient chest:
	say "[paragraph break]You hold the backpack up for Jake to see.[paragraph break]'That's it? Seriously, all that for an old backpack?! Wait, tell me that backpack does not say Jansport.'[paragraph break]'No, it definitely does. This is like something my dad owns.' You say. 'How the hell did this even get here[if the note is examined] and who is that note from[end if]?'";
	now the player wears the worn backpack.

The Void is a room. The description is "A void, empty of time and space. Or something like that. You can't really comprehend it all."

The Wishing Well is a room.

First Meeting is a scene. First Meeting begins when Without An Oar ends.
When First Meeting begins: 
	center "[paragraph break]*** You feel the sensation of falling. Then suddenly you don't. You look around you and see darkness that isn't dark. Your feet are on solid ground but there is no ground. ***[paragraph break]"; 
	pause the game;
	move the ancient raft to the holding pen;
	move the player to the Void;
	strip the player. 

When First Meeting ends: 
	center "*** Somehow a void that is nothing seems to fade to nothingness ***"; 
	pause the game;
	now saved location is the Bunk;
	restore the player. 

Saved location is a room that varies. Locker is a container. Wardrobe is a container. 

To strip the player: 
	now every thing carried by the player is in the locker; 
	now every thing worn by the player is in the wardrobe; 
	now saved location is location. 

To restore the player: 
	now every thing carried by the player is in the Bunk; 
	now every thing in the locker is carried by the player; 
	now every thing in the wardrobe is worn by the player; 
	move the player to saved location. 



[Consider using Pine 4 or chunks of it!]

