/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.blorb;

import java.util.ArrayList;
import java.util.List;
import org.zmpp.base.MemoryAccess;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.FormChunk;
import org.zmpp.media.MediaCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlorbMediaCollection<T>
implements MediaCollection<T> {
    private List<Integer> resourceNumbers = new ArrayList<Integer>();

    public BlorbMediaCollection(FormChunk formChunk) {
        this.initDatabase();
        Chunk chunk = formChunk.getSubChunk("RIdx".getBytes());
        MemoryAccess memoryAccess = chunk.getMemoryAccess();
        int n = (int)memoryAccess.readUnsigned32(8);
        int n2 = 12;
        byte[] byArray = new byte[4];
        for (int i = 0; i < n; ++i) {
            int n3;
            for (n3 = 0; n3 < 4; ++n3) {
                byArray[n3] = memoryAccess.readByte(n2 + n3);
            }
            if (this.isHandledResource(byArray)) {
                n3 = (int)memoryAccess.readUnsigned32(n2 + 4);
                int n4 = (int)memoryAccess.readUnsigned32(n2 + 8);
                Chunk chunk2 = formChunk.getSubChunk(n4);
                if (this.putToDatabase(chunk2, n3)) {
                    this.resourceNumbers.add(n3);
                }
            }
            n2 += 12;
        }
    }

    @Override
    public void clear() {
        this.resourceNumbers.clear();
    }

    @Override
    public int getNumResources() {
        return this.resourceNumbers.size();
    }

    public int getResourceNumber(int n) {
        return this.resourceNumbers.get(n);
    }

    @Override
    public void loadResource(int n) {
    }

    @Override
    public void unloadResource(int n) {
    }

    protected abstract void initDatabase();

    protected abstract boolean isHandledResource(byte[] var1);

    protected abstract boolean putToDatabase(Chunk var1, int var2);
}

