/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import org.zmpp.encoding.ZsciiEncoding;

public class ZsciiString {
    private static ZsciiEncoding encoding;
    private short[] data;

    public static void initialize(ZsciiEncoding zsciiEncoding) {
        encoding = zsciiEncoding;
    }

    public ZsciiString(short[] sArray) {
        this.data = sArray;
    }

    public ZsciiString(String string) {
        this.data = encoding.convertToZscii(string);
    }

    public short charAt(int n) {
        return this.data[n];
    }

    public int length() {
        return this.data.length;
    }

    public int indexOf(ZsciiString zsciiString, int n) {
        int n2 = this.length();
        int n3 = zsciiString.length();
        for (int i = n; i < n2; ++i) {
            int n4;
            if (this.charAt(i) != zsciiString.charAt(0)) continue;
            for (n4 = 1; n4 < n3 && this.charAt(i + n4) == zsciiString.charAt(n4); ++n4) {
            }
            if (n4 != n3) continue;
            return i;
        }
        return -1;
    }

    public ZsciiString substring(int n, int n2) {
        int n3 = n2 - n;
        short[] sArray = new short[n3];
        for (int i = 0; i < n3; ++i) {
            sArray[i] = this.charAt(n + i);
        }
        return new ZsciiString(sArray);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            n = 31 * n + this.data[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        short[] sArray;
        if (object == this) {
            return true;
        }
        if (object instanceof ZsciiString && this.data.length == (sArray = ((ZsciiString)object).data).length) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == sArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            stringBuilder.append(encoding.getUnicodeChar(this.data[i]));
        }
        return stringBuilder.toString();
    }
}

