/* The <sys/stat.h> header defines a struct that is used in the stat() and
 * fstat functions.  The information in this struct comes from the i-node of
 * some file.  These calls are the only approved way to inspect i-nodes.
 */

struct stat {
  dev_t st_dev;			/* major/minor device number */
  ino_t st_ino;			/* i-node number */
  mode_t st_mode;		/* file mode, protection bits, etc. */
  nlink_t st_nlink;		/* number of links */
  uid_t st_uid;			/* uid of the file's owner */
  gid_t st_gid;			/* gid of the file's owner */
  short int st_rdev;
  off_t st_size;		/* file size */
  time_t st_atime;		/* time of last access */
  time_t st_mtime;		/* time of last data modification */
  time_t st_ctime;		/* time of last file status change */
};

/* Traditional mask definitions for st_mode. */
#define S_IFMT  0170000		/* type of file */
#define S_IFREG 0100000		/* regular */
#define S_IFBLK 0060000		/* block special */
#define S_IFDIR 0040000  	/* directory */
#define S_IFCHR 0020000		/* character special */
#define S_IFIFO 0010000		/* this is a FIFO */
#define S_ISUID 0004000		/* set user id on execution */
#define S_ISGID 0002000		/* set group id on execution */
				/* 0001000 is reserved for future use */

/* POSIX masks for st_mode. */
#define S_IRWXU   00700		/* owner:  rwx------ */
#define S_IRUSR   00400		/* owner:  r-------- */
#define S_IWUSR   00200		/* owner:  -w------- */
#define S_IXUSR   00100		/* owner:  --x------ */

#define S_IRWXG   00070		/* group:  ---rwx--- */
#define S_IRGRP   00040		/* group:  ---r----- */
#define S_IWGRP   00020		/* group:  ----w---- */
#define S_IXGRP   00010		/* group:  -----x--- */

#define S_IRWXO   00007		/* others: ------rwx */
#define S_IROTH   00004		/* others: ------r-- */ 
#define S_IWOTH   00002		/* others: -------w- */
#define S_IXOTH   00001		/* others: --------x */

/* The following macros test st_mode (from POSIX Sec. 5.6.1.1. */
#define S_ISREG(m)	((m & S_IFMT) == S_IFREG)	/* is a reg file */
#define S_ISDIR(m)	((m & S_IFMT) == S_IFDIR)	/* is a directory */
#define S_ISCHR(m)	((m & S_IFMT) == S_IFCHR)	/* is a char spec */
#define S_ISBLK(m)	((m & S_IFMT) == S_IFBLK)	/* is a block spec */
#define S_ISFIFO(m)	((m & S_IFMT) == S_IFFIFO)	/* is a pipe/FIFO */


/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
mode_t umask(mode_t __cmask);
int mkdir(char *__path, mode_t __mode);
int mkfifo(char *__path, mode_t __mode);
int stat (char *__path, struct stat *__buf);
int fstat(int __fildes, struct stat *__buf);
int chmod(char *__path, mode_t __mode);
#endif


#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
mode_t umask();
#endif
