/* The <pwd.h> header defines the items in the password file. */

struct passwd {
  char *pw_name;		/* login name */
  uid_t pw_uid;			/* uid corresponding to the name */
  gid_t pw_gid;			/* gid corresponding to the name */
  char *pw_dir;			/* user's home directory */
  char *pw_shell;		/* name of the user's shell */

  /* The following members are not defined by POSIX. */
  char *pw_passwd;		/* password information */
  char *pw_gecos;		/* just in case you have a GE 645 around */
};


/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
struct passwd *getpwuid(uid_t __uid);
struct passwd *getpwnam(char *__name);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
struct passwd *getpwuid();
struct passwd *getpwnam();
#endif
