/* The <math.h> header contains prototypes for mathematical functions. */

#ifndef _MATH_H
#define _MATH_H

#define HUGE_VAL	9.9e+999	/* though it will generate a warning */

/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
double	acos(double __x);
double	asin(double __x);
double	atan(double __x);
double	atan2(double __y, double __x);
double	cos(double __x);
double	sin(double __x);
double	tan(double __x);
double	cosh(double __x);
double	sinh(double __x);
double	tanh(double __x);
double	exp(double __x);
double	log(double __x);
double	log10(double __x);
double	sqrt(double __x);
double	ceil(double __x);
double	fabs(double __x);
double	floor(double __x);
double	pow(double __x, double __y);
double	frexp(double __x, int *__exp);
double	ldexp(double __x, int __exp);
double	modf(double __x, double *__iptr);
double	fmod(double __x, double __y);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
double	acos();
double	asin();
double	atan();
double	atan2();
double	cos();
double	sin();
double	tan();
double	cosh();
double	sinh();
double	tanh();
double	exp();
double	log();
double	log10();
double	sqrt();
double	ceil();
double	fabs();
double	floor();
double	pow();
double	frexp();
double	ldexp();
double	modf();
double	fmod();
#endif

#endif /* _MATH_H */
