/*
**	char *KEY2NAME(key) -- return ascii name of the specified MIDI key
**	NAME2KEY(char *name) -- return MIDI key number for the ascii key name
**	Changed 1/1/89 to make middle C == C3 == 60.
**	psl 9/88
*/

static	char	*Nn[]	= {
	"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B",
};

char	*
key2name(key)
{
	register char *bp, *cp, oct;
	static char buf[5];

	for (bp = buf, cp = Nn[key%12]; *bp = *cp++; bp++);
	oct = key / 12 - 2;
	if (oct < 0) {
	    *bp++ = '-';
	    oct = -oct;
	}
	*bp++ = '0' + oct;
	*bp++ = '\0';
	return(buf);
}

name2key(n)
char	*n;
{
	register int pc, o;

	for (pc = 0; Nn[pc] && Nn[pc][0] != n[0]; pc++);
	if (!Nn[pc])
	    return(0);
	o = 1;
	while (n[o] == 'b' || n[o] == '#') {
	    pc += n[o] == '#' ? 1 : -1;
	    o++;
	}
	return(pc + (n[o] - '0') * 12 + 24);
}
