/* ftpdefs.h */

#ifndef _ftpdefs_h_
#define _ftpdefs_h_

#define FTP_VERSION "NcFTP 1.0 PL2 (20 Jan 93)"

typedef char string[128], str32[32];

struct userinfo {
	str32   username;
	string  homedir;
	string  shell;
	string  hostname;
	int		uid;
};

/*
 * Your compiler may not like the 'const' directives.  If it chokes
 * here, add -DCONST to your SDEFS line in the Makefile.
 */
#if defined(CONST) || defined(const)
#define Strncpy(a,b) strncpy((a), (const char *) (b), (size_t) sizeof (a))
#define Strncat(a,b) strncat((a), (const char *) (b), (size_t) sizeof (a))
#else
#define Strncpy(a,b) strncpy((a), (char *) (b), (size_t) sizeof (a))
#define Strncat(a,b) strncat((a), (char *) (b), (size_t) sizeof (a))
#endif

#define FGets(a,b) fgets((a), sizeof(a) - 1, (b))

#endif /* _ftpdefs_h_ */
/* eof */
