/* globals.h
 *
 * Part of the Internet Gopher program, copyright (C) 1991
 * University of Minnesota Microcomputer Workstation and Networks Center
 *
 * In this file you will find all of the global variables and 
 * global defines.
 */


#define MAXRESP      9                  /* Max size of a response list*/
#define WHOLELINE 80                   /* Used in ourutil.c */

/*
 * These are some funky defines that assures that global variables are
 * declared only once.  (when globals.c includes this file with EXTERN
 * defined.
 */

#ifndef EXTERN
#define EXTERN extern
#define INIT(x)
#else
#define EXTERN
#define INIT(x) =(x)
#endif


/*** Global variables ***/

EXTERN String    *PrinterCommand; /*used for configuration options */
EXTERN String    *PagerCommand;   
EXTERN String    *TelnetCommand;  
EXTERN String    *MailCommand;
EXTERN String    *PlayCommand;
EXTERN String    *EditorCommand;
EXTERN String    *TN3270Command;
EXTERN String    *MIMECommand;
EXTERN boolean   ChangedDefs INIT(FALSE);

EXTERN char      *Searchstring INIT(NULL);
EXTERN int       iLevel INIT(0);
EXTERN BOOLEAN   SecureMode INIT(FALSE);
EXTERN BOOLEAN   DEBUG INIT(FALSE);

EXTERN GopherDirObj *CurrentDir INIT(NULL);
EXTERN GopherDirObj *OldDirs[30];  /** Should be a stack... **/

EXTERN GopherDirObj *BookmarkDir INIT(NULL);

EXTERN char      USERCAP[WHOLELINE];    /* The validated user capability */
EXTERN int       SOUNDCHILD INIT(0);     /* The pid of the sound player child. */
EXTERN CursesObj *CursesScreen;

#include "version.h"


/*** Externals ***/

extern char **environ;                  /* User environment array */
extern char *sys_errlist[];

/*** Prototypes and forward declarations ***/

/*** Ourutils.c ***/
void display_file(/* char *Filename */);
void ZapCRLF( /* char *buffer */ );
int  outchar( /*char c*/ );        
void CursesErrorMsg( /* char* */);
void GetOneOption(/* char*, char* */);

int  process_request(/* ZeGopher*/);
int  Load_Dir(/*ZeGopher*/);
int  Load_Index();
int  Load_Index_or_Dir();
void GetOneOption(/* */);
void check_sock(/* int, char* */);
