// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// This is the object to do all of the hiscore work

#ifndef __BPHiScore__
#define __BPHiScore__

#include "str.h"
#include <iostream.h>
#include <stdio.h>
#include <unistd.h>

#define HiScoreListSize	10

// SCOREDIR determines where the high-score file will be stored.
// If not defined in the makefile, default it to the current directory
#ifndef SCOREDIR
#define SCOREDIR "./"
#endif


typedef unsigned int Score;

class HiScore {

    public:
    
	HiScore( const char *file );
	~HiScore();    
    
    	// return pos in list if score is good enough to be placed on
    	// list, -1 otherwise
    	char isHigh( Score s ) const;
    	
    	// add name/score to high score list. Returns 1 if ok, 0 otherwise
	char add( const String n, Score s) { return add( (const char *)n , s); }
    	char add( const char *name, Score s );
    	
    	// return name of i'th person on list
    	String name( int i ) const
    		{
    		if (inRange(i)) return Vname[i];
    		else return "";
    		}
    	
    	// return score 
    	Score score( int i ) const
    		{
    		if (inRange(i)) return Vscore[i];
    		else return 0;
    		}
    	
    	// return string of person's name and score
    	String operator[] (int i) const
    		{
		String result="";
    		if (inRange(i))
    			{
    			result = Vname[i];
    			result.rPad(20);
    			result += " ";
    			result += String(10,"%d",Vscore[i]);
    			}
		return result;
    		}

	// save high scores to disk.. done in destructor too
	// result of 1 means save was ok, 0 means error
	char save() const;
    	
    private:
    
	String	Vname[HiScoreListSize];
	Score	Vscore[HiScoreListSize];

	String	Vfile;
	
	// check for proper index in high score list
	// index starts at 0 to keep with C array conventions.
	char inRange(int i) const
		{
		if ( (i>=0) && (i<(HiScoreListSize)) ) return 1;
		else return 0;
		}    
    };

#endif
