/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 6.1 of the 
*Andrew User Interface System and is 
*the property of IBM, Carnegie Mellon University, 
*and the other copyright holders.  The source 
*code of this version is for the sole use of 
*the individual named in ./config/allsys.h.  
*This source code is not to be redistributed.  
*Binary object code compiled or derived from 
*these sources is not to be distributed to non-
*members.  Members may have additional 
*distribution rights granted by prior written 
*permission of Carnegie Mellon University.
*
*IBM, CARNEGIE MELLON UNIVERSITY, 
*AND THE OTHER COPYRIGHT HOLDERS
* DISCLAIM ALL WARRANTIES WITH 
*REGARD TO THIS SOFTWARE, INCLUDING 
*ALL IMPLIED WARRANTIES OF MERCHANT-
*ABILITY AND FITNESS. IN 
*NO EVENT SHALL  IBM, CARNEGIE 
*MELLON UNIVERSITY, OR ANY OTHER 
*COPYRIGHT HOLDER BE LIABLE FOR 
*ANY SPECIAL, INDIRECT OR CONSE-
*QUENTIAL DAMAGES OR ANY DAMAGES 
*WHATSOEVER RESULTING FROM LOSS OF
*USE, DATA OR PROFITS, WHETHER IN AN
*ACTION OF CONTRACT, NEGLIGENCE OR
*OTHER TORTIOUS ACTION, ARISING OUT 
*OF OR IN CONNECTION WITH THE USE OR
*PERFORMANCE OF THIS SOFTWARE.
* $
*/


 

#define tree23int_VERSION 1

class tree23int[tree23] {
methods:
    AddIn(long offset, struct tree23int *newnode);
    Apply(procedure proc);
    Filter(long offset, struct tree23int *left, struct tree23int *right, long lowval, long highval, procedure proc, char *procdata);
    FindL(long offset, long key) returns long;
    FindR(long offset, long key) returns long;
    Free();
    Merge(struct tree23int *ancestor, long offset, procedure proc, char *procdata);
    Update(long pos, long size);
    Enumerate(procedure proc, char *procdata) returns long;
    NumberOfLeaves() returns long; 
    Dump(long offset);
    Delete() returns struct tree23int *;
    Eval() returns long;
    Insert(long key, long data) returns struct tree23int *;
    Jam(struct tree23int *newnode);
    Remove(struct tree23int *child) returns struct tree23int *;
    Twiddle(struct tree23int *child);
    GetLeftMostNode() returns struct tree23int *;
    GetNextNode(struct tree23int *node) returns struct tree23int *;
    GetRightMostNode() returns struct tree23int *;
    GetPreviousNode(struct tree23int *node) returns struct tree23int *;
macromethods:
    GetData() (self->data)
classprocedures:
    Allocate() returns struct tree23int *;
    Deallocate(struct tree23int *self);
data:
    struct tree23int *parent;/* 	Parent of the node */
    long bump;			/* Amount to add to parents value to get key */
    long data;			/* The real data */
    boolean leaf;		/* True if the node is a leaf. */
    short nKids;
    struct tree23int *kid[3];
};

