/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 6.1 of the 
*Andrew User Interface System and is 
*the property of IBM, Carnegie Mellon University, 
*and the other copyright holders.  The source 
*code of this version is for the sole use of 
*the individual named in ./config/allsys.h.  
*This source code is not to be redistributed.  
*Binary object code compiled or derived from 
*these sources is not to be distributed to non-
*members.  Members may have additional 
*distribution rights granted by prior written 
*permission of Carnegie Mellon University.
*
*IBM, CARNEGIE MELLON UNIVERSITY, 
*AND THE OTHER COPYRIGHT HOLDERS
* DISCLAIM ALL WARRANTIES WITH 
*REGARD TO THIS SOFTWARE, INCLUDING 
*ALL IMPLIED WARRANTIES OF MERCHANT-
*ABILITY AND FITNESS. IN 
*NO EVENT SHALL  IBM, CARNEGIE 
*MELLON UNIVERSITY, OR ANY OTHER 
*COPYRIGHT HOLDER BE LIABLE FOR 
*ANY SPECIAL, INDIRECT OR CONSE-
*QUENTIAL DAMAGES OR ANY DAMAGES 
*WHATSOEVER RESULTING FROM LOSS OF
*USE, DATA OR PROFITS, WHETHER IN AN
*ACTION OF CONTRACT, NEGLIGENCE OR
*OTHER TORTIOUS ACTION, ARISING OUT 
*OF OR IN CONNECTION WITH THE USE OR
*PERFORMANCE OF THIS SOFTWARE.
* $
*/


/*
The path class is for caching information about a pathname --
whether or not it names a directory, and if so, what the 
directories and files are that it contains.

The information returned by
IsDirectory, GetFiles, GetDirs, GetNumFiles and GetNumDirs
is only as recent as the last call to Scan. Scan will stat the
directory, and re-read it only if necessary.
*/

class path[path] : observable[observe] {
  classprocedures:
    InitializeObject(struct path *self) returns boolean;
    FinalizeObject(struct path *self);
    Create(char *filepath) returns struct path *;
    TruncatePath(char *filepath, char *resultPath, long limit, boolean tryHome) returns char *;
    FreeTruncatedPaths();
    InputTruncatedPathCache(FILE *fp);
    OutputTruncatedPathCache(FILE *fp);
    ModifyToParentDirectory(char *filepath, boolean isDirectory) returns boolean;
    UnfoldFileName(char *fromString, char *toString, char *baseName) returns char *;
  methods:
    Scan(boolean statEverything) returns boolean;
    ReleaseFiles(char **filelist);
    ReleaseDirs(char **dirlist);
    Input(FILE *fp);
    Output(FILE *fp);
    IsDirectory() returns boolean;
    GetFiles() returns char **;
    GetDirs() returns char **;
    GetNumFiles() returns long;
    GetNumDirs() returns long;
    GetTruncatedPath() returns char *;
  macromethods:
    GetPath() ((self)->filepath)
  data:
    char *filepath;
    char *truncatedPath;
    time_t changetime;
    boolean haveScanned;
    boolean knowIsDir;
    boolean mayBeWrong; /* if the last scan didn't stat everything */
    boolean isDir;
    char **files;
    char **dirs;
    long numFiles;
    long numDirs;
};
