/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 6.1 of the 
*Andrew User Interface System and is 
*the property of IBM, Carnegie Mellon University, 
*and the other copyright holders.  The source 
*code of this version is for the sole use of 
*the individual named in ./config/allsys.h.  
*This source code is not to be redistributed.  
*Binary object code compiled or derived from 
*these sources is not to be distributed to non-
*members.  Members may have additional 
*distribution rights granted by prior written 
*permission of Carnegie Mellon University.
*
*IBM, CARNEGIE MELLON UNIVERSITY, 
*AND THE OTHER COPYRIGHT HOLDERS
* DISCLAIM ALL WARRANTIES WITH 
*REGARD TO THIS SOFTWARE, INCLUDING 
*ALL IMPLIED WARRANTIES OF MERCHANT-
*ABILITY AND FITNESS. IN 
*NO EVENT SHALL  IBM, CARNEGIE 
*MELLON UNIVERSITY, OR ANY OTHER 
*COPYRIGHT HOLDER BE LIABLE FOR 
*ANY SPECIAL, INDIRECT OR CONSE-
*QUENTIAL DAMAGES OR ANY DAMAGES 
*WHATSOEVER RESULTING FROM LOSS OF
*USE, DATA OR PROFITS, WHETHER IN AN
*ACTION OF CONTRACT, NEGLIGENCE OR
*OTHER TORTIOUS ACTION, ARISING OUT 
*OF OR IN CONNECTION WITH THE USE OR
*PERFORMANCE OF THIS SOFTWARE.
* $
*/


 

/* environ.H
 * Class declarations for environment and preference maodule.
 *
 */

package environ {
    classprocedures:
        Put(char *variable, char *value);
        Delete(char *variable);
        Get(char *variable) returns char *;
        GetProfile(char *preference) returns char *;
        GetProfileSwitch(char *preference, boolean defaultValue) returns boolean;
	GetProfileInt(char *preference, long defaultValue) returns long;
	ProfileEntryExists(char *preference, boolean useDefault) returns boolean;
	GetConfiguration(char *key) returns char *;
	AndrewDir(char *str) returns char *;
	LocalDir(char *str) returns char *;
	ReadConfigureFile(char *filename) returns struct configurelist *;
	GetConfig(struct configurelist *cList, char *key, boolean usedefault) returns char *;
	FreeConfigureList(struct configurelist *cList);
	GetHome(char *user) returns char *;  /* pass in NULL for current user */
	SetProgramName(char *string);	    /* for use by the GetProfile stuff */
	GetProfileFileName() returns char *;
};
