;;; d-appt.el --- An improved appointment notification system

;; Copyright (C) 2006-2011 Davin Pearson

;; Author/Maintainer: m4_davin_pearson
;; Keywords: improved appt.el
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;; With this file activated, every 30 minutes the message "okay Davin
;; it's time for a pause break so you should do something else which
;; is away from the computer." is played through your speakers.
;;
;; Also sound samples are played depending on the settings of your
;; ~/.diary file.

;;; m4_limitation_of_warranty

;;; m4_install_instructions(d-appt)

;;; Known Bugs:

;; none!

;;; Code:

;; d-time--get-stamp is used from     d-time.el
;; d-say-number-improved is used from d-number-sayer.el

(require 'appt)
(require 'calendar)
(require 'd-number-sayer)
(require 'd-time)

(setq diary-date-forms (cons '(year "-" month "-" day "[^0-9]") diary-date-forms))

(setq appt-display-diary nil)

(defun d-appt-pause-break ()
  (message "Last pause break commencing at %s" (d-time--get-stamp))
  (setq f "appt-pause-break.wav")
  (if (file-exists-p f)
      (play-sound (list 'sound :file f :volume 1.0)))
  (setq f "/media/www/C1TB/sound-samples/emacs/appt-pause-break.wav")
  (if (file-exists-p f)
      (play-sound (list 'sound :file f :volume 1.0)))
  )

(let (hour)
  (setq hour (nth 2 (decode-time (current-time))))
  (when (and (< hour 21) (>= hour 15))
    (if (boundp 'd-appt-pause-timer) (cancel-timer d-appt-pause-timer))
    (setq d-appt-pause-timer (run-with-timer (* 60 30) (* 60 30) 'd-appt-pause-break))))

;; (appt-display-message "d:/sound-samples/emacs/appt-lecture-14-00.wav" 0)
(defun appt-display-message (string mins)
  "Bug: why no v
   NOTE: no time to go sample if (not (string-match \"alarm-off\" string)) "
  (save-match-data
    (when (and (= 0 mins) (string-match "alarm-on" string))
      (if (boundp 'd-appt-pause-timer)
          (cancel-timer d-appt-pause-timer))
      (setq d-appt-pause-timer (run-with-timer (* 60 25) (* 60 30) 'd-appt-pause-break)))
    (if (and (= 0 mins) (string-match "heater-off" string) (boundp 'd-appt-pause-timer))
        (cancel-timer d-appt-pause-timer))
    ;; -------------------------------------------------------------------------------------------
    (when (not (string-match "nothing" string))
      (message "*** time=%s string=%s mins=%s" (d-time--get-stamp) (d-trim-string string) mins)
      (let (ptr appt-file min)
        (save-match-data
          (when (not (string-match "alarm-off" string))
            (if (string-match "[a-z]:/[^ \t\r\n]*" string)
                (progn
                  (setq appt-file (substring string (match-beginning 0) (match-end 0)))
                  ;;(message "*** appt-file=%s" appt-file)
                  (when (string-match "\\.wa$" appt-file)
                    (setq appt-file (concat appt-file "v"))
                    ;;(message "*** added v")
                    )
                  ;;(message "*** appt-file=%s" appt-file)
                  ;;(message "*** Appointment=%s mins to go=%d" appt-file mins)
                  ;;(setq appt-file "d:/sound-samples/emacs/alarm-on-lecture.wav")
                  (when (and (not (string= "d:/sound-samples/emacs/alarm-on.wav" appt-file))
                             (string-match "\\(^.*\\)alarm-on\\(.*$\\)" appt-file))
                    (setq appt-file (concat (substring appt-file (match-beginning 1) (match-end 1))
                                            "appt"
                                            (substring appt-file (match-beginning 2) (match-end 2))))
                    (play-sound (list 'sound :file "d:/sound-samples/emacs/alarm-on.wav" :volume 1.0)))
                  ;;(debug)
                  (if (and appt-file (file-exists-p appt-file))
                      (play-sound (list 'sound :file appt-file :volume 1.0))
                    (play-sound (list 'sound :file "d:/sound-samples/emacs/appt-misc.wav" :volume 1.0))))
              ;;(debug)
              (play-sound (list 'sound :file "d:/sound-samples/emacs/appt-misc.wav" :volume 1.0)))
            ;;(assert (>= mins 0))
            (d-say-number-improved mins)
            (if (= 1 mins)
                (setq min "d:/sound-samples/emacs/numbers/minute-to-go.wav")
              (setq min "d:/sound-samples/emacs/numbers/minutes-to-go.wav"))
            (if (file-exists-p min)
                (play-sound (list 'sound :file min :volume 1.0))
              (beep)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          (cond
           ((string-match "alarm-on" string)
            (if (or (= mins 0) (= mins 1) (= mins 2))
                (save-window-excursion
                  (if (get-buffer "*Async Shell Command*") (kill-buffer "*Async Shell Command*"))
                  (shell-command (concat "\"/media/www/C1TB/Program Files/foobar2000/foobar2000.exe\" "
                                         "\"/media/www/C1TB/Documents and Settings/Davin Pearson/My Documents/list.fpl\" &")))))
           ((string-match "alarm-off" string)
            (if t (save-window-excursion
                    (if (get-buffer "*Async Shell Command*") (kill-buffer "*Async Shell Command*"))
                    (shell-command (concat "\"/media/www/C1TB/Program Files/foobar2000/foobar2000.exe\" /exit &")))))))))))

(setq appt-disp-window-function 'd-appt-disp-window-function)

(defun d-appt-disp-window-function ()
  (message "*** crud"))

(defun appt-disp-window (min-to-app new-time appt-msg)
  )

(defun simple-diary-display ()
  )

(defun d-appt-activate ()
  (interactive)
  (require 'appt)
  (appt-activate 1)
  (setq appt-audible t)
  (setq appt-display-mode-line nil)
  ;;(d-f4)
  )

;;(d-appt-activate)

(provide 'd-appt)
;;; d-appt.el ends here
