/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.TtScaler;

public class EpochFormatter {
    private final DateFormat epochMilliFormat_ = EpochFormatter.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final DateFormat epochSecFormat_ = EpochFormatter.createDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final int iMaxValidTtScaler_;
    private int iLastTtScaler_ = -1;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final long HALF_DAY = 43200000L;
    private static final TtScaler[] TT_SCALERS = TtScaler.getTtScalers();
    private static final long LAST_KNOWN_LEAP_UNIX_MILLIS = EpochFormatter.getLastKnownLeapUnixMillis(TT_SCALERS);
    private static final Logger logger_ = Logger.getLogger(EpochFormatter.class.getName());
    public static boolean FAIL_ON_LEAP_ERROR = true;
    public static final long AD0_UNIX_MILLIS = EpochFormatter.getAd0UnixMillis();

    public EpochFormatter() {
        this(0);
    }

    public EpochFormatter(int n) {
        long l = EpochFormatter.getLastDataLeapUnixMillis(n) + 43200000L;
        if (l > LAST_KNOWN_LEAP_UNIX_MILLIS && l - LAST_KNOWN_LEAP_UNIX_MILLIS > 43200000L) {
            DateFormat dateFormat = EpochFormatter.createDateFormat("yyyy-MM-dd");
            String string = new StringBuffer().append("Data knows more leap seconds than library").append(" (").append(dateFormat.format(new Date(l + 43200000L))).append(" > ").append(dateFormat.format(new Date(LAST_KNOWN_LEAP_UNIX_MILLIS + 43200000L))).append(")").toString();
            logger_.warning(string);
        }
        if (l > 0L) {
            long l2 = l - 946728000000L;
            this.iMaxValidTtScaler_ = this.getScalerIndex(l2);
        } else {
            this.iMaxValidTtScaler_ = TT_SCALERS.length - 1;
        }
    }

    public String formatEpoch(double d) {
        long l = (long)(d + (double)AD0_UNIX_MILLIS);
        Date date = new Date(l);
        return EpochFormatter.formatDate(this.epochMilliFormat_, date);
    }

    public String formatEpoch16(double d, double d2) {
        long l = (long)(d * 1000.0) + AD0_UNIX_MILLIS;
        Date date = new Date(l);
        long l2 = (long)d2;
        if (l2 < 0L || (double)l2 >= 1.0E12) {
            return "??";
        }
        String string = new StringBuffer(32).append(EpochFormatter.formatDate(this.epochSecFormat_, date)).append('.').append(EpochFormatter.prePadWithZeros(l2, 12)).toString();
        assert (string.length() == 32);
        return string;
    }

    public String formatTimeTt2000(long l) {
        String string;
        Object object;
        int n;
        if (l == Long.MIN_VALUE) {
            return "9999-12-31T23:59:59.999999999";
        }
        if (l == -9223372036854775807L) {
            return "0000-01-01T00:00:00.000000000";
        }
        long l2 = l / 1000000L;
        int n2 = (int)(l % 1000000L);
        if (n2 < 0) {
            --l2;
            n2 += 1000000;
        }
        if ((n = this.getScalerIndex(l2)) > this.iMaxValidTtScaler_) {
            object = new StringBuffer().append("CDF TIME_TT2000 date formatting failed").append(" - library leap second table known to be out of date").append(" with respect to data.").append(" Update ").append("CDF_LEAPSECONDSTABLE").append(" environment variable to point at file").append(" http://cdf.gsfc.nasa.gov/html/CDFLeapSeconds.txt").toString();
            if (FAIL_ON_LEAP_ERROR) {
                throw new RuntimeException((String)object);
            }
            logger_.log(Level.SEVERE, (String)object);
        }
        object = TT_SCALERS[n];
        long l3 = (long)((TtScaler)object).tt2kToUnixMillis(l2);
        int n3 = ((TtScaler)object).millisIntoLeapSecond(l2);
        if (n3 < 0) {
            Date date = new Date(l3);
            string = EpochFormatter.formatDate(this.epochMilliFormat_, date);
        } else {
            Date date = new Date(l3 - 1000L);
            string = EpochFormatter.formatDate(this.epochMilliFormat_, date).replaceFirst(":59\\.", ":60.");
        }
        return string + EpochFormatter.prePadWithZeros(n2, 6);
    }

    private int getScalerIndex(long l) {
        int n;
        this.iLastTtScaler_ = n = TtScaler.getScalerIndex(l, TT_SCALERS, this.iLastTtScaler_);
        return n;
    }

    private static DateFormat createDateFormat(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(UTC);
        simpleDateFormat.setCalendar(new GregorianCalendar(UTC, Locale.UK));
        return simpleDateFormat;
    }

    private static String formatDate(DateFormat dateFormat, Date date) {
        return ((DateFormat)dateFormat.clone()).format(date);
    }

    private static long getAd0UnixMillis() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(UTC, Locale.UK);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.clear();
        gregorianCalendar.set(0, 0, 1, 0, 0, 0);
        long l = gregorianCalendar.getTimeInMillis();
        long l2 = 172800000L;
        return l + l2;
    }

    private static String prePadWithZeros(long l, int n) {
        String string = Long.toString(l);
        int n2 = n - string.length();
        if (n2 == 0) {
            return string;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static long getLastKnownLeapUnixMillis(TtScaler[] ttScalerArray) {
        TtScaler ttScaler = ttScalerArray[ttScalerArray.length - 1];
        return (long)ttScaler.tt2kToUnixMillis(ttScaler.getFromTt2kMillis());
    }

    private static long getLastDataLeapUnixMillis(int n) {
        if (n == 0) {
            return Long.MIN_VALUE;
        }
        if (n == -1) {
            return Long.MIN_VALUE;
        }
        DateFormat dateFormat = EpochFormatter.createDateFormat("yyyyMMdd");
        try {
            return dateFormat.parse(Integer.toString(n)).getTime();
        }
        catch (ParseException parseException) {
            logger_.warning("leapSecondLastUpdated=" + n + "; not YYYYMMDD");
            return Long.MIN_VALUE;
        }
    }
}

