
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <XCAFDoc_ColorTool.hxx>
#include <XCAFDoc_VisMaterialTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDataStd_NamedData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWMesh_TriangulationSource.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWMesh_TriangulationReader.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>

// module includes
#include <RWMesh.hxx>
#include <RWMesh_CafReader.hxx>
#include <RWMesh_CoordinateSystem.hxx>
#include <RWMesh_CoordinateSystemConverter.hxx>
#include <RWMesh_EdgeIterator.hxx>
#include <RWMesh_FaceIterator.hxx>
#include <RWMesh_MaterialMap.hxx>
#include <RWMesh_NameFormat.hxx>
#include <RWMesh_NodeAttributes.hxx>
#include <RWMesh_ShapeIterator.hxx>
#include <RWMesh_TriangulationReader.hxx>
#include <RWMesh_TriangulationSource.hxx>
#include <RWMesh_VertexIterator.hxx>

// template related includes

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <OSD_FileSystem.hxx>

// Module definiiton
void register_RWMesh_enums(py::module &main_module) {


py::module m = main_module.def_submodule("RWMesh", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<RWMesh_CoordinateSystem>(m, "RWMesh_CoordinateSystem",R"#(Standard coordinate system definition. Open CASCADE does not force application using specific coordinate system, although Draw Harness and samples define +Z-up +Y-forward coordinate system for camera view manipulation. This enumeration defines two commonly used conventions - Z-up and Y-up..)#")
        .value("RWMesh_CoordinateSystem_Undefined",RWMesh_CoordinateSystem::RWMesh_CoordinateSystem_Undefined)
        .value("RWMesh_CoordinateSystem_posYfwd_posZup",RWMesh_CoordinateSystem::RWMesh_CoordinateSystem_posYfwd_posZup)
        .value("RWMesh_CoordinateSystem_negZfwd_posYup",RWMesh_CoordinateSystem::RWMesh_CoordinateSystem_negZfwd_posYup)
        .value("RWMesh_CoordinateSystem_Blender",RWMesh_CoordinateSystem::RWMesh_CoordinateSystem_Blender)
        .value("RWMesh_CoordinateSystem_glTF",RWMesh_CoordinateSystem::RWMesh_CoordinateSystem_glTF)
        .value("RWMesh_CoordinateSystem_Zup",RWMesh_CoordinateSystem::RWMesh_CoordinateSystem_Zup)
        .value("RWMesh_CoordinateSystem_Yup",RWMesh_CoordinateSystem::RWMesh_CoordinateSystem_Yup).export_values();
    py::enum_<RWMesh_CafReaderStatusEx>(m, "RWMesh_CafReaderStatusEx",R"#(Extended status bits.)#")
        .value("RWMesh_CafReaderStatusEx_NONE",RWMesh_CafReaderStatusEx::RWMesh_CafReaderStatusEx_NONE)
        .value("RWMesh_CafReaderStatusEx_Partial",RWMesh_CafReaderStatusEx::RWMesh_CafReaderStatusEx_Partial).export_values();
    py::enum_<RWMesh_NameFormat>(m, "RWMesh_NameFormat",R"#(Name format preference for XCAF shape labels.)#")
        .value("RWMesh_NameFormat_Empty",RWMesh_NameFormat::RWMesh_NameFormat_Empty)
        .value("RWMesh_NameFormat_Product",RWMesh_NameFormat::RWMesh_NameFormat_Product)
        .value("RWMesh_NameFormat_Instance",RWMesh_NameFormat::RWMesh_NameFormat_Instance)
        .value("RWMesh_NameFormat_InstanceOrProduct",RWMesh_NameFormat::RWMesh_NameFormat_InstanceOrProduct)
        .value("RWMesh_NameFormat_ProductOrInstance",RWMesh_NameFormat::RWMesh_NameFormat_ProductOrInstance)
        .value("RWMesh_NameFormat_ProductAndInstance",RWMesh_NameFormat::RWMesh_NameFormat_ProductAndInstance)
        .value("RWMesh_NameFormat_ProductAndInstanceAndOcaf",RWMesh_NameFormat::RWMesh_NameFormat_ProductAndInstanceAndOcaf).export_values();

//Python trampoline classes
    class Py_RWMesh_CafReader : public RWMesh_CafReader{
    public:
        using RWMesh_CafReader::RWMesh_CafReader;


        // public pure virtual


        // protected pure virtual
        Standard_Boolean performMesh(typename std::istream & theStream, const TCollection_AsciiString & theFile, const Message_ProgressRange & theProgress, const Standard_Boolean theToProbe) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_CafReader,performMesh,theStream,theFile,theProgress,theToProbe) };


        // private pure virtual

    };
    class Py_RWMesh_MaterialMap : public RWMesh_MaterialMap{
    public:
        using RWMesh_MaterialMap::RWMesh_MaterialMap;


        // public pure virtual
        void DefineMaterial( const XCAFPrs_Style & theStyle, const TCollection_AsciiString & theKey, const TCollection_AsciiString & theName) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_MaterialMap,DefineMaterial,theStyle,theKey,theName) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_RWMesh_ShapeIterator : public RWMesh_ShapeIterator{
    public:
        using RWMesh_ShapeIterator::RWMesh_ShapeIterator;


        // public pure virtual
         const TopoDS_Shape & Shape() const  override { using return_type =  const TopoDS_Shape &;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,Shape,) };
        bool More() const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,More,) };
        void Next() override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,Next,) };
        bool IsEmpty() const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,IsEmpty,) };
        Standard_Integer ElemLower() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,ElemLower,) };
        Standard_Integer ElemUpper() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,ElemUpper,) };
        Standard_Integer NbNodes() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,NbNodes,) };
        Standard_Integer NodeLower() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,NodeLower,) };
        Standard_Integer NodeUpper() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,NodeUpper,) };


        // protected pure virtual
        gp_Pnt node( const Standard_Integer theNode) const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,node,theNode) };


        // private pure virtual

    };
    class Py_RWMesh_TriangulationReader : public RWMesh_TriangulationReader{
    public:
        using RWMesh_TriangulationReader::RWMesh_TriangulationReader;


        // public pure virtual


        // protected pure virtual
        bool load( const handle<RWMesh_TriangulationSource> & theSourceMesh, const handle<Poly_Triangulation> & theDestMesh, const handle<OSD_FileSystem> & theFileSystem) const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_TriangulationReader,load,theSourceMesh,theDestMesh,theFileSystem) };


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<RWMesh , shared_ptr<RWMesh>  >(m,"RWMesh",R"#(Auxiliary tools for RWMesh package.)#");
    py::class_<RWMesh_CoordinateSystemConverter , shared_ptr<RWMesh_CoordinateSystemConverter>  >(m,"RWMesh_CoordinateSystemConverter",R"#(Coordinate system converter defining the following tools: - Initialization for commonly used coordinate systems Z-up and Y-up. - Perform length unit conversion (scaling). - Conversion of three basic elements: a) mesh node Positions, b) mesh node Normals, c) model nodes Transformations (locations).)#");
    py::class_<RWMesh_NodeAttributes , shared_ptr<RWMesh_NodeAttributes>  >(m,"RWMesh_NodeAttributes",R"#(Attributes of the node.)#");
    py::class_<RWMesh_ShapeIterator , shared_ptr<RWMesh_ShapeIterator> ,Py_RWMesh_ShapeIterator >(m,"RWMesh_ShapeIterator",R"#(This is a virtual base class for other shape iterators. Provides an abstract interface for iterating over the elements of a shape. It defines a set of pure virtual methods that must be implemented by derived classes to handle specific types of shapes and their elements.)#");
    py::class_<RWMesh_CafReader ,opencascade::handle<RWMesh_CafReader> ,Py_RWMesh_CafReader , Standard_Transient >(m,"RWMesh_CafReader",R"#(The general interface for importing mesh data into XDE document.)#");
    py::class_<RWMesh_EdgeIterator , shared_ptr<RWMesh_EdgeIterator>  , RWMesh_ShapeIterator >(m,"RWMesh_EdgeIterator",R"#(Auxiliary class to iterate through edges. Provides functionality to iterate through the edges of a shape. It inherits from `RWMesh_ShapeIterator` and implements methods to access and manipulate edge data.)#");
    py::class_<RWMesh_FaceIterator , shared_ptr<RWMesh_FaceIterator>  , RWMesh_ShapeIterator >(m,"RWMesh_FaceIterator",R"#(Auxiliary class to iterate through triangulated faces. Class is designed to provide an interface for iterating over the faces of a shape, specifically focusing on triangulated faces. It inherits from the `RWMesh_ShapeIterator` base class and extends its functionality to handle faces with triangulation data.)#");
    py::class_<RWMesh_MaterialMap ,opencascade::handle<RWMesh_MaterialMap> ,Py_RWMesh_MaterialMap , Standard_Transient >(m,"RWMesh_MaterialMap",R"#(Material manager. Provides an interface for collecting all materials within the document before writing it into file, and for copying associated image files (textures) into sub-folder near by exported model.)#");
    preregister_template_NCollection_DataMap<TopoDS_Shape, RWMesh_NodeAttributes, TopTools_ShapeMapHasher>(m,"RWMesh_NodeAttributeMap");
    py::class_<RWMesh_TriangulationReader ,opencascade::handle<RWMesh_TriangulationReader> ,Py_RWMesh_TriangulationReader , Standard_Transient >(m,"RWMesh_TriangulationReader",R"#(Interface for reading primitive array from the buffer.)#");
    py::class_<RWMesh_TriangulationSource ,opencascade::handle<RWMesh_TriangulationSource>  , Poly_Triangulation >(m,"RWMesh_TriangulationSource",R"#(Mesh data wrapper for delayed triangulation loading. Class inherits Poly_Triangulation so that it can be put temporarily into TopoDS_Face within assembly structure.)#");
    py::class_<RWMesh_VertexIterator , shared_ptr<RWMesh_VertexIterator>  , RWMesh_ShapeIterator >(m,"RWMesh_VertexIterator",R"#(Auxiliary class to iterate through vertices. Provides functionality to iterate through the vertices of a shape. It inherits from `RWMesh_ShapeIterator` and implements methods to access and manipulate vertex data.)#");

};

// user-defined post-inclusion per module

// user-defined post
