
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationContext.hxx>
#include <DE_Provider.hxx>
#include <NCollection_Buffer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationNode.hxx>
#include <TopoDS_Shape.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationContext.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <DE_ConfigurationContext.hxx>
#include <DE_ConfigurationNode.hxx>
#include <DE_PluginHolder.hxx>
#include <DE_Provider.hxx>
#include <DE_ShapeFixConfigurationNode.hxx>
#include <DE_ShapeFixParameters.hxx>
#include <DE_Wrapper.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_DE(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("DE"));
py::object klass;

//Python trampoline classes
    class Py_DE_ConfigurationNode : public DE_ConfigurationNode{
    public:
        using DE_ConfigurationNode::DE_ConfigurationNode;


        // public pure virtual
        bool Load( const handle<DE_ConfigurationContext> & theResource) override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Load,theResource) };
        TCollection_AsciiString Save() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Save,) };
        handle<DE_Provider> BuildProvider() override { using return_type = handle<DE_Provider>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,BuildProvider,) };
        handle<DE_ConfigurationNode> Copy() const  override { using return_type = handle<DE_ConfigurationNode>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Copy,) };
        TCollection_AsciiString GetFormat() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetFormat,) };
        TCollection_AsciiString GetVendor() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetVendor,) };
        TColStd_ListOfAsciiString GetExtensions() const  override { using return_type = TColStd_ListOfAsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetExtensions,) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_DE_Provider : public DE_Provider{
    public:
        using DE_Provider::DE_Provider;


        // public pure virtual
        TCollection_AsciiString GetFormat() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_Provider,GetFormat,) };
        TCollection_AsciiString GetVendor() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_Provider,GetVendor,) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_DE_ShapeFixConfigurationNode : public DE_ShapeFixConfigurationNode{
    public:
        using DE_ShapeFixConfigurationNode::DE_ShapeFixConfigurationNode;


        // public pure virtual

        handle<DE_Provider> BuildProvider() override { using return_type = handle<DE_Provider>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,BuildProvider,) };
        handle<DE_ConfigurationNode> Copy() const  override { using return_type = handle<DE_ConfigurationNode>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Copy,) };
        TCollection_AsciiString GetFormat() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetFormat,) };
        TCollection_AsciiString GetVendor() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetVendor,) };
        TColStd_ListOfAsciiString GetExtensions() const  override { using return_type = TColStd_ListOfAsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetExtensions,) };

        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class DE_ConfigurationContext from ./opencascade/DE_ConfigurationContext.hxx
    klass = m.attr("DE_ConfigurationContext");


    // nested enums

    static_cast<py::class_<DE_ConfigurationContext ,opencascade::handle<DE_ConfigurationContext>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Load",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString &  ) ) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString &  ) >(&DE_ConfigurationContext::Load),
             R"#(Import the custom configuration Save all parameters with their values.)#"  , py::arg("theConfiguration")
          )
        .def("LoadFile",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString &  ) ) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString &  ) >(&DE_ConfigurationContext::LoadFile),
             R"#(Import the resource file. Save all parameters with their values.)#"  , py::arg("theFile")
          )
        .def("LoadStr",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString &  ) ) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString &  ) >(&DE_ConfigurationContext::LoadStr),
             R"#(Import the resource string. Save all parameters with their values.)#"  , py::arg("theResource")
          )
        .def("IsParamSet",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::IsParamSet),
             R"#(Checks for existing the parameter name)#"  , py::arg("theParam"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("GetReal",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  Standard_Real & ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  Standard_Real & ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::GetReal),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("GetInteger",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  Standard_Integer & ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  Standard_Integer & ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::GetInteger),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("GetBoolean",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  Standard_Boolean & ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  Standard_Boolean & ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::GetBoolean),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("GetString",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::GetString),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("GetStringSeq",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  TColStd_ListOfAsciiString & ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,  TColStd_ListOfAsciiString & ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::GetStringSeq),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("RealVal",
             (Standard_Real (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const Standard_Real ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Real (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const Standard_Real ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::RealVal),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theDefValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("IntegerVal",
             (Standard_Integer (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Integer (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::IntegerVal),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theDefValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("BooleanVal",
             (Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const Standard_Boolean ,   const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const Standard_Boolean ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::BooleanVal),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theDefValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("StringVal",
             (TCollection_AsciiString (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const) static_cast<TCollection_AsciiString (DE_ConfigurationContext::*)(  const TCollection_AsciiString & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const>(&DE_ConfigurationContext::StringVal),
             R"#(Gets value of parameter as being of specific type)#"  , py::arg("theParam"),  py::arg("theDefValue"),  py::arg("theScope")=static_cast< const TCollection_AsciiString &>("")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&DE_ConfigurationContext::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&DE_ConfigurationContext::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (DE_ConfigurationContext::*)() const) static_cast< const handle<Standard_Type> & (DE_ConfigurationContext::*)() const>(&DE_ConfigurationContext::DynamicType),
             R"#()#"
             
         )
       .def("GetInternalMap",
             ( const DE_ResourceMap & (DE_ConfigurationContext::*)() const) static_cast< const DE_ResourceMap & (DE_ConfigurationContext::*)() const>(&DE_ConfigurationContext::GetInternalMap),
             R"#(Gets internal resource map)#"
             
         )
;

    // Class DE_ConfigurationNode from ./opencascade/DE_ConfigurationNode.hxx
    klass = m.attr("DE_ConfigurationNode");


    // nested enums

    static_cast<py::class_<DE_ConfigurationNode ,opencascade::handle<DE_ConfigurationNode> ,Py_DE_ConfigurationNode , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<DE_ConfigurationNode> & >()  , py::arg("theConfigurationNode") )
    // custom constructors
    // methods
        .def("Load",
             (bool (DE_ConfigurationNode::*)(  const TCollection_AsciiString &  ) ) static_cast<bool (DE_ConfigurationNode::*)(  const TCollection_AsciiString &  ) >(&DE_ConfigurationNode::Load),
             R"#(Updates values according the resource file)#"  , py::arg("theResourcePath")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("Load",
             (bool (DE_ConfigurationNode::*)(  const handle<DE_ConfigurationContext> &  ) ) static_cast<bool (DE_ConfigurationNode::*)(  const handle<DE_ConfigurationContext> &  ) >(&DE_ConfigurationNode::Load),
             R"#(Updates values according the resource)#"  , py::arg("theResource")
          )
        .def("Save",
             (bool (DE_ConfigurationNode::*)(  const TCollection_AsciiString &  ) const) static_cast<bool (DE_ConfigurationNode::*)(  const TCollection_AsciiString &  ) const>(&DE_ConfigurationNode::Save),
             R"#(Writes configuration to the resource file)#"  , py::arg("theResourcePath")
          )
        .def("Save",
             (TCollection_AsciiString (DE_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::Save),
             R"#(Writes configuration to the string)#" 
          )
        .def("BuildProvider",
             (handle<DE_Provider> (DE_ConfigurationNode::*)() ) static_cast<handle<DE_Provider> (DE_ConfigurationNode::*)() >(&DE_ConfigurationNode::BuildProvider),
             R"#(Creates new provider for the own format)#" 
          )
        .def("Copy",
             (handle<DE_ConfigurationNode> (DE_ConfigurationNode::*)() const) static_cast<handle<DE_ConfigurationNode> (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::Copy),
             R"#(Copies values of all fields)#" 
          )
        .def("UpdateLoad",
             (bool (DE_ConfigurationNode::*)(  const Standard_Boolean ,   const Standard_Boolean  ) ) static_cast<bool (DE_ConfigurationNode::*)(  const Standard_Boolean ,   const Standard_Boolean  ) >(&DE_ConfigurationNode::UpdateLoad),
             R"#(Update loading status. Checking for the ability to read and write.)#"  , py::arg("theToImport"),  py::arg("theToKeep")
          )
        .def("IsImportSupported",
             (bool (DE_ConfigurationNode::*)() const) static_cast<bool (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::IsImportSupported),
             R"#(Checks the import supporting)#" 
          )
        .def("IsExportSupported",
             (bool (DE_ConfigurationNode::*)() const) static_cast<bool (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::IsExportSupported),
             R"#(Checks the export supporting)#" 
          )
        .def("GetFormat",
             (TCollection_AsciiString (DE_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (DE_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
        .def("GetExtensions",
             (TColStd_ListOfAsciiString (DE_ConfigurationNode::*)() const) static_cast<TColStd_ListOfAsciiString (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::GetExtensions),
             R"#(Gets list of supported file extensions)#" 
          )
        .def("CheckExtension",
             (bool (DE_ConfigurationNode::*)(  const TCollection_AsciiString &  ) const) static_cast<bool (DE_ConfigurationNode::*)(  const TCollection_AsciiString &  ) const>(&DE_ConfigurationNode::CheckExtension),
             R"#(Checks the file extension to verify a format)#"  , py::arg("theExtension")
          )
        .def("CheckContent",
             (bool (DE_ConfigurationNode::*)(  const handle<NCollection_Buffer> &  ) const) static_cast<bool (DE_ConfigurationNode::*)(  const handle<NCollection_Buffer> &  ) const>(&DE_ConfigurationNode::CheckContent),
             R"#(Checks the file content to verify a format)#"  , py::arg("theBuffer")
          )
        .def("IsEnabled",
             (Standard_Boolean (DE_ConfigurationNode::*)() const) static_cast<Standard_Boolean (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::IsEnabled),
             R"#(Gets the provider loading status)#" 
          )
        .def("SetEnabled",
             (void (DE_ConfigurationNode::*)(  const Standard_Boolean  ) ) static_cast<void (DE_ConfigurationNode::*)(  const Standard_Boolean  ) >(&DE_ConfigurationNode::SetEnabled),
             R"#(Sets the provider loading status)#"  , py::arg("theIsLoaded")
          )
        .def("CustomActivation",
             (void (DE_ConfigurationNode::*)(  const TColStd_ListOfAsciiString &  ) ) static_cast<void (DE_ConfigurationNode::*)(  const TColStd_ListOfAsciiString &  ) >(&DE_ConfigurationNode::CustomActivation),
             R"#(Custom function to activate commercial DE component. The input is special sequence of values that described in specific component documentation. Order is important. Each component can have own way of activation.)#"  , py::arg("arg0")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&DE_ConfigurationNode::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&DE_ConfigurationNode::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (DE_ConfigurationNode::*)() const) static_cast< const handle<Standard_Type> & (DE_ConfigurationNode::*)() const>(&DE_ConfigurationNode::DynamicType),
             R"#()#"
             
         )
;

    // Class DE_Provider from ./opencascade/DE_Provider.hxx
    klass = m.attr("DE_Provider");


    // nested enums

    static_cast<py::class_<DE_Provider ,opencascade::handle<DE_Provider> ,Py_DE_Provider , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<DE_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Read",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&DE_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&DE_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,   const Message_ProgressRange &  ) >(&DE_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Provider::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,   const Message_ProgressRange &  ) >(&DE_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("GetFormat",
             (TCollection_AsciiString (DE_Provider::*)() const) static_cast<TCollection_AsciiString (DE_Provider::*)() const>(&DE_Provider::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (DE_Provider::*)() const) static_cast<TCollection_AsciiString (DE_Provider::*)() const>(&DE_Provider::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
        .def("GetNode",
             (handle<DE_ConfigurationNode> (DE_Provider::*)() const) static_cast<handle<DE_ConfigurationNode> (DE_Provider::*)() const>(&DE_Provider::GetNode),
             R"#(Gets internal configuration node)#" 
          )
        .def("SetNode",
             (void (DE_Provider::*)(  const handle<DE_ConfigurationNode> &  ) ) static_cast<void (DE_Provider::*)(  const handle<DE_ConfigurationNode> &  ) >(&DE_Provider::SetNode),
             R"#(Sets internal configuration node)#"  , py::arg("theNode")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&DE_Provider::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&DE_Provider::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (DE_Provider::*)() const) static_cast< const handle<Standard_Type> & (DE_Provider::*)() const>(&DE_Provider::DynamicType),
             R"#()#"
             
         )
;

    // Class DE_ShapeFixParameters from ./opencascade/DE_ShapeFixParameters.hxx
    klass = m.attr("DE_ShapeFixParameters");

    // default constructor
    register_default_constructor<DE_ShapeFixParameters , shared_ptr<DE_ShapeFixParameters>>(m,"DE_ShapeFixParameters");

    // nested enums
        py::enum_<DE_ShapeFixParameters::FixMode>(klass, "FixMode_e", R"#(Enum, classifying a type of value for parameters)#")
            .value("FixOrNot", DE_ShapeFixParameters::FixMode::FixOrNot)
            .value("NotFix", DE_ShapeFixParameters::FixMode::NotFix)
            .value("Fix", DE_ShapeFixParameters::FixMode::Fix).export_values();

    static_cast<py::class_<DE_ShapeFixParameters , shared_ptr<DE_ShapeFixParameters>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("DetalizationLevel", &DE_ShapeFixParameters::DetalizationLevel)
    // methods returning by ref wrapped as properties
;

    // Class DE_Wrapper from ./opencascade/DE_Wrapper.hxx
    klass = m.attr("DE_Wrapper");


    // nested enums

    static_cast<py::class_<DE_Wrapper ,opencascade::handle<DE_Wrapper>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<DE_Wrapper> & >()  , py::arg("theWrapper") )
    // custom constructors
    // methods
        .def("Read",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,  handle<XSControl_WorkSession> & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,  TopoDS_Shape & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TopoDS_Shape & ,   const Message_ProgressRange &  ) >(&DE_Wrapper::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Load",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const Standard_Boolean  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const Standard_Boolean  ) >(&DE_Wrapper::Load),
             R"#(Updates values according the resource file)#"  , py::arg("theResource")=static_cast< const TCollection_AsciiString &>(""),  py::arg("theIsRecursive")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("Load",
             (Standard_Boolean (DE_Wrapper::*)(  const handle<DE_ConfigurationContext> & ,   const Standard_Boolean  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const handle<DE_ConfigurationContext> & ,   const Standard_Boolean  ) >(&DE_Wrapper::Load),
             R"#(Updates values according the resource)#"  , py::arg("theResource"),  py::arg("theIsRecursive")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("Save",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const Standard_Boolean ,   const TColStd_ListOfAsciiString & ,   const TColStd_ListOfAsciiString &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const Standard_Boolean ,   const TColStd_ListOfAsciiString & ,   const TColStd_ListOfAsciiString &  ) >(&DE_Wrapper::Save),
             R"#(Writes configuration to the resource file)#"  , py::arg("theResourcePath"),  py::arg("theIsRecursive")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("theFormats")=static_cast< const TColStd_ListOfAsciiString &>(TColStd_ListOfAsciiString ( )),  py::arg("theVendors")=static_cast< const TColStd_ListOfAsciiString &>(TColStd_ListOfAsciiString ( ))
          )
        .def("Save",
             (TCollection_AsciiString (DE_Wrapper::*)(  const Standard_Boolean ,   const TColStd_ListOfAsciiString & ,   const TColStd_ListOfAsciiString &  ) ) static_cast<TCollection_AsciiString (DE_Wrapper::*)(  const Standard_Boolean ,   const TColStd_ListOfAsciiString & ,   const TColStd_ListOfAsciiString &  ) >(&DE_Wrapper::Save),
             R"#(Writes configuration to the string)#"  , py::arg("theIsRecursive")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("theFormats")=static_cast< const TColStd_ListOfAsciiString &>(TColStd_ListOfAsciiString ( )),  py::arg("theVendors")=static_cast< const TColStd_ListOfAsciiString &>(TColStd_ListOfAsciiString ( ))
          )
        .def("Bind",
             (Standard_Boolean (DE_Wrapper::*)(  const handle<DE_ConfigurationNode> &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const handle<DE_ConfigurationNode> &  ) >(&DE_Wrapper::Bind),
             R"#(Creates new node copy and adds to the map)#"  , py::arg("theNode")
          )
        .def("UnBind",
             (Standard_Boolean (DE_Wrapper::*)(  const handle<DE_ConfigurationNode> &  ) ) static_cast<Standard_Boolean (DE_Wrapper::*)(  const handle<DE_ConfigurationNode> &  ) >(&DE_Wrapper::UnBind),
             R"#(Removes node with the same type from the map)#"  , py::arg("theNode")
          )
        .def("Find",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TCollection_AsciiString & ,  handle<DE_ConfigurationNode> &  ) const) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TCollection_AsciiString & ,  handle<DE_ConfigurationNode> &  ) const>(&DE_Wrapper::Find),
             R"#(Finds a node associated with input format and vendor)#"  , py::arg("theFormat"),  py::arg("theVendor"),  py::arg("theNode")
          )
        .def("ChangePriority",
             (void (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TColStd_ListOfAsciiString & ,   const Standard_Boolean  ) ) static_cast<void (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const TColStd_ListOfAsciiString & ,   const Standard_Boolean  ) >(&DE_Wrapper::ChangePriority),
             R"#(Changes provider priority to one format if it exists)#"  , py::arg("theFormat"),  py::arg("theVendorPriority"),  py::arg("theToDisable")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("ChangePriority",
             (void (DE_Wrapper::*)(  const TColStd_ListOfAsciiString & ,   const Standard_Boolean  ) ) static_cast<void (DE_Wrapper::*)(  const TColStd_ListOfAsciiString & ,   const Standard_Boolean  ) >(&DE_Wrapper::ChangePriority),
             R"#(Changes provider priority to all loaded nodes)#"  , py::arg("theVendorPriority"),  py::arg("theToDisable")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("FindProvider",
             (Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const Standard_Boolean ,  handle<DE_Provider> &  ) const) static_cast<Standard_Boolean (DE_Wrapper::*)(  const TCollection_AsciiString & ,   const Standard_Boolean ,  handle<DE_Provider> &  ) const>(&DE_Wrapper::FindProvider),
             R"#(Find available provider from the configuration. If there are several providers, choose the one with the highest priority.)#"  , py::arg("thePath"),  py::arg("theToImport"),  py::arg("theProvider")
          )
        .def("UpdateLoad",
             (void (DE_Wrapper::*)(  const Standard_Boolean  ) const) static_cast<void (DE_Wrapper::*)(  const Standard_Boolean  ) const>(&DE_Wrapper::UpdateLoad),
             R"#(Updates all registered nodes, all changes will be saved in nodes)#"  , py::arg("theToForceUpdate")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("KeepUpdates",
             (Standard_Boolean (DE_Wrapper::*)() const) static_cast<Standard_Boolean (DE_Wrapper::*)() const>(&DE_Wrapper::KeepUpdates),
             R"#(Gets flag that keeps changes on configuration nodes which are being updated, false by default)#" 
          )
        .def("SetKeepUpdates",
             (void (DE_Wrapper::*)(  const Standard_Boolean  ) ) static_cast<void (DE_Wrapper::*)(  const Standard_Boolean  ) >(&DE_Wrapper::SetKeepUpdates),
             R"#(Sets flag that keeps changes on configuration nodes which are being updated, false by default)#"  , py::arg("theToKeepUpdates")
          )
        .def("Copy",
             (handle<DE_Wrapper> (DE_Wrapper::*)() const) static_cast<handle<DE_Wrapper> (DE_Wrapper::*)() const>(&DE_Wrapper::Copy),
             R"#(Copies values of all fields)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&DE_Wrapper::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&DE_Wrapper::get_type_descriptor),
                    R"#()#" 
          )
        .def_static("GlobalWrapper_s",
                    ( const handle<DE_Wrapper> & (*)() ) static_cast< const handle<DE_Wrapper> & (*)() >(&DE_Wrapper::GlobalWrapper),
                    R"#(Gets global configuration singleton. If wrapper is not set, create it by default as base class object.)#" 
          )
        .def_static("SetGlobalWrapper_s",
                    (void (*)(  const handle<DE_Wrapper> &  ) ) static_cast<void (*)(  const handle<DE_Wrapper> &  ) >(&DE_Wrapper::SetGlobalWrapper),
                    R"#(Sets global configuration singleton)#"  , py::arg("theWrapper")
          )
        .def_static("GlobalLoadMutex_s",
                    (Standard_Mutex & (*)() ) static_cast<Standard_Mutex & (*)() >(&DE_Wrapper::GlobalLoadMutex),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (DE_Wrapper::*)() const) static_cast< const handle<Standard_Type> & (DE_Wrapper::*)() const>(&DE_Wrapper::DynamicType),
             R"#()#"
             
         )
       .def("Nodes",
             ( const DE_ConfigurationFormatMap & (DE_Wrapper::*)() const) static_cast< const DE_ConfigurationFormatMap & (DE_Wrapper::*)() const>(&DE_Wrapper::Nodes),
             R"#(Gets format map, contains vendor map with nodes)#"
             
         )
;

    // Class DE_ShapeFixConfigurationNode from ./opencascade/DE_ShapeFixConfigurationNode.hxx
    klass = m.attr("DE_ShapeFixConfigurationNode");


    // nested enums

    static_cast<py::class_<DE_ShapeFixConfigurationNode ,opencascade::handle<DE_ShapeFixConfigurationNode> ,Py_DE_ShapeFixConfigurationNode , DE_ConfigurationNode >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<DE_ShapeFixConfigurationNode> & >()  , py::arg("theConfigurationNode") )
    // custom constructors
    // methods
        .def("Load",
             (bool (DE_ShapeFixConfigurationNode::*)(  const handle<DE_ConfigurationContext> &  ) ) static_cast<bool (DE_ShapeFixConfigurationNode::*)(  const handle<DE_ConfigurationContext> &  ) >(&DE_ShapeFixConfigurationNode::Load),
             R"#(Updates values according the resource)#"  , py::arg("theResource")
          )
        .def("Save",
             (TCollection_AsciiString (DE_ShapeFixConfigurationNode::*)() const) static_cast<TCollection_AsciiString (DE_ShapeFixConfigurationNode::*)() const>(&DE_ShapeFixConfigurationNode::Save),
             R"#(Writes configuration to the string)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&DE_ShapeFixConfigurationNode::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&DE_ShapeFixConfigurationNode::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("ShapeFixParameters", &DE_ShapeFixConfigurationNode::ShapeFixParameters)
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (DE_ShapeFixConfigurationNode::*)() const) static_cast< const handle<Standard_Type> & (DE_ShapeFixConfigurationNode::*)() const>(&DE_ShapeFixConfigurationNode::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/DE_ConfigurationContext.hxx
// ./opencascade/DE_ConfigurationNode.hxx
// ./opencascade/DE_PluginHolder.hxx
// ./opencascade/DE_Provider.hxx
// ./opencascade/DE_ShapeFixConfigurationNode.hxx
// ./opencascade/DE_ShapeFixParameters.hxx
// ./opencascade/DE_Wrapper.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
