// Copyright 2023, The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

use zerocopy::{AsBytes, FromBytes, FromZeroes};

/* automatically generated by rust-bindgen 0.65.1 */

pub const BOOT_MAGIC: &[u8; 9usize] = b"ANDROID!\0";
pub const BOOT_MAGIC_SIZE: u32 = 8;
pub const BOOT_NAME_SIZE: u32 = 16;
pub const BOOT_ARGS_SIZE: u32 = 512;
pub const BOOT_EXTRA_ARGS_SIZE: u32 = 1024;
pub const VENDOR_BOOT_MAGIC: &[u8; 9usize] = b"VNDRBOOT\0";
pub const VENDOR_BOOT_MAGIC_SIZE: u32 = 8;
pub const VENDOR_BOOT_ARGS_SIZE: u32 = 2048;
pub const VENDOR_BOOT_NAME_SIZE: u32 = 16;
pub const VENDOR_RAMDISK_TYPE_NONE: u32 = 0;
pub const VENDOR_RAMDISK_TYPE_PLATFORM: u32 = 1;
pub const VENDOR_RAMDISK_TYPE_RECOVERY: u32 = 2;
pub const VENDOR_RAMDISK_TYPE_DLKM: u32 = 3;
pub const VENDOR_RAMDISK_NAME_SIZE: u32 = 32;
pub const VENDOR_RAMDISK_TABLE_ENTRY_BOARD_ID_SIZE: u32 = 16;
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct boot_img_hdr_v0 {
    pub magic: [u8; 8usize],
    pub kernel_size: u32,
    pub kernel_addr: u32,
    pub ramdisk_size: u32,
    pub ramdisk_addr: u32,
    pub second_size: u32,
    pub second_addr: u32,
    pub tags_addr: u32,
    pub page_size: u32,
    pub header_version: u32,
    pub os_version: u32,
    pub name: [u8; 16usize],
    pub cmdline: [u8; 512usize],
    pub id: [u32; 8usize],
    pub extra_cmdline: [u8; 1024usize],
}
#[test]
fn bindgen_test_layout_boot_img_hdr_v0() {
    const UNINIT: ::core::mem::MaybeUninit<boot_img_hdr_v0> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<boot_img_hdr_v0>(),
        1632usize,
        concat!("Size of: ", stringify!(boot_img_hdr_v0))
    );
    assert_eq!(
        ::core::mem::align_of::<boot_img_hdr_v0>(),
        1usize,
        concat!("Alignment of ", stringify!(boot_img_hdr_v0))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(magic))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kernel_size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(kernel_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kernel_addr) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(kernel_addr))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_size) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(ramdisk_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_addr) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(ramdisk_addr))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).second_size) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(second_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).second_addr) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(second_addr))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tags_addr) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(tags_addr))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).page_size) as usize - ptr as usize },
        36usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(page_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header_version) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(header_version))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).os_version) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(os_version))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(name))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cmdline) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(cmdline))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        576usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(id))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).extra_cmdline) as usize - ptr as usize },
        608usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v0), "::", stringify!(extra_cmdline))
    );
}
impl Default for boot_img_hdr_v0 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type boot_img_hdr = boot_img_hdr_v0;
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct boot_img_hdr_v1 {
    pub _base: boot_img_hdr_v0,
    pub recovery_dtbo_size: u32,
    pub recovery_dtbo_offset: u64,
    pub header_size: u32,
}
#[test]
fn bindgen_test_layout_boot_img_hdr_v1() {
    const UNINIT: ::core::mem::MaybeUninit<boot_img_hdr_v1> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<boot_img_hdr_v1>(),
        1648usize,
        concat!("Size of: ", stringify!(boot_img_hdr_v1))
    );
    assert_eq!(
        ::core::mem::align_of::<boot_img_hdr_v1>(),
        1usize,
        concat!("Alignment of ", stringify!(boot_img_hdr_v1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).recovery_dtbo_size) as usize - ptr as usize },
        1632usize,
        concat!(
            "Offset of field: ",
            stringify!(boot_img_hdr_v1),
            "::",
            stringify!(recovery_dtbo_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).recovery_dtbo_offset) as usize - ptr as usize },
        1636usize,
        concat!(
            "Offset of field: ",
            stringify!(boot_img_hdr_v1),
            "::",
            stringify!(recovery_dtbo_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header_size) as usize - ptr as usize },
        1644usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v1), "::", stringify!(header_size))
    );
}
impl Default for boot_img_hdr_v1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct boot_img_hdr_v2 {
    pub _base: boot_img_hdr_v1,
    pub dtb_size: u32,
    pub dtb_addr: u64,
}
#[test]
fn bindgen_test_layout_boot_img_hdr_v2() {
    const UNINIT: ::core::mem::MaybeUninit<boot_img_hdr_v2> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<boot_img_hdr_v2>(),
        1660usize,
        concat!("Size of: ", stringify!(boot_img_hdr_v2))
    );
    assert_eq!(
        ::core::mem::align_of::<boot_img_hdr_v2>(),
        1usize,
        concat!("Alignment of ", stringify!(boot_img_hdr_v2))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dtb_size) as usize - ptr as usize },
        1648usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v2), "::", stringify!(dtb_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dtb_addr) as usize - ptr as usize },
        1652usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v2), "::", stringify!(dtb_addr))
    );
}
impl Default for boot_img_hdr_v2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct boot_img_hdr_v3 {
    pub magic: [u8; 8usize],
    pub kernel_size: u32,
    pub ramdisk_size: u32,
    pub os_version: u32,
    pub header_size: u32,
    pub reserved: [u32; 4usize],
    pub header_version: u32,
    pub cmdline: [u8; 1536usize],
}
#[test]
fn bindgen_test_layout_boot_img_hdr_v3() {
    const UNINIT: ::core::mem::MaybeUninit<boot_img_hdr_v3> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<boot_img_hdr_v3>(),
        1580usize,
        concat!("Size of: ", stringify!(boot_img_hdr_v3))
    );
    assert_eq!(
        ::core::mem::align_of::<boot_img_hdr_v3>(),
        1usize,
        concat!("Alignment of ", stringify!(boot_img_hdr_v3))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(magic))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kernel_size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(kernel_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_size) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(ramdisk_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).os_version) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(os_version))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header_size) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(header_size))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(reserved))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header_version) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(header_version))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cmdline) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v3), "::", stringify!(cmdline))
    );
}
impl Default for boot_img_hdr_v3 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct vendor_boot_img_hdr_v3 {
    pub magic: [u8; 8usize],
    pub header_version: u32,
    pub page_size: u32,
    pub kernel_addr: u32,
    pub ramdisk_addr: u32,
    pub vendor_ramdisk_size: u32,
    pub cmdline: [u8; 2048usize],
    pub tags_addr: u32,
    pub name: [u8; 16usize],
    pub header_size: u32,
    pub dtb_size: u32,
    pub dtb_addr: u64,
}
#[test]
fn bindgen_test_layout_vendor_boot_img_hdr_v3() {
    const UNINIT: ::core::mem::MaybeUninit<vendor_boot_img_hdr_v3> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vendor_boot_img_hdr_v3>(),
        2112usize,
        concat!("Size of: ", stringify!(vendor_boot_img_hdr_v3))
    );
    assert_eq!(
        ::core::mem::align_of::<vendor_boot_img_hdr_v3>(),
        1usize,
        concat!("Alignment of ", stringify!(vendor_boot_img_hdr_v3))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(vendor_boot_img_hdr_v3), "::", stringify!(magic))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header_version) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(header_version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).page_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(page_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kernel_addr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(kernel_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_addr) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(ramdisk_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vendor_ramdisk_size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(vendor_ramdisk_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cmdline) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(vendor_boot_img_hdr_v3), "::", stringify!(cmdline))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tags_addr) as usize - ptr as usize },
        2076usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(tags_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        2080usize,
        concat!("Offset of field: ", stringify!(vendor_boot_img_hdr_v3), "::", stringify!(name))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header_size) as usize - ptr as usize },
        2096usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(header_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dtb_size) as usize - ptr as usize },
        2100usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(dtb_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dtb_addr) as usize - ptr as usize },
        2104usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v3),
            "::",
            stringify!(dtb_addr)
        )
    );
}
impl Default for vendor_boot_img_hdr_v3 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct boot_img_hdr_v4 {
    pub _base: boot_img_hdr_v3,
    pub signature_size: u32,
}
#[test]
fn bindgen_test_layout_boot_img_hdr_v4() {
    const UNINIT: ::core::mem::MaybeUninit<boot_img_hdr_v4> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<boot_img_hdr_v4>(),
        1584usize,
        concat!("Size of: ", stringify!(boot_img_hdr_v4))
    );
    assert_eq!(
        ::core::mem::align_of::<boot_img_hdr_v4>(),
        1usize,
        concat!("Alignment of ", stringify!(boot_img_hdr_v4))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).signature_size) as usize - ptr as usize },
        1580usize,
        concat!("Offset of field: ", stringify!(boot_img_hdr_v4), "::", stringify!(signature_size))
    );
}
impl Default for boot_img_hdr_v4 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct vendor_boot_img_hdr_v4 {
    pub _base: vendor_boot_img_hdr_v3,
    pub vendor_ramdisk_table_size: u32,
    pub vendor_ramdisk_table_entry_num: u32,
    pub vendor_ramdisk_table_entry_size: u32,
    pub bootconfig_size: u32,
}
#[test]
fn bindgen_test_layout_vendor_boot_img_hdr_v4() {
    const UNINIT: ::core::mem::MaybeUninit<vendor_boot_img_hdr_v4> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vendor_boot_img_hdr_v4>(),
        2128usize,
        concat!("Size of: ", stringify!(vendor_boot_img_hdr_v4))
    );
    assert_eq!(
        ::core::mem::align_of::<vendor_boot_img_hdr_v4>(),
        1usize,
        concat!("Alignment of ", stringify!(vendor_boot_img_hdr_v4))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vendor_ramdisk_table_size) as usize - ptr as usize },
        2112usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v4),
            "::",
            stringify!(vendor_ramdisk_table_size)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).vendor_ramdisk_table_entry_num) as usize - ptr as usize
        },
        2116usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v4),
            "::",
            stringify!(vendor_ramdisk_table_entry_num)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).vendor_ramdisk_table_entry_size) as usize - ptr as usize
        },
        2120usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v4),
            "::",
            stringify!(vendor_ramdisk_table_entry_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bootconfig_size) as usize - ptr as usize },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_boot_img_hdr_v4),
            "::",
            stringify!(bootconfig_size)
        )
    );
}
impl Default for vendor_boot_img_hdr_v4 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
#[derive(AsBytes, FromBytes, FromZeroes, PartialEq, Copy, Clone, Debug)]
pub struct vendor_ramdisk_table_entry_v4 {
    pub ramdisk_size: u32,
    pub ramdisk_offset: u32,
    pub ramdisk_type: u32,
    pub ramdisk_name: [u8; 32usize],
    pub board_id: [u32; 16usize],
}
#[test]
fn bindgen_test_layout_vendor_ramdisk_table_entry_v4() {
    const UNINIT: ::core::mem::MaybeUninit<vendor_ramdisk_table_entry_v4> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vendor_ramdisk_table_entry_v4>(),
        108usize,
        concat!("Size of: ", stringify!(vendor_ramdisk_table_entry_v4))
    );
    assert_eq!(
        ::core::mem::align_of::<vendor_ramdisk_table_entry_v4>(),
        1usize,
        concat!("Alignment of ", stringify!(vendor_ramdisk_table_entry_v4))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_ramdisk_table_entry_v4),
            "::",
            stringify!(ramdisk_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_ramdisk_table_entry_v4),
            "::",
            stringify!(ramdisk_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_type) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_ramdisk_table_entry_v4),
            "::",
            stringify!(ramdisk_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ramdisk_name) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_ramdisk_table_entry_v4),
            "::",
            stringify!(ramdisk_name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).board_id) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(vendor_ramdisk_table_entry_v4),
            "::",
            stringify!(board_id)
        )
    );
}
impl Default for vendor_ramdisk_table_entry_v4 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
