// This file is @generated by src/hir_type/gen_hir_type.rb.
mod bits {
  pub const Any: u64 = CValue | RubyValue;
  pub const Array: u64 = ArrayExact | ArraySubclass;
  pub const ArrayExact: u64 = 1u64 << 0;
  pub const ArraySubclass: u64 = 1u64 << 1;
  pub const BasicObject: u64 = BasicObjectExact | BasicObjectSubclass | Object;
  pub const BasicObjectExact: u64 = 1u64 << 2;
  pub const BasicObjectSubclass: u64 = 1u64 << 3;
  pub const Bignum: u64 = 1u64 << 4;
  pub const BoolExact: u64 = FalseClass | TrueClass;
  pub const BuiltinExact: u64 = ArrayExact | BasicObjectExact | Class | FalseClass | Float | HashExact | Integer | ModuleExact | NilClass | NumericExact | ObjectExact | RangeExact | RegexpExact | SetExact | StringExact | Symbol | TrueClass;
  pub const CBool: u64 = 1u64 << 5;
  pub const CDouble: u64 = 1u64 << 6;
  pub const CInt: u64 = CSigned | CUnsigned;
  pub const CInt16: u64 = 1u64 << 7;
  pub const CInt32: u64 = 1u64 << 8;
  pub const CInt64: u64 = 1u64 << 9;
  pub const CInt8: u64 = 1u64 << 10;
  pub const CNull: u64 = 1u64 << 11;
  pub const CPtr: u64 = 1u64 << 12;
  pub const CShape: u64 = 1u64 << 13;
  pub const CSigned: u64 = CInt16 | CInt32 | CInt64 | CInt8;
  pub const CUInt16: u64 = 1u64 << 14;
  pub const CUInt32: u64 = 1u64 << 15;
  pub const CUInt64: u64 = 1u64 << 16;
  pub const CUInt8: u64 = 1u64 << 17;
  pub const CUnsigned: u64 = CShape | CUInt16 | CUInt32 | CUInt64 | CUInt8;
  pub const CValue: u64 = CBool | CDouble | CInt | CNull | CPtr;
  pub const CallableMethodEntry: u64 = 1u64 << 18;
  pub const Class: u64 = 1u64 << 19;
  pub const DynamicSymbol: u64 = 1u64 << 20;
  pub const Empty: u64 = 0u64;
  pub const FalseClass: u64 = 1u64 << 21;
  pub const Fixnum: u64 = 1u64 << 22;
  pub const Float: u64 = Flonum | HeapFloat;
  pub const Flonum: u64 = 1u64 << 23;
  pub const Hash: u64 = HashExact | HashSubclass;
  pub const HashExact: u64 = 1u64 << 24;
  pub const HashSubclass: u64 = 1u64 << 25;
  pub const HeapBasicObject: u64 = BasicObject & !Immediate;
  pub const HeapFloat: u64 = 1u64 << 26;
  pub const HeapObject: u64 = Object & !Immediate;
  pub const Immediate: u64 = FalseClass | Fixnum | Flonum | NilClass | StaticSymbol | TrueClass | Undef;
  pub const Integer: u64 = Bignum | Fixnum;
  pub const Module: u64 = Class | ModuleExact | ModuleSubclass;
  pub const ModuleExact: u64 = 1u64 << 27;
  pub const ModuleSubclass: u64 = 1u64 << 28;
  pub const NilClass: u64 = 1u64 << 29;
  pub const Numeric: u64 = Float | Integer | NumericExact | NumericSubclass;
  pub const NumericExact: u64 = 1u64 << 30;
  pub const NumericSubclass: u64 = 1u64 << 31;
  pub const Object: u64 = Array | FalseClass | Hash | Module | NilClass | Numeric | ObjectExact | ObjectSubclass | Range | Regexp | Set | String | Symbol | TrueClass;
  pub const ObjectExact: u64 = 1u64 << 32;
  pub const ObjectSubclass: u64 = 1u64 << 33;
  pub const Range: u64 = RangeExact | RangeSubclass;
  pub const RangeExact: u64 = 1u64 << 34;
  pub const RangeSubclass: u64 = 1u64 << 35;
  pub const Regexp: u64 = RegexpExact | RegexpSubclass;
  pub const RegexpExact: u64 = 1u64 << 36;
  pub const RegexpSubclass: u64 = 1u64 << 37;
  pub const RubyValue: u64 = BasicObject | CallableMethodEntry | Undef;
  pub const Set: u64 = SetExact | SetSubclass;
  pub const SetExact: u64 = 1u64 << 38;
  pub const SetSubclass: u64 = 1u64 << 39;
  pub const StaticSymbol: u64 = 1u64 << 40;
  pub const String: u64 = StringExact | StringSubclass;
  pub const StringExact: u64 = 1u64 << 41;
  pub const StringSubclass: u64 = 1u64 << 42;
  pub const Subclass: u64 = ArraySubclass | BasicObjectSubclass | HashSubclass | ModuleSubclass | NumericSubclass | ObjectSubclass | RangeSubclass | RegexpSubclass | SetSubclass | StringSubclass;
  pub const Symbol: u64 = DynamicSymbol | StaticSymbol;
  pub const TrueClass: u64 = 1u64 << 43;
  pub const Undef: u64 = 1u64 << 44;
  pub const AllBitPatterns: [(&str, u64); 71] = [
    ("Any", Any),
    ("RubyValue", RubyValue),
    ("Immediate", Immediate),
    ("Undef", Undef),
    ("BasicObject", BasicObject),
    ("Object", Object),
    ("BuiltinExact", BuiltinExact),
    ("BoolExact", BoolExact),
    ("TrueClass", TrueClass),
    ("HeapBasicObject", HeapBasicObject),
    ("HeapObject", HeapObject),
    ("String", String),
    ("Subclass", Subclass),
    ("StringSubclass", StringSubclass),
    ("StringExact", StringExact),
    ("Symbol", Symbol),
    ("StaticSymbol", StaticSymbol),
    ("Set", Set),
    ("SetSubclass", SetSubclass),
    ("SetExact", SetExact),
    ("Regexp", Regexp),
    ("RegexpSubclass", RegexpSubclass),
    ("RegexpExact", RegexpExact),
    ("Range", Range),
    ("RangeSubclass", RangeSubclass),
    ("RangeExact", RangeExact),
    ("ObjectSubclass", ObjectSubclass),
    ("ObjectExact", ObjectExact),
    ("Numeric", Numeric),
    ("NumericSubclass", NumericSubclass),
    ("NumericExact", NumericExact),
    ("NilClass", NilClass),
    ("Module", Module),
    ("ModuleSubclass", ModuleSubclass),
    ("ModuleExact", ModuleExact),
    ("Float", Float),
    ("HeapFloat", HeapFloat),
    ("Hash", Hash),
    ("HashSubclass", HashSubclass),
    ("HashExact", HashExact),
    ("Flonum", Flonum),
    ("Integer", Integer),
    ("Fixnum", Fixnum),
    ("FalseClass", FalseClass),
    ("DynamicSymbol", DynamicSymbol),
    ("Class", Class),
    ("CallableMethodEntry", CallableMethodEntry),
    ("CValue", CValue),
    ("CInt", CInt),
    ("CUnsigned", CUnsigned),
    ("CUInt8", CUInt8),
    ("CUInt64", CUInt64),
    ("CUInt32", CUInt32),
    ("CUInt16", CUInt16),
    ("CShape", CShape),
    ("CPtr", CPtr),
    ("CNull", CNull),
    ("CSigned", CSigned),
    ("CInt8", CInt8),
    ("CInt64", CInt64),
    ("CInt32", CInt32),
    ("CInt16", CInt16),
    ("CDouble", CDouble),
    ("CBool", CBool),
    ("Bignum", Bignum),
    ("BasicObjectSubclass", BasicObjectSubclass),
    ("BasicObjectExact", BasicObjectExact),
    ("Array", Array),
    ("ArraySubclass", ArraySubclass),
    ("ArrayExact", ArrayExact),
    ("Empty", Empty),
  ];
  pub const NumTypeBits: u64 = 45;
}
pub mod types {
  use super::*;
  pub const Any: Type = Type::from_bits(bits::Any);
  pub const Array: Type = Type::from_bits(bits::Array);
  pub const ArrayExact: Type = Type::from_bits(bits::ArrayExact);
  pub const ArraySubclass: Type = Type::from_bits(bits::ArraySubclass);
  pub const BasicObject: Type = Type::from_bits(bits::BasicObject);
  pub const BasicObjectExact: Type = Type::from_bits(bits::BasicObjectExact);
  pub const BasicObjectSubclass: Type = Type::from_bits(bits::BasicObjectSubclass);
  pub const Bignum: Type = Type::from_bits(bits::Bignum);
  pub const BoolExact: Type = Type::from_bits(bits::BoolExact);
  pub const BuiltinExact: Type = Type::from_bits(bits::BuiltinExact);
  pub const CBool: Type = Type::from_bits(bits::CBool);
  pub const CDouble: Type = Type::from_bits(bits::CDouble);
  pub const CInt: Type = Type::from_bits(bits::CInt);
  pub const CInt16: Type = Type::from_bits(bits::CInt16);
  pub const CInt32: Type = Type::from_bits(bits::CInt32);
  pub const CInt64: Type = Type::from_bits(bits::CInt64);
  pub const CInt8: Type = Type::from_bits(bits::CInt8);
  pub const CNull: Type = Type::from_bits(bits::CNull);
  pub const CPtr: Type = Type::from_bits(bits::CPtr);
  pub const CShape: Type = Type::from_bits(bits::CShape);
  pub const CSigned: Type = Type::from_bits(bits::CSigned);
  pub const CUInt16: Type = Type::from_bits(bits::CUInt16);
  pub const CUInt32: Type = Type::from_bits(bits::CUInt32);
  pub const CUInt64: Type = Type::from_bits(bits::CUInt64);
  pub const CUInt8: Type = Type::from_bits(bits::CUInt8);
  pub const CUnsigned: Type = Type::from_bits(bits::CUnsigned);
  pub const CValue: Type = Type::from_bits(bits::CValue);
  pub const CallableMethodEntry: Type = Type::from_bits(bits::CallableMethodEntry);
  pub const Class: Type = Type::from_bits(bits::Class);
  pub const DynamicSymbol: Type = Type::from_bits(bits::DynamicSymbol);
  pub const Empty: Type = Type::from_bits(bits::Empty);
  pub const FalseClass: Type = Type::from_bits(bits::FalseClass);
  pub const Fixnum: Type = Type::from_bits(bits::Fixnum);
  pub const Float: Type = Type::from_bits(bits::Float);
  pub const Flonum: Type = Type::from_bits(bits::Flonum);
  pub const Hash: Type = Type::from_bits(bits::Hash);
  pub const HashExact: Type = Type::from_bits(bits::HashExact);
  pub const HashSubclass: Type = Type::from_bits(bits::HashSubclass);
  pub const HeapBasicObject: Type = Type::from_bits(bits::HeapBasicObject);
  pub const HeapFloat: Type = Type::from_bits(bits::HeapFloat);
  pub const HeapObject: Type = Type::from_bits(bits::HeapObject);
  pub const Immediate: Type = Type::from_bits(bits::Immediate);
  pub const Integer: Type = Type::from_bits(bits::Integer);
  pub const Module: Type = Type::from_bits(bits::Module);
  pub const ModuleExact: Type = Type::from_bits(bits::ModuleExact);
  pub const ModuleSubclass: Type = Type::from_bits(bits::ModuleSubclass);
  pub const NilClass: Type = Type::from_bits(bits::NilClass);
  pub const Numeric: Type = Type::from_bits(bits::Numeric);
  pub const NumericExact: Type = Type::from_bits(bits::NumericExact);
  pub const NumericSubclass: Type = Type::from_bits(bits::NumericSubclass);
  pub const Object: Type = Type::from_bits(bits::Object);
  pub const ObjectExact: Type = Type::from_bits(bits::ObjectExact);
  pub const ObjectSubclass: Type = Type::from_bits(bits::ObjectSubclass);
  pub const Range: Type = Type::from_bits(bits::Range);
  pub const RangeExact: Type = Type::from_bits(bits::RangeExact);
  pub const RangeSubclass: Type = Type::from_bits(bits::RangeSubclass);
  pub const Regexp: Type = Type::from_bits(bits::Regexp);
  pub const RegexpExact: Type = Type::from_bits(bits::RegexpExact);
  pub const RegexpSubclass: Type = Type::from_bits(bits::RegexpSubclass);
  pub const RubyValue: Type = Type::from_bits(bits::RubyValue);
  pub const Set: Type = Type::from_bits(bits::Set);
  pub const SetExact: Type = Type::from_bits(bits::SetExact);
  pub const SetSubclass: Type = Type::from_bits(bits::SetSubclass);
  pub const StaticSymbol: Type = Type::from_bits(bits::StaticSymbol);
  pub const String: Type = Type::from_bits(bits::String);
  pub const StringExact: Type = Type::from_bits(bits::StringExact);
  pub const StringSubclass: Type = Type::from_bits(bits::StringSubclass);
  pub const Subclass: Type = Type::from_bits(bits::Subclass);
  pub const Symbol: Type = Type::from_bits(bits::Symbol);
  pub const TrueClass: Type = Type::from_bits(bits::TrueClass);
  pub const Undef: Type = Type::from_bits(bits::Undef);
  pub const ExactBitsAndClass: [(u64, *const VALUE); 17] = [
    (bits::ObjectExact, &raw const crate::cruby::rb_cObject),
    (bits::BasicObjectExact, &raw const crate::cruby::rb_cBasicObject),
    (bits::StringExact, &raw const crate::cruby::rb_cString),
    (bits::ArrayExact, &raw const crate::cruby::rb_cArray),
    (bits::HashExact, &raw const crate::cruby::rb_cHash),
    (bits::RangeExact, &raw const crate::cruby::rb_cRange),
    (bits::SetExact, &raw const crate::cruby::rb_cSet),
    (bits::RegexpExact, &raw const crate::cruby::rb_cRegexp),
    (bits::ModuleExact, &raw const crate::cruby::rb_cModule),
    (bits::Class, &raw const crate::cruby::rb_cClass),
    (bits::NumericExact, &raw const crate::cruby::rb_cNumeric),
    (bits::Integer, &raw const crate::cruby::rb_cInteger),
    (bits::Float, &raw const crate::cruby::rb_cFloat),
    (bits::Symbol, &raw const crate::cruby::rb_cSymbol),
    (bits::NilClass, &raw const crate::cruby::rb_cNilClass),
    (bits::TrueClass, &raw const crate::cruby::rb_cTrueClass),
    (bits::FalseClass, &raw const crate::cruby::rb_cFalseClass),
  ];
  pub const InexactBitsAndClass: [(u64, *const VALUE); 10] = [
    (bits::ArraySubclass, &raw const crate::cruby::rb_cArray),
    (bits::HashSubclass, &raw const crate::cruby::rb_cHash),
    (bits::ModuleSubclass, &raw const crate::cruby::rb_cModule),
    (bits::NumericSubclass, &raw const crate::cruby::rb_cNumeric),
    (bits::RangeSubclass, &raw const crate::cruby::rb_cRange),
    (bits::RegexpSubclass, &raw const crate::cruby::rb_cRegexp),
    (bits::SetSubclass, &raw const crate::cruby::rb_cSet),
    (bits::StringSubclass, &raw const crate::cruby::rb_cString),
    (bits::Object, &raw const crate::cruby::rb_cObject),
    (bits::BasicObject, &raw const crate::cruby::rb_cBasicObject),
  ];
}
