/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectionTest
extends TestCase {
    public void testPublicStatics() {
        Class<?> connectionClass;
        HashMap<String, Integer> thePublicStatics = new HashMap<String, Integer>();
        thePublicStatics.put("TRANSACTION_SERIALIZABLE", new Integer(8));
        thePublicStatics.put("TRANSACTION_REPEATABLE_READ", new Integer(4));
        thePublicStatics.put("TRANSACTION_READ_COMMITTED", new Integer(2));
        thePublicStatics.put("TRANSACTION_READ_UNCOMMITTED", new Integer(1));
        thePublicStatics.put("TRANSACTION_NONE", new Integer(0));
        try {
            connectionClass = Class.forName("java.sql.Connection");
        }
        catch (ClassNotFoundException e) {
            ConnectionTest.fail((String)"java.sql.Connection class not found!");
            return;
        }
        Field[] theFields = connectionClass.getDeclaredFields();
        int requiredModifier = 25;
        int countPublicStatics = 0;
        Field[] fieldArray = theFields;
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field element = fieldArray[n];
            String fieldName = element.getName();
            int theMods = element.getModifiers();
            if (Modifier.isPublic(theMods) && Modifier.isStatic(theMods)) {
                try {
                    Object fieldValue = element.get(null);
                    Object expectedValue = thePublicStatics.get(fieldName);
                    if (expectedValue == null) {
                        ConnectionTest.fail((String)("Field " + fieldName + " missing!"));
                    }
                    ConnectionTest.assertEquals((String)("Field " + fieldName + " value mismatch: "), expectedValue, (Object)fieldValue);
                    ConnectionTest.assertEquals((String)("Field " + fieldName + " modifier mismatch: "), (int)requiredModifier, (int)theMods);
                    ++countPublicStatics;
                }
                catch (IllegalAccessException e) {
                    ConnectionTest.fail((String)("Illegal access to Field " + fieldName));
                }
            }
            ++n;
        }
    }
}

