; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-unknown \
; RUN:     -mcpu=pwr6 -ppc-asm-full-reg-names -mattr=-vsx \
; RUN:     -ppc-vsr-nums-as-vr < %s | FileCheck %s

; There is code in the SDAG to expand FMAX/FMIN with fast flags to SELECT_CC.
; On PPC, we had SELECT_CC legalized using Promote for all vector types
; (including the type that they are all promoted to - which caused an infinite
; loop in legalization). This test just ensures that we terminate on such input.
define dso_local void @_ZN1a1bEv(<4 x float> %in) local_unnamed_addr #0 align 2 {
; CHECK-LABEL: _ZN1a1bEv:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bc 12, 4*cr5+lt, .LBB0_6
; CHECK-NEXT:    b .LBB0_1
; CHECK-NEXT:  .LBB0_1: # %.preheader
; CHECK-NEXT:    b .LBB0_2
; CHECK-NEXT:  .LBB0_2:
; CHECK-NEXT:    b .LBB0_3
; CHECK-NEXT:  .LBB0_3:
; CHECK-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; CHECK-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; CHECK-NEXT:    lvx v3, 0, r3
; CHECK-NEXT:    vperm v2, v2, v2, v3
; CHECK-NEXT:    vxor v3, v3, v3
; CHECK-NEXT:    addi r3, r1, -48
; CHECK-NEXT:    stvx v3, 0, r3
; CHECK-NEXT:    addi r3, r1, -32
; CHECK-NEXT:    stvx v2, 0, r3
; CHECK-NEXT:    lwz r3, -48(r1)
; CHECK-NEXT:    lwz r4, -32(r1)
; CHECK-NEXT:    cmpw r4, r3
; CHECK-NEXT:    bc 12, gt, .LBB0_4
; CHECK-NEXT:    b .LBB0_5
; CHECK-NEXT:  .LBB0_4:
; CHECK-NEXT:    addi r3, r4, 0
; CHECK-NEXT:  .LBB0_5:
; CHECK-NEXT:    cmpw r3, r3
; CHECK-NEXT:    stw r3, -64(r1)
; CHECK-NEXT:    addi r3, r1, -64
; CHECK-NEXT:    lvx v2, 0, r3
; CHECK-NEXT:    addi r3, r1, -16
; CHECK-NEXT:    stvx v2, 0, r3
; CHECK-NEXT:  .LBB0_6:
; CHECK-NEXT:    blr
  br i1 undef, label %7, label %1

1:                                                ; preds = %1, %0
  br i1 undef, label %2, label %1

2:                                                ; preds = %1
  %3 = shufflevector <4 x float> %in, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 1, i32 0>
  %4 = call fast <4 x float> @llvm.maxnum.v4f32(<4 x float> %3, <4 x float> zeroinitializer)
  %5 = call fast <4 x float> @llvm.maxnum.v4f32(<4 x float> %4, <4 x float> undef)
  %6 = extractelement <4 x float> %5, i32 0
  br label %7

7:                                                ; preds = %2, %0
  %8 = phi float [ %6, %2 ], [ undef, %0 ]
  %9 = fcmp fast une float %8, 0.000000e+00
  ret void
}

declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>) #0

attributes #0 = { nounwind optnone noinline }
