/*
 * window.h: header file for window.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef _WINDOW_H_
#define _WINDOW_H_

/*
 * Define this if you want to play with the new window feature, 
 * CREATE, that allows you to start new iscreen or xterm windows
 * connected to the ircII client.
 */
#define	WINDOW_CREATE

/*
 * Define this if you want ircII to scroll after printing a line,
 * like it used to (2.1.5 and back era), not before printing the
 * line.   Its a waste of a line to me, but what ever people want.
 * Thanks to Veggen for telling me what to do for this.
 */
#undef SCROLL_AFTER_DISPLAY

#include "hold.h"
#include "lastlog.h"
#include "edit.h"

/* used by the update flag to determine what needs updating */
#define REDRAW_DISPLAY_FULL 1
#define REDRAW_DISPLAY_FAST 2
#define UPDATE_STATUS 4
#define REDRAW_STATUS 8

#ifndef	_MENU_H_
struct	MenuTag;
typedef struct	MenuTag	Menu;
#endif

struct	WindowMenuTag
{
	Menu	*menu;
	int	lines;
	int	items_per_line;
	int	cursor;
};

typedef	struct	WindowMenuTag	WindowMenu;

/* NickList: structure for the list of nicknames of people on a channel */
typedef struct nick_stru
{
	struct	nick_stru	*next;	/* pointer to next nickname entry */
	char	*nick;			/* nickname of person on channel */
	int	chanop;			/* True if the given nick has chanop */
}	NickList;

typedef	struct	DisplayStru
{
	char	*line;
	int	linetype;
	struct	DisplayStru	*next;
}	Display;

#define	WAIT_PROMPT_LINE	0x01
#define WAIT_PROMPT_KEY		0x02

typedef struct PromptStru
{
	char	*prompt;
	char	*data;
	int	type;
	void	(*func)();
	struct	PromptStru	*next;
}	WaitPrompt;

#define	LT_UNLOGGED	0
#define	LT_LOGHEAD	1
#define	LT_LOGTAIL	2
struct	ScreenStru;

typedef	struct	WindowStru
{
	unsigned int	refnum;		/* the unique reference number,
					 * assigned by IRCII */
	char	*name;			/* window's logical name */
	int	server;			/* server index */
	int	top;			/* The top line of the window, screen
					 * coordinates */
	int	bottom;			/* The botton line of the window, screen
					 * coordinates */
	int	cursor;			/* The cursor position in the window, window
					 * relative coordinates */
	int	line_cnt;		/* counter of number of lines displayed in
					 * window */
	int	scroll;			/* true, window scrolls... false window wraps */
	int	display_size;		/* number of lines of window - menu lines */
	int	old_size;		/* if new_size != display_size,
					 * resize_display is called */
	int	visible;		/* true, window is drawn... false window is
					 * hidden */
	int	update;			/* window needs updating flag */
	unsigned miscflags;		/* Miscellaneous flags. */

	char	*prompt;		/* A prompt string, usually set by EXEC'd process */
	char	*status_line;		/* The status line string */

	Display	*top_of_display,	/* Pointer to first line of display structure */
		*display_ip;		/* Pointer to insertiong point of display
					 * structure */

	char	*current_channel;	/* Window's current channel */
	char	*query_nick;		/* User being QUERY'ied in this window */
	NickList	*nicks;		/* List of nicks that will go to window */
	int	window_level;		/* The LEVEL of the window, determines what
					 * messages go to it */

	/* hold stuff */
	int	hold_mode;		/* true, hold mode is on for window...
					 * false it isn't */
	int	hold_on_next_rite;	/* true, the next call to rite() will
					 * activate a hold */
	int	held;			/* true, the window is currently being
					 * held */
	int	last_held;		/* Previous value of hold flag.  Used
					 * for various updating needs */
	Hold	*hold_head,		/* Pointer to first entry in hold
					 * list */
		*hold_tail;		/* Pointer to last entry in hold list */
	int	held_lines;		/* number of lines being held */
	int	scrolled_lines;		/* number of lines scrolled back */
	WindowMenu	menu;		/* The menu (if any) */

	/* lastlog stuff */
	Lastlog	*lastlog_head;		/* pointer to top of lastlog list */
	Lastlog	*lastlog_tail;		/* pointer to bottom of lastlog list */
	int	lastlog_level;		/* The LASTLOG_LEVEL, determines what
					 * messages go to lastlog */
	int	lastlog_size;		/* Max number of messages for the window
					 * lastlog */

	char	*waiting_channel;	/* The channel that you _want_ to be on
					 * this window .. derived from a real
					 * fix for the phone bug */
	char	*logfile;		/* window's logfile name */
	/* window log stuff */
	int	log;			/* true, file logging for window is on */
	FILE	*log_fp;		/* file pointer for the log file */

	struct	ScreenStru	*screen;

	struct	WindowStru	*next;	/* pointer to next entry in window list (null
					 * is end) */
	struct	WindowStru	*prev;	/* pointer to previous entry in window list
					 * (null is end) */
}	Window;

/*
 * WindowStack: The structure for the POP, PUSH, and STACK functions. A
 * simple linked list with window refnums as the data 
 */
typedef	struct	window_stack_stru
{
	unsigned int	refnum;
	struct	window_stack_stru	*next;
}	WindowStack;

extern	Window	*to_window;
typedef	struct	ScreenStru
{
	int	screennum;
	Window	*current_window;
	unsigned int	last_window_refnum;	/* reference number of the
						 * window that was last
						 * the current_window */
	Window	*window_list;			/* List of all visible
						 * windows */
	Window	*window_list_end;		/* end of visible window
						 * list */
	Window	*cursor_window;			/* Last window to have
						 * something written to it */
	int	visible_windows;		/* total number of windows */
	WindowStack	*window_stack;		/* the windows here */

	int	meta1_hit;			/* if meta1 is hit in this
						 * screen or not */
	int	meta2_hit;			/* above, for meta2 */
	int	meta3_hit;			/* above, for meta3 */
	int	meta4_hit;			/* above, for meta4 */
	int	quote_hit;			/* true if a key bound to
						 * QUOTE_CHARACTER has been
						 * hit. */
	int	digraph_hit;			/* A digraph key has been hit */
	int	inside_menu;			/* what it says. */

	unsigned char	digraph_first;

	struct	ScreenStru *prev;		/* These are the Screen list */
	struct	ScreenStru *next;		/* pointers */

	FILE	*fpin;				/* These are the file pointers */
	int	fdin;				/* and descriptions for the */
	FILE	*fpout;				/* screen's input/output */
	int	fdout;

	char	input_buffer[INPUT_BUFFER_SIZE+1];	/* the input buffer */
	int	buffer_pos;			/* and the positions for the */
	int	buffer_min_pos;			/* screen */

	char	saved_input_buffer[INPUT_BUFFER_SIZE+1];
	int	saved_buffer_pos;
	int	saved_min_buffer_pos;

	WaitPrompt	*promptlist;

	char	*redirect_name;
	char	*redirect_token;
	int	redirect_server;

	int	alive;
}	Screen;

extern	Screen	*current_screen;
extern	Screen	*screen_list;
extern	Screen	*last_input_screen;

typedef	struct
{
	int	top;
	int	bottom;
	int	position;
}	ShrinkInfo;

extern	void	set_scroll_lines();
extern	void	set_scroll();
extern	void	reset_line_cnt();
extern	void	set_continued_line();
extern	void	set_underline_video();
extern	int	rite();
extern	void	erase_display();
extern	ShrinkInfo	resize_display();
extern	void	redraw_all_windows();
extern	void	add_to_screen();
extern	void	init_windows();
extern	int	unhold_windows();
extern	Window	*traverse_all_windows();

/* var_settings indexes */
#define OFF 0
#define ON 1
#define TOGGLE 2

extern	void	erase_display();
extern	void	redraw_display();
extern	void	add_to_display();
extern	void	set_scroll();
extern	void	set_menu();
extern	void	set_scroll_lines();
extern	int	display_hold();
extern	void	update_all_status();
extern	void	set_query_nick();
extern	char	*query_nick();
extern	void	set_current_dcc();
extern	char	*current_dcc();
extern	void	update_window_status();
extern	void	window();
extern	void	redraw_window();
extern	void	redraw_all_windows();
extern	void	next_window();
extern	void	swap_last_window();
extern	void	swap_next_window();
extern	void	previous_window();
extern	void	swap_previous_window();
extern	void	back_window();
extern	void	window_kill_swap();
extern	int	is_current_channel();
extern	void	redraw_all_status();
extern	void	message_to();
extern	void	message_from();
extern	void	unstop_all_windows();
extern	void	update_all_windows();
extern	Window	*new_window();
extern	void	set_display();
extern	unsigned int	window_display;

extern	int	is_main_screen();
extern	void	kill_screen();

extern	void	set_prompt_by_refnum();
extern	void	clear_window_by_refnum();
extern	unsigned int	current_refnum();
extern	Window	*get_window_by_refnum();
extern	char	*get_target_by_refnum();
extern	char	*get_prompt_by_refnum();
extern	char	*set_channel_by_refnum();
extern	char	*get_channel_by_refnum();
extern	void	set_window_server();
extern	Window	*get_window_by_name();
extern	void	window_redirect();

#define WINDOW_NOTIFY	((unsigned) 0x0001)
#define WINDOW_NOTIFIED	((unsigned) 0x0002)

/* Stuff for the screen/xterm junk */

#define ST_NOTHING      -1
#define ST_SCREEN       0
#define ST_XTERM        1

/* This is here because it happens in so many places */
#define curr_scr_win	current_screen->current_window
#endif /* _WINDOW_H_ */
