'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_WatchInterp.man,v 1.1 89/05/15 16:15:39 ouster Exp $ SPRITE (Berkeley)
'/" 
.so \*(]ltmac.sprite
.HS Tcl_WatchInterp tcl
.VS
.BS
.SH NAME
Tcl_WatchInterp \- arrange for callback when interpreter is deleted.
.SH SYNOPSIS
\fB#include <tcl.h>\fR
.sp
\fBTcl_WatchInterp\fR(\fIinterp\fR, \fIproc\fR, \fIclientData\fR)
.SH ARGUMENTS
.AS ClientData (*deleteProc)()
.AP Tcl_Interp *interp in
Interpreter whose deletion should be monitored.
.AP char *cmdName in
Name of new command.
.AP void (*proc)() in
Procedure to invoke just before \fIinterp\fR is deleted.
.AP ClientData clientData in
Arbitrary one-word value to pass to \fIproc\fR.
.BE

.SH DESCRIPTION
.PP
\fBTcl_WatchInterp\fR arranges for \fIproc\fR to be called by
\fBTcl_DeleteInterp\fR if/when \fIinterp\fR is deleted at some future
time.  \fIProc\fR will be invoked just before the interpreter
is deleted, but the interpreter will still be valid at the
time of the call.  \fIProc\fR should have the following structure:
.nf
.RS
void
proc(\fIclientData\fR, \fIinterp\fR)
.RS
ClientData \fIclientData\fR;
Tcl_Interp *\fIinterp\fR;
.RE
{
}
.RE
.fi
The \fIclientData\fP and \fIinterp\fR parameters are
copies of the \fIclientData\fP and \fIinterp\fR arguments given
to \fBTcl_WatchInterp\fR.
Typically, \fIclientData\fR points to an application-specific
data structure that \fIproc\fR uses to perform cleanup when an
interpreter is about to go away.  \fIProc\fR does not return
a value.

.SH KEYWORDS
callback, delete, interpreter
.VE
