/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
#include "XMMrm.hh"
#include <stdio.h>

 XMMrm::XMMrm ()
{
  MrmInitialize ();
};


// ---------------------------------------------------------------------------
     XMMrm::XMMrm (MrmCount num, String names[], MrmOsOpenParamPtr* list)
// ---------------------------------------------------------------------------
{
      MrmInitialize ();
     if ( MrmOpenHierarchy (num, names, list, hier) != MrmSUCCESS)
      printf ("can't open hierarchy\n");
};

// ---------------------------------------------------------------------------
     XMMrm::~XMMrm ()
// ---------------------------------------------------------------------------
{
  // return value is going to waste
  MrmCloseHierarchy (*hier);
}

// ---------------------------------------------------------------------------
   int XMMrm::FetchColorLiteral (String s, Display* d, Colormap c, Pixel* p)
// ---------------------------------------------------------------------------
{
   return (MrmFetchColorLiteral (*hier, s, d, c, p));
}

// ---------------------------------------------------------------------------
   int XMMrm::FetchIconLiteral (String st, Screen* sc, Display* d,
                                Pixel p1, Pixel p2, Pixmap* p3)
// ---------------------------------------------------------------------------
{
  return (MrmFetchIconLiteral (*hier, st, sc, d, p1, p2, p3));
}

// ---------------------------------------------------------------------------
   Cardinal XMMrm::FetchInterfaceModule (char* c, XMObject* o1, XMObject* o2)
// ---------------------------------------------------------------------------
{
//   return (MrmFetchInterfaceModule (hier, c, o1->get_widget(),
//                                    o2->get_widget()));
}

// ---------------------------------------------------------------------------
   int XMMrm::FetchLiteral (String s, Display* d, caddr_t* c, MrmCode* m)
// ---------------------------------------------------------------------------
{
  return (MrmFetchLiteral (*hier, s, d, c, m));
}

// ---------------------------------------------------------------------------
   Cardinal XMMrm::FetchSetValues (XMObject* o1, ArgList a, Cardinal c)
// ---------------------------------------------------------------------------
{
  return (MrmFetchSetValues (*hier, o1->get_widget(), a, c));
}

// ---------------------------------------------------------------------------
   XMObject* XMMrm::FetchWidget (String s, XMObject o1 , MrmType m)
// ---------------------------------------------------------------------------
{
      Widget temp1;
      XMObject* temp2 = new XMObject;
      MrmFetchWidget (*hier, s, o1.get_widget(), &temp1, &m);
      temp2->w = temp1;
      cb_associate (temp1, temp2);
      return (temp2);
}

// ---------------------------------------------------------------------------
   Cardinal XMMrm::FetchWidgetOverride  (String s1, XMObject* o1, String s2,
                                         ArgList a, Cardinal c,
                                         XMObject* o2, MrmType* m)
// ---------------------------------------------------------------------------
{
//  return (MrmFetchWidgetOverride (hier, s1, o1->get_widget(), s2, a, c
//                                    o2->get_widget(), m));
}

// ---------------------------------------------------------------------------
   Cardinal XMMrm::FetchRegisterClass   (MrmType m, String s1, String s2,
                                         XMObject* o1, WidgetClass w)
// ---------------------------------------------------------------------------
{
//  return (MrmFetchRegisterClass (m, s1, s2, o1->get_widget(), w));
}

// ---------------------------------------------------------------------------
   Cardinal XMMrm::RegisterNames   (MrmRegisterArglist m1, MrmCount m2)
// ---------------------------------------------------------------------------
{
  return (MrmRegisterNames (m1, m2));
}
