//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: MBN 12/15/89 -- Made case-flag optional on is_equal, is_not_equal
// Updated: LGO 01/05/90 -- Split into seperate files
// Updated: MJF 05/22/90 -- Fixed is_eqaul to return properly
// Updated: DLS 03/22/91 -- New lite version
//

#include <cool/char.h>		// Include char* specification header file

#if defined(DOS)
extern "C" {
#include <ctype.h>		// Include character processing macros
}
#else
#include <ctype.h>		// Include character processing macros
#endif

Boolean is_equal (const char* c1, const char* c2, Boolean case_flag) {
  if (case_flag == SENSITIVE) {			// Case sensitive
    for ( ; *c1 == *c2; c1++, c2++)		// For each character in string
      if (*c1 == END_OF_STRING)			// If end of first string
	return TRUE;				// Match found, return TRUE
    return (*c1 == *c2) ? TRUE : FALSE;		// Return match result
  }
  else {					// Case insensitive
    for ( ; *c1 == *c2 || TO_UPPER (*c1) == TO_UPPER (*c2); c1++, c2++)
      if (*c1 == END_OF_STRING)			// If end of first string
	return TRUE;				// Match found, return TRUE
    // Return match result
    return (*c1 == *c2 || TO_UPPER (*c1) == TO_UPPER (*c2)) ? TRUE : FALSE;
  }
}


Boolean is_not_equal (const char* c1, const char* c2, Boolean case_flag) {
  return (!is_equal (c1, c2, case_flag));
}
