//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
//
// Created: MBN 09/01/89 -- Initial design and implementation
// Updated: LGO 12/04/89 -- Efficiency re-write
// Updated: MJF 07/31/90 -- Added terse print
// Updated: DLS 03/27/91 -- New lite version
//
// The  Range class implements non-type specific  common  functionality for the
// parameterized Range<Type>. In this manner, code replication is  reduced. The
// Range<Type> class  supports  arbitrary user-defined ranges  for  a  type  of
// object or built-in data type. This allows other higher level data structures
// such as Vector to be parameterized over a  range of values  for some type so
// that   the  programmer  does  not have  to add  bounds  checking code to the
// application.  A Vector of positive integers, for  example, would be  easy to
// declare, facilitating bounds checking restricted to the code that implements
// the type, not the vector.
//
// The inclusive upper and lower bounds for the range are stored in two private
// static data slots for the class as a  whole.  In addition, a single instance
// private  data slot holds the instance  value. There are  three constructors.
// The first is a simple  empty constructor. The second  is a constructor  that
// also accepts an  initial value. And the third  is a constructor that takes a
// reference to another Range<Type> object and copies the value.
//
// All methods are implemented as  small inline  functions to provide efficient
// encapsulation of objects, including built-in types such as  int. Methods are
// provided to set and get the lower and upper bounds for the  class as a whole
// and set the  value of the  instance data  slot. Assignment of  one object to
// another is supported by the overloaded operator=  methods.  Operator() is an
// inline  method to  return  the value of  the  instance  object.  Finally, an
// implicit conversion from a Range<Type> object to a Type value is provided to
// allow for mixed expressions.
//

#ifndef BASE_RANGEH				// If no Range class
#define BASE_RANGEH

#ifndef STREAMH			// If the Stream support not yet defined,
#if defined(DOS) || defined(M_XENIX)
#include <stream.hxx>		// include the Stream class header file
#else
#include <stream.h>		// include the Stream class header file
#endif
#define STREAMH
#endif

#define MSG_MAX 256


class Base_Range {
protected:
  static char msg_buffer[MSG_MAX];

  Base_Range() {}				// Protected constructor
  void set_low_error (const char*, const char*) const;   // Raise exception
  void set_upper_error (const char*, const char*) const; // Raise exception
public:
  void print(ostream&);                         // terse print
};

#endif						// End #ifdef of BASE_RANGEH
