//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 08/31/89 -- Initial design and implementation
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>			// Include the class header

// remove_error -- Raise exception for Vector<Type>::remove()
// Input:          Type string
// Output:         None

void Vector::remove_error (const char* Type) CONST {
  RAISE (Error, SYM(Vector), SYM(Invalid_Cpos),
	 "Vector<%s>::remove(): Invalid current position", Type);
}
