//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: DKM 07/07/89 -- To work around Xenix 31 char limit:
//                          Shortened is_less_than        to is_lt
//                                    is_greater_than     to is_gt
//                                    is_less_or_equal    to is_le
//                                    is_greater_or_equal to is_ge
// Updated: MBN 12/15/89 -- Made case-flag optional on is_equal, is_not_equal
//
// This   header  file   defines function   prototypes   for extended    char*
// functionality patterned after  that of the  String class. This will allow a
// programmer to chose char* or String strings  for an application  based upon
// the needs of the program and not the availability  of a particular function
// or functions. Note  that there  is no attempt  to  allocate  or  deallocate
// memory.  Functions for  comparison (both case  sensitive  and insensitive),
// case conversion and  string  token  trimming are provided.   All  functions
// assume pointer operands are passed.
//

#ifndef CHARH			// If not yet defined,
#define CHARH			// Indicate that char* header defined

#ifndef C_STRINGH
#if defined(DOS)		// If String support not yet defined,
extern "C" {
#include <string.h>		// Include standard string header file
}
#else
#include <string.h>		// Include standard string header file
#endif
#define C_STRINGH
#endif

#ifndef STREAMH			// If the Stream support not yet defined,
#if defined(DOS) || defined(M_XENIX)
#include <stream.hxx>		// include the Stream class header file
#else
#include <stream.h>		// include the Stream class header file
#endif
#define STREAMH
#endif

#ifndef MISCELANEOUSH				// If no misc.h file
#include <cool/misc.h>				// Include useful defintions
#endif	

void reverse (char*);		// Reverse character order in string

extern Boolean is_equal_n (const char*, const char*, int n,
			   Boolean case_flag=INSENSITIVE);

extern Boolean is_equal (const char*, const char*,
			 Boolean case_flag=INSENSITIVE);

extern Boolean is_not_equal (const char*, const char*,
			     Boolean case_flag=INSENSITIVE);

extern Boolean is_lt (const char*, const char*, Boolean);
extern Boolean is_gt (const char*, const char*, Boolean);
extern Boolean is_le (const char*, const char*, Boolean);
extern Boolean is_ge (const char*, const char*, Boolean);

extern char* c_trim (char*, const char*);	// Trim characters from string
extern char* c_left_trim (char*, const char*);	// Trim prefix characters
extern char* c_right_trim (char*, const char*);	// Trim suffix characters

extern char* c_upcase (char*);			// Convert string to upper case
extern char* c_downcase (char*);		// Convert string to lower case
extern char* c_capitalize (char*);		// Capitalize each word 
extern char* strfind (const char*, const char*, long* start=0, long* end=0);
extern char* strrfind (const char*, const char*, long* start=0, long* end=0);
extern char* strnremove (char*, long);
extern char* strndup (const char*, long);
extern char* strnyank (char*, long);

#if defined(DOS)		// ANSI definition is correct, and small
#  define TO_UPPER toupper
#else				// Else make a fast version
extern const char upcharmap[256];
#  define TO_UPPER(x) upcharmap[x]
#endif

#endif						// End #ifdef of CHARH


