//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/19/89 -- Initial design and implementation
// Updated: MBN 09/18/89 -- Changed package name to uppercase
// Updated: MJF 07/31/90 -- Added terse print

#include <cool/Generic.h>

#if GENERIC_TYPECHECK

// Print self on ostream
void Generic::print_self(ostream& os) CONST {
  os << "Error: class " << this->type_of() << " has no print method";
}

// Print type of object
void Generic::print(ostream& os) {
  os << form("/* %s %lh */", this->type_of()->name(), (long) this);
}

// Print a Pointer to a generic object
ostream& operator<< (ostream& os , const Generic* thing) {
  thing->print_self(os);
  return os;
}

// Print a reference to a generic object
ostream& operator<< (ostream& os , const Generic& thing) {
  thing.print_self(os);
  return os;
}

#else // NO GENERIC_TYPECHECK

// Print a Pointer to a generic object
ostream& operator<< (ostream& os , const Generic* thing) {
  thing->print_self(os);
  return os;
}

// Print a reference to a generic object
// This should never be executed, because all
// superclasses of Generic should over-ride this.
// (should this be left out, so users get compile errors?)
ostream& operator<< (ostream& os , const Generic& thing) {
  os << form("/* Generic %lx */", (long) &thing);
  return os;
}

#endif // GENERIC_TYPECHECK
