//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MBN 09/18/89 -- Changed package names to uppercase
// Updated: MJF 02/22/90 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed to delete array of exception types.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// **********************************************************************
// Destructor for the Excp_Handler class
// **********************************************************************

// ~Excp_Handler() -- the Exception Handler destructor which removes this
//                    handler object from the global list of Exception Handlers
//                    and deletes the array of exception types.
//
// Input:   None.
// Output:  None.

Excp_Handler::~Excp_Handler() {
 if (this->top_handler != this)
   cout << "Warning: Removing Exception Handler in middle of handler list.\n";
 if (this->excp_types != NULL) {
   int n;
   for (n = 1; this->excp_types[n] != NULL; n++);
   delete [n] this->excp_types;
 }
 this->top_handler = this->next_handler;
}
