(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Error.i3                                              *)
(* Last modified on Wed Apr 15 09:54:52 PDT 1992 by kalsow     *)
(*      modified on Fri Mar 22 08:29:20 1991 by muller         *)

INTERFACE Error;

IMPORT String;

PROCEDURE Msg (msg: TEXT);
PROCEDURE Int (n: INTEGER;  msg: TEXT);
PROCEDURE Str (s: String.T;  msg: TEXT);
PROCEDURE QID (READONLY q: String.QID;  msg: TEXT);
PROCEDURE ID  (id, msg: TEXT);

PROCEDURE Warn    (level: INTEGER;  msg: TEXT);
PROCEDURE WarnStr (level: INTEGER;  s: String.T;  msg: TEXT);

PROCEDURE IgnoreWarning (offset: INTEGER);

PROCEDURE Info (msg: TEXT);

PROCEDURE Count (VAR nErrors, nWarnings: INTEGER);

PROCEDURE Reset ();

END Error.

(***************************
Error levels:

  0 - informational messages
  1 - "fussy" warnings  (i.e. unsued formals, incomplete CASE...)
  2 - warnings
  3 - errors

***************************)
