(* FileSys.m3
|  ----------

Carsten Weich, Sep. 1993
******************************************************************)

MODULE FileSys;

IMPORT List, System, Text, Char, Fmt;

CONST MaxCmdlineLen = 1024;


(* Change to all lower-case letters *)

PROCEDURE Caps (t: TEXT): TEXT =
    VAR result := "";
    BEGIN
        FOR i := 0 TO Text.Length(t) - 1 DO
            VAR c := Text.GetChar(t, i);
            BEGIN
                IF c >= 'A' AND c <= 'Z' THEN
                    c := VAL(ORD(c) + ORD('a') - ORD('A'), CHAR);
                END;
                result := result & Fmt.Char(c);
            END;
        END;
        RETURN result;
    END Caps;


(* Replace the shell-like wildcards to regular-expression equivalents *)

PROCEDURE ChangeToRegExpr (name: TEXT): TEXT =
    CONST Specials = ".^$";
    VAR
        result: ARRAY [0 .. MaxCmdlineLen-1] OF CHAR;
        i := 0;
        len := Text.Length(name);
    PROCEDURE Insert(c: CHAR) =
        BEGIN
            SUBARRAY(result, i+1, len-i+1) := SUBARRAY(result, i, len-i+1);
            result[i] := c;
            INC(len); INC(i);
        END Insert;
    BEGIN
        Text.SetChars(result, name);
        result[len] := Char.NUL;
        WHILE result[i] # Char.NUL DO
            IF result[i] = '\\' THEN result[i] := '/' END;
            IF result[i] = '*' THEN Insert('.') END;
            IF Text.FindChar(Specials, result[i])>=0 THEN Insert('\\') END;
            IF result[i] = '?' THEN result[i] := '.' END;
            INC(i);
        END;
        RETURN "^" & Text.FromChars(SUBARRAY(result, 0, len)) & "$";
    END ChangeToRegExpr;


(* Replace / to \ and vice versa *)

PROCEDURE ChangeSlash (t: TEXT): TEXT =
    VAR
        result: ARRAY [0 .. MaxCmdlineLen-1] OF CHAR;
        i := 0;
        len := Text.Length(t);
    BEGIN
        Text.SetChars(result, t);
        WHILE i < len DO
            IF result[i] = '/' THEN result[i] := '\\' END;
            INC(i);
        END;
        RETURN Text.FromChars(SUBARRAY(result, 0, len));
    END ChangeSlash;

PROCEDURE ChangeBackslash (t: TEXT): TEXT =
    VAR
        result: ARRAY [0 .. MaxCmdlineLen-1] OF CHAR;
        i := 0;
        len := Text.Length(t);
    BEGIN
        Text.SetChars(result, t);
        WHILE i < len DO
            IF result[i] = '\\' THEN result[i] := '/' END;
            INC(i);
        END;
        RETURN Text.FromChars(SUBARRAY(result, 0, len));
    END ChangeBackslash;


(* Scanning one directory *)

PROCEDURE GetDirList (path := "."; expr := ".*"): List.T
    RAISES {System.Error} =
    VAR
        dir: System.Dir;
        entry: TEXT;
        dirlist: List.T:= NIL;
    BEGIN
        dir := System.OpenDir(path);
        LOOP
            entry := System.GetnextDirentry(dir);
            IF entry = NIL THEN EXIT END;
            IF System.TestRegExpr(Caps(entry), Caps(expr)) THEN
                List.Push(dirlist, entry);
            END;
        END;
        System.CloseDir(dir);
        RETURN dirlist;
    END GetDirList;

BEGIN
END FileSys.
