INTERFACE SF;  (*SimpleFiles 14.04.94. LB*)

(*SimpleFiles provides simple procedures
  to connect readers and writers with files ("Open" procedures),
  and to decouple them ("Close" procedures).
  "OpenRead" connects a reader to an existing file,
  "OpenWrite" connects a writer to a new file.
  If the file with the given name already exists,
  the user may type in a new name or let it overwrite.
  "OpenAppend" positions the writer at the end of a file.
  The text in parameter "prompt" is displayed on standardout (screen).
  The file connected to a writer is made permanent by a "CloseWrite".

  SimpleFiles provides a flexible mechanism for file naming.
  If the "name" parameter is omitted (or NIL) at opening, then
  the opening procedures ask the user for a file name.
  If the user enters an empty line or Std (actually = "#")
  the file defaults to standard i/o,
  i.e. normally to keyboard (standardin) and screen (standardout).
  "GetFileName" provides more explicit control over file naming. *)

  IMPORT Rd, Wr;

  CONST
	 Overwrite   = "!";
         Standard    = "#";
	 PromptStart = "Type file name ";    
	 PromptEnd   = " or NL or for standard = ";
	 InPrompt    = PromptStart & "for  input" & PromptEnd;
	 OutPrompt   = PromptStart & "for output" & PromptEnd;
	 AppPrompt   = PromptStart & "for append" & PromptEnd;

  TYPE
	 Reader = Rd.T;
	 Writer = Wr.T;

	 
  PROCEDURE OpenRead(name: TEXT := NIL; prompt:= InPrompt): Reader;
  (*Connects the file, called "name" to a reader.
    If "name" is NIL, or the file does not exists,
    it asks the user for a file name until the file can be opened.
    It returns Stdio.stdin if the user enters "return" or Std ("#").*)

  PROCEDURE OpenWrite(name: TEXT := NIL; prompt:= OutPrompt;
                      overwrite:= FALSE): Writer;
  (*Connects a writer to the file, called "name".
    If "name" is NIL it asks the user for a file name.
    It returns Stdio.stdout if the user enters "return" or Std ("#").
    If the file (given in "name" or typed in by the user) already exists,
    and "overwrite" is false, it prompts the user to give another file name 
    or to type constant Overwrite (actually = "!") for overwriting.
    If parameter "overwrite" is true, an existing file with same name
    will be overwritten, without asking the interactive user.*)

  PROCEDURE OpenAppend(name: TEXT := NIL; prompt:= AppPrompt): Writer;
  (*Connects a writer to the file, called "name".
    If "name" is NIL it asks the user for a file name.
    It returns Stdio.stdout if the user enters "return" or Std ("#").
    Creates a new file, if the specifeid file doesn't exist yet.
    If the file already exists, it positions the writer to the end of it.*)
  (*!!! Currently doesn't work on the PC !!! - it doesn't append*)

  PROCEDURE FileExists(name: TEXT): BOOLEAN;
  (*Returns TRUE iff the file exists.*)

  PROCEDURE CloseRead(VAR rd: Reader);
  (*Closes the file. Assigns NIL to rd - except rd is stdin.*)

  PROCEDURE CloseWrite(VAR wr: Writer);
  (*Flushes the writer and closes the file. 
    Assigns NIL to wr - except wr is stdout.
    Close MUST be called if the content of the writer
    should be made permanent!*)

  PROCEDURE GetFileName(prompt:= PromptStart & PromptEnd): TEXT;
  (*Asks the user for a file name - actually a simple text.
    It is the very same procedure used by OpenRead and OpenWrite.*)

END SF.
