(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Thu Sep 15 02:38:28 1988               *)
(* Last modified on Tue Feb 11 21:39:44 PST 1992 by muller     *)
(*      modified on Thu Oct 25  9:14:41 PDT 1990 by stolfi     *)

INTERFACE IntensityScale;

(* Tables of light intensities.

  This interface defines light intensity tables (for imaging and color
  applications), and procedures for handling them.

  Index: colors; light intensities; graphics, colors.
*)

IMPORT Intensity;

TYPE
  T = ARRAY OF REAL; (* A list of intensity values. *)

PROCEDURE New (n: CARDINAL; a, b: Intensity.T; ratio: REAL := 1.0e+00): REF T;
  (* 
    Returns an array /s/ of /n/ intensity levels starting with /a/ and ending 
    with /b/. The gaps between sucessive levels increase in a geometric 
    progression with the given ratio; if ratio=1.0 (the default), the 
    levels are equally spaced.  *)

PROCEDURE Equal (READONLY a, b: T; err: REAL:=1.0e-6; small: REAL:=1.0e-30): BOOLEAN;
  (* 
    TRUE if a and b are approximately equal; that is, if
    Intensity.Equal(a[i], b[i], err, small) for all i. *)

END IntensityScale.

